/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.sparql.template;

import com.github.jsonldjava.shaded.com.google.common.base.CharMatcher;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.Map;
import org.eclipse.rdf4j.common.net.ParsedIRI;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.springframework.stereotype.Service;

@Service
public class ValueParser {
    private static final SimpleValueFactory FACTORY = SimpleValueFactory.getInstance();
    private static final String FORBIDDEN_SYMBOLS = "%<>\\{}|^` \"";
    public static final String ID_TAG = "@id";
    public static final String VALUE_TAG = "@value";
    public static final String TYPE_TAG = "@type";
    public static final String LANGUAGE_TAG = "@language";
    private Object obj;

    @Nullable
    public Value parse(Object obj) throws ValueParserException {
        this.obj = obj;
        return this.getValue();
    }

    private Value getValue() {
        if (this.obj == null) {
            return null;
        }
        Class<?> klass = this.obj.getClass();
        if (BigDecimal.class.equals(klass)) {
            return FACTORY.createLiteral((BigDecimal)this.obj);
        }
        if (BigInteger.class.equals(klass)) {
            return FACTORY.createLiteral((BigInteger)this.obj);
        }
        if (Long.class.equals(klass)) {
            return FACTORY.createLiteral(((Long)this.obj).longValue());
        }
        if (Integer.class.equals(klass)) {
            return FACTORY.createLiteral(((Integer)this.obj).intValue());
        }
        if (Short.class.equals(klass)) {
            return FACTORY.createLiteral(((Short)this.obj).shortValue());
        }
        if (Byte.class.equals(klass)) {
            return FACTORY.createLiteral(((Byte)this.obj).byteValue());
        }
        if (Double.class.equals(klass)) {
            return FACTORY.createLiteral(((Double)this.obj).doubleValue());
        }
        if (Float.class.equals(klass)) {
            return FACTORY.createLiteral(((Float)this.obj).floatValue());
        }
        if (Boolean.class.equals(klass)) {
            return FACTORY.createLiteral(((Boolean)this.obj).booleanValue());
        }
        if (this.obj instanceof Map) {
            return new mapParser((Map)this.obj).parse();
        }
        String s = String.valueOf(this.obj);
        if (s.isEmpty()) {
            return null;
        }
        if (this.isValidIri(s)) {
            return FACTORY.createIRI(s);
        }
        return FACTORY.createLiteral(s);
    }

    private boolean isValidIri(String iriString) {
        if (!iriString.startsWith("http") || iriString.contains("\u0000") || CharMatcher.anyOf((CharSequence)FORBIDDEN_SYMBOLS).matchesAnyOf((CharSequence)iriString)) {
            return false;
        }
        return this.isParsableIri(iriString);
    }

    private boolean isParsableIri(String iriString) {
        try {
            new ParsedIRI(iriString);
        }
        catch (URISyntaxException ignore) {
            return false;
        }
        return true;
    }

    private class mapParser {
        private final IRI id;
        private final IRI type;
        private final String value;
        private final String language;
        private final STATE state;

        mapParser(Map<String, Object> input) {
            this.state = this.getValidState(input);
            this.id = this.getIri(input.get(ValueParser.ID_TAG));
            this.type = this.getIri(input.get(ValueParser.TYPE_TAG));
            this.value = this.getString(input.get(ValueParser.VALUE_TAG));
            this.language = this.getString(input.get(ValueParser.LANGUAGE_TAG));
        }

        private STATE getValidState(Map<String, Object> input) {
            int size = input.size();
            if (size == 0) {
                return STATE.EMPTY;
            }
            if (size == 1) {
                if (input.containsKey(ValueParser.ID_TAG)) {
                    return STATE.IRI;
                }
                if (input.containsKey(ValueParser.VALUE_TAG)) {
                    return STATE.VALUE;
                }
            } else if (size == 2 && input.containsKey(ValueParser.VALUE_TAG)) {
                if (input.containsKey(ValueParser.TYPE_TAG)) {
                    return STATE.TYPED_VALUE;
                }
                if (input.containsKey(ValueParser.LANGUAGE_TAG)) {
                    return STATE.LANGUAGE_VALUE;
                }
            }
            throw new ValueParserException("Can't parse " + String.valueOf(input) + " to Value.");
        }

        @Nullable
        private String getString(Object val) {
            return val == null ? null : String.valueOf(val);
        }

        @Nullable
        Value parse() {
            switch (this.state.ordinal()) {
                case 4: {
                    return null;
                }
                case 0: {
                    return this.getIri(this.id);
                }
                case 1: {
                    return FACTORY.createLiteral(this.value);
                }
                case 2: {
                    return FACTORY.createLiteral(this.value, this.type);
                }
                case 3: {
                    return FACTORY.createLiteral(this.value, this.language);
                }
            }
            throw new ValueParserException("Should not get to here. Stateless map.");
        }

        @Nullable
        private IRI getIri(Object iriObj) {
            if (iriObj == null) {
                return null;
            }
            String sIri = String.valueOf(iriObj);
            if (ValueParser.this.isParsableIri(sIri)) {
                return FACTORY.createIRI(sIri);
            }
            throw new ValueParserException("Can't parse {" + String.valueOf(iriObj) + "} to IRI.");
        }
    }

    static class ValueParserException
    extends RuntimeException {
        ValueParserException(String msg) {
            super(msg);
        }
    }

    private static enum STATE {
        IRI,
        VALUE,
        TYPED_VALUE,
        LANGUAGE_VALUE,
        EMPTY;

    }
}

