/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.sparql.template;

import com.ontotext.forest.sparql.template.SparqlTemplate;
import com.ontotext.forest.sparql.template.SparqlTemplateService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@RequestMapping(value={"/rest/repositories/{repositoryID}/sparql-templates"})
@Controller
@Tag(name="SPARQL Templates", description="Manage SPARQL query templates")
public class SparqlTemplateController {
    public static final String BASE_URL = "/rest/repositories/{repositoryID}/sparql-templates";
    public static final String EXECUTE_DESCRIPTION = "JSON document stating the variables and values to be set in the template. To execute a specific template, include \"templateId\" : \"the actual ID\" in the JSON.";
    @Autowired
    private SparqlTemplateService sparqlTemplateService;

    @Operation(summary="Get IDs of all configured SPARQL templates per current repository", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=String.class)))})})
    @GetMapping
    public ResponseEntity<?> getSparqlTemplateIDs(@PathVariable String repositoryID) {
        return new ResponseEntity(this.sparqlTemplateService.getSparqlTemplateIDs(repositoryID), (HttpStatusCode)HttpStatus.OK);
    }

    @Operation(summary="Create a new SPARQL template", responses={@ApiResponse(responseCode="201", description="Created", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="500", description="Internal Server Error", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @PostMapping
    public ResponseEntity<?> createSparqlTemplate(@Valid @RequestBody SparqlTemplate sparqlTemplate, @PathVariable String repositoryID) {
        return this.sparqlTemplateService.createSparqlTemplate(repositoryID, sparqlTemplate);
    }

    @Operation(summary="Edit an existing SPARQL template", responses={@ApiResponse(responseCode="200", description="OK", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="500", description="Internal Server Error", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @PutMapping(consumes={"text/plain"})
    public ResponseEntity<String> updateSparqlTemplate(@Parameter(description="The ID of the SPARQL template") @RequestParam String templateID, @Parameter(description="The SPARQL template content") @Valid @RequestBody String content, @PathVariable String repositoryID) {
        return this.sparqlTemplateService.editSparqlTemplate(repositoryID, new SparqlTemplate(templateID, content));
    }

    @Operation(summary="Execute an existing SPARQL template", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class)), @Content(mediaType="application/n-triples", schema=@Schema(implementation=String.class)), @Content(mediaType="text/turtle", schema=@Schema(implementation=String.class)), @Content(mediaType="application/x-turtle", schema=@Schema(implementation=String.class)), @Content(mediaType="text/n3", schema=@Schema(implementation=String.class)), @Content(mediaType="text/rdf+n3", schema=@Schema(implementation=String.class)), @Content(mediaType="application/trig", schema=@Schema(implementation=String.class)), @Content(mediaType="application/x-trig", schema=@Schema(implementation=String.class)), @Content(mediaType="application/n-quads", schema=@Schema(implementation=String.class)), @Content(mediaType="text/x-nquads", schema=@Schema(implementation=String.class)), @Content(mediaType="text/nquads", schema=@Schema(implementation=String.class)), @Content(mediaType="application/ld+json", schema=@Schema(implementation=String.class)), @Content(mediaType="application/x-ld+ndjson", schema=@Schema(implementation=String.class)), @Content(mediaType="application/rdf+json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content})})
    @PostMapping(value={"/execute"}, consumes={"application/json"})
    public ResponseEntity<String> executeSparqlTemplate(@Parameter(description="JSON document stating the variables and values to be set in the template. To execute a specific template, include \"templateId\" : \"the actual ID\" in the JSON.") @RequestBody Map<@NotNull String, Object> document, @PathVariable String repositoryID, HttpServletRequest request) {
        return this.sparqlTemplateService.executeUpdate(repositoryID, document, request);
    }

    @Operation(summary="Get a SPARQL template configuration", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @GetMapping(value={"/configuration"}, produces={"text/plain"})
    public ResponseEntity<?> getSparqlTemplateContent(@Parameter(description="The ID of the SPARQL template") @RequestParam String templateID, @PathVariable String repositoryID) {
        String smartUpdateTemplateContent = this.sparqlTemplateService.getSparqlTemplateContent(repositoryID, templateID);
        if (smartUpdateTemplateContent != null) {
            return new ResponseEntity((Object)smartUpdateTemplateContent, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((Object)String.format("A SPARQL template '%s' does not exist", templateID), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @Operation(summary="Delete an existing SPARQL template", responses={@ApiResponse(responseCode="204", description="No Content", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="500", description="Internal Server Error", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @DeleteMapping
    public ResponseEntity<?> deleteSparqlTemplate(@Parameter(description="The ID of the SPARQL template") @RequestParam String templateID, @PathVariable String repositoryID) {
        return this.sparqlTemplateService.deleteSmartUpdateTemplate(repositoryID, templateID);
    }
}

