/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.javamsalruntime;

import com.microsoft.azure.javamsalruntime.ErrorHandle;
import com.microsoft.azure.javamsalruntime.MsalInteropException;
import com.microsoft.azure.javamsalruntime.MsalRuntimeInterop;
import com.microsoft.azure.javamsalruntime.SignOutResultHandle;
import com.sun.jna.Structure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Structure.FieldOrder(value={"unused"})
public class SignOutResult
extends Structure {
    public int unused;
    private static final Logger LOG = LoggerFactory.getLogger(SignOutResult.class);
    private SignOutResultHandle resultHandle;

    public SignOutResult(SignOutResultHandle signOutResultHandle) {
        this.resultHandle = signOutResultHandle;
        this.parseSignOutResult();
    }

    void parseSignOutResult() {
        if (!this.resultHandle.isHandleValid()) {
            throw new MsalInteropException("Sign out result handle was invalid, could not parse.", "msalruntime_error");
        }
        LOG.info("Checking sign out result error.");
        ErrorHandle error = new ErrorHandle();
        MsalRuntimeInterop.ERROR_HELPER.checkMsalRuntimeError(MsalRuntimeInterop.MSALRUNTIME_LIBRARY.MSALRUNTIME_GetSignOutError(this.resultHandle, error));
        MsalRuntimeInterop.ERROR_HELPER.checkMsalRuntimeError(error);
        LOG.info("Parsing sign out result.");
    }
}

