/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.javamsalruntime;

import com.microsoft.azure.javamsalruntime.Account;
import com.microsoft.azure.javamsalruntime.AccountHandle;
import com.microsoft.azure.javamsalruntime.AuthResultHandle;
import com.microsoft.azure.javamsalruntime.ErrorHandle;
import com.microsoft.azure.javamsalruntime.HandleBase;
import com.microsoft.azure.javamsalruntime.MsalInteropException;
import com.microsoft.azure.javamsalruntime.MsalRuntimeInterop;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Structure.FieldOrder(value={"unused"})
public class AuthResult
extends Structure {
    public int unused;
    private static final Logger LOG = LoggerFactory.getLogger(AuthResult.class);
    private AuthResultHandle resultHandle;
    private String idToken;
    private String accessToken;
    private long accessTokenExpirationTime;
    private Account account;
    private String authorizationHeader;
    private Boolean isPopAuthorization;

    public AuthResult(AuthResultHandle authResultHandle) {
        this.resultHandle = authResultHandle;
        this.parseAuthResult();
    }

    public String getIdToken() {
        return this.idToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public long getAccessTokenExpirationTime() {
        return this.accessTokenExpirationTime;
    }

    public Account getAccount() {
        return this.account;
    }

    public String getAuthorizationHeader() {
        if (this.authorizationHeader == null) {
            this.authorizationHeader = HandleBase.getString(this.resultHandle, (error, authHeader, bufferSize) -> MsalRuntimeInterop.MSALRUNTIME_LIBRARY.MSALRUNTIME_GetAuthorizationHeader(this.resultHandle, authHeader, bufferSize));
        }
        return this.authorizationHeader;
    }

    public boolean isPopAuthorization() {
        if (this.isPopAuthorization == null) {
            IntByReference isPop = new IntByReference(0);
            MsalRuntimeInterop.ERROR_HELPER.checkMsalRuntimeError(MsalRuntimeInterop.MSALRUNTIME_LIBRARY.MSALRUNTIME_IsPopAuthorization(this.resultHandle, isPop));
            this.isPopAuthorization = isPop.getValue() == 1;
        }
        return this.isPopAuthorization;
    }

    void parseAuthResult() {
        if (!this.resultHandle.isHandleValid()) {
            throw new MsalInteropException("Auth result handle was invalid, could not parse.", "msalruntime_error");
        }
        LOG.info("Checking auth result error.");
        ErrorHandle error = new ErrorHandle();
        MsalRuntimeInterop.ERROR_HELPER.checkMsalRuntimeError(MsalRuntimeInterop.MSALRUNTIME_LIBRARY.MSALRUNTIME_GetError(this.resultHandle, error));
        MsalRuntimeInterop.ERROR_HELPER.checkMsalRuntimeError(error);
        LOG.info("Parsing auth result.");
        this.isPopAuthorization();
        this.parseAndSetAccessToken();
        this.parseAndSetIdToken();
        this.parseAndSetAccount();
    }

    void parseAndSetAccessToken() {
        this.accessToken = this.isPopAuthorization != false ? this.getAuthorizationHeader().split(" ")[1] : HandleBase.getString(this.resultHandle, (authResultHandle, accessToken, bufferSize) -> MsalRuntimeInterop.MSALRUNTIME_LIBRARY.MSALRUNTIME_GetAccessToken(this.resultHandle, accessToken, bufferSize));
    }

    void parseAndSetIdToken() {
        this.idToken = HandleBase.getString(this.resultHandle, (authResultHandle, rawIdToken, bufferSize) -> MsalRuntimeInterop.MSALRUNTIME_LIBRARY.MSALRUNTIME_GetRawIdToken(this.resultHandle, rawIdToken, bufferSize));
    }

    void parseAndSetAccount() {
        AccountHandle accountHandle = new AccountHandle();
        MsalRuntimeInterop.ERROR_HELPER.checkMsalRuntimeError(MsalRuntimeInterop.MSALRUNTIME_LIBRARY.MSALRUNTIME_GetAccount(this.resultHandle, accountHandle));
        this.account = new Account(accountHandle);
    }
}

