/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.javamsalruntime;

import com.microsoft.azure.javamsalruntime.AccountHandle;
import com.microsoft.azure.javamsalruntime.HandleBase;
import com.microsoft.azure.javamsalruntime.MsalRuntimeInterop;

public class Account
implements AutoCloseable {
    private AccountHandle handle;
    private String accountId;
    private String accountClientInfo;

    Account(AccountHandle accountHandle) {
        if (accountHandle.isHandleValid()) {
            this.handle = accountHandle;
        }
    }

    AccountHandle getHandle() {
        return this.handle;
    }

    public String getAccountId() {
        if (this.accountId == null) {
            this.accountId = HandleBase.getString(this.handle, (accountHandle, id, bufferSize) -> MsalRuntimeInterop.MSALRUNTIME_LIBRARY.MSALRUNTIME_GetAccountId(accountHandle.value(), id, bufferSize));
        }
        return this.accountId;
    }

    public String getClientInfo() {
        if (this.accountClientInfo == null) {
            this.accountClientInfo = HandleBase.getString(this.handle, (accountHandle, clientInfo, bufferSize) -> MsalRuntimeInterop.MSALRUNTIME_LIBRARY.MSALRUNTIME_GetClientInfo(accountHandle.value(), clientInfo, bufferSize));
        }
        return this.accountClientInfo;
    }

    @Override
    public void close() {
        if (this.handle != null) {
            this.handle.close();
            this.handle = null;
        }
    }
}

