/*
 * Decompiled with CFR 0.152.
 */
package com.github.tkurz.media.ontology.impl;

import com.github.tkurz.media.ontology.impl.Rectangle;
import com.github.tkurz.media.ontology.type.Coordinate;
import com.github.tkurz.media.ontology.type.SpatialEntity;
import com.github.tkurz.media.ontology.utils.Utils;
import java.awt.geom.Area;
import java.awt.geom.Point2D;

public class Point
extends Point2D.Double
implements SpatialEntity,
Coordinate {
    public static Point relativePoint(Point p1, Point p2) {
        return new Point(p2.x - p1.x, p2.y - p1.y);
    }

    public Point(double x, double y) {
        super(x, y);
    }

    @Override
    public String toString() {
        return this.doubleToString(this.x) + "," + this.doubleToString(this.y);
    }

    private String doubleToString(double d) {
        if ((double)((int)d) == d) {
            return Integer.toString((int)d);
        }
        return String.valueOf(d);
    }

    @Override
    public Coordinate getCenter() {
        return this;
    }

    @Override
    public Rectangle getBoundingBox() {
        return new Rectangle(this, this);
    }

    @Override
    public Area getArea() {
        return new Area(new Rectangle(this, this));
    }

    @Override
    public String stringValue() {
        return Utils.prettyPrint(this.x) + "," + Utils.prettyPrint(this.y);
    }

    @Override
    public String stringValue(SpatialEntity.Format format) {
        return this.stringValue();
    }
}

