/*
 * Decompiled with CFR 0.152.
 */
package com.github.tkurz.media.ontology.impl;

import com.github.tkurz.media.ontology.impl.Point;
import com.github.tkurz.media.ontology.impl.Rectangle;
import com.github.tkurz.media.ontology.type.Coordinate;
import com.github.tkurz.media.ontology.type.SpatialEntity;
import com.github.tkurz.media.ontology.utils.Utils;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;

public class Ellipse
extends Ellipse2D.Double
implements SpatialEntity {
    public Ellipse(double x, double y, double w, double h) {
        super(x, y, w, h);
    }

    @Override
    public Coordinate getCenter() {
        return new Point(this.x + this.width / 2.0, this.y + this.height / 2.0);
    }

    @Override
    public Rectangle getBoundingBox() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    @Override
    public Area getArea() {
        return new Area(this);
    }

    @Override
    public String stringValue() {
        return "xyab=" + Utils.prettyPrint(this.x) + "," + Utils.prettyPrint(this.y) + "," + this.width + "," + this.height;
    }

    @Override
    public String stringValue(SpatialEntity.Format format) {
        return this.stringValue();
    }
}

