/*
 * Decompiled with CFR 0.152.
 */
package com.github.tkurz.media.ontology.impl;

import com.github.tkurz.media.ontology.impl.Point;
import com.github.tkurz.media.ontology.impl.Rectangle;
import com.github.tkurz.media.ontology.type.Coordinate;
import com.github.tkurz.media.ontology.type.SpatialEntity;
import com.github.tkurz.media.ontology.utils.Utils;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;

public class Circle
extends Ellipse2D.Double
implements SpatialEntity {
    public Circle(Point point, int radius) {
        super(point.getX() - (double)radius, point.getY() - (double)radius, 2 * radius, 2 * radius);
    }

    public Circle(int x, int y, int radius) {
        super(x - radius, y - radius, 2 * radius, 2 * radius);
    }

    @Override
    public Coordinate getCenter() {
        return new Point(this.getCenterX(), this.getCenterY());
    }

    @Override
    public Rectangle getBoundingBox() {
        return new Rectangle(this.getBounds2D());
    }

    @Override
    public Area getArea() {
        return new Area(this);
    }

    @Override
    public String stringValue() {
        return "xcr=" + Utils.prettyPrint(this.getCenterX()) + "," + Utils.prettyPrint(this.getCenterY()) + "," + Utils.prettyPrint(this.width / 2.0);
    }

    @Override
    public String stringValue(SpatialEntity.Format format) {
        return this.stringValue();
    }
}

