/*
 * Decompiled with CFR 0.152.
 */
package com.github.tkurz.media.fragments.temporal;

import com.github.tkurz.media.ontology.impl.Instant;

public class Clocktime
extends Instant {
    public static final Clocktime ZERO = new Clocktime(0.0);
    public static final Clocktime INFINIT = new Clocktime(Double.POSITIVE_INFINITY);

    public Clocktime(double d) {
        super(d);
    }

    public Clocktime(String seconds) {
        super(Double.parseDouble(seconds));
    }

    public Clocktime(String hour, String minutes, String seconds, String ms) {
        super(Clocktime.parseClocktime(hour, minutes, seconds, ms));
    }

    private static double parseClocktime(String hour, String minutes, String seconds, String ms) {
        double h = hour != null ? Double.parseDouble(hour) * 3600.0 : 0.0;
        double m = Double.parseDouble(minutes) * 60.0;
        double s = Double.parseDouble(seconds);
        double z = ms != null ? Double.parseDouble("0." + ms) : 0.0;
        return h + m + s + z;
    }

    public static Clocktime max(Clocktime ... clocktimes) {
        Clocktime max = clocktimes[0];
        for (Clocktime c : clocktimes) {
            max = max.compareTo(c) < 0 ? c : max;
        }
        return max;
    }

    public static Clocktime min(Clocktime ... clocktimes) {
        Clocktime min = clocktimes[0];
        for (Clocktime c : clocktimes) {
            min = min.compareTo(c) < 0 ? min : c;
        }
        return min;
    }
}

