/*
 * Decompiled with CFR 0.152.
 */
package com.github.tkurz.media.fragments.spatial;

import com.github.tkurz.media.ontology.impl.Rectangle;
import com.github.tkurz.media.ontology.type.SpatialEntity;
import com.github.tkurz.media.ontology.utils.Utils;

public class SpatialFragment
extends Rectangle {
    private Unit unit = Unit.PIXEL;

    public SpatialFragment(double x, double y, double w, double h) {
        this(Unit.PIXEL, x, y, w, h);
    }

    public SpatialFragment(Unit unit, double x, double y, double w, double h) {
        super(x, y, w, h);
        this.unit = unit;
    }

    @Override
    public String stringValue() {
        return "xywh=" + (Object)((Object)this.unit) + Utils.prettyPrint(this.x) + "," + Utils.prettyPrint(this.y) + "," + Utils.prettyPrint(this.width) + "," + Utils.prettyPrint(this.height);
    }

    @Override
    public String stringValue(SpatialEntity.Format format) {
        return this.stringValue();
    }

    public SpatialFragment toPixel(double width, double height) {
        if (this.unit == Unit.PIXEL) {
            return this;
        }
        return new SpatialFragment(Unit.PIXEL, this.x * (width / 100.0), this.y * (height / 100.0), this.width * (width / 100.0), this.height * (height / 100.0));
    }

    public SpatialFragment toPercent(double width, double height) {
        if (this.unit == Unit.PERCENT) {
            return this;
        }
        return new SpatialFragment(Unit.PERCENT, this.x / (width / 100.0), this.y / (height / 100.0), this.width / (width / 100.0), this.height / (height / 100.0));
    }

    public static enum Unit {
        PIXEL,
        PERCENT;


        public String toString() {
            return this == PIXEL ? "" : "percent:";
        }
    }
}

