/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.serializer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Maps;
import eu.optique.r2rml.api.MappingFactory;
import eu.optique.r2rml.api.model.GraphMap;
import eu.optique.r2rml.api.model.LogicalTable;
import eu.optique.r2rml.api.model.ObjectMap;
import eu.optique.r2rml.api.model.PredicateMap;
import eu.optique.r2rml.api.model.SubjectMap;
import eu.optique.r2rml.api.model.Template;
import eu.optique.r2rml.api.model.TermMap;
import eu.optique.r2rml.api.model.TriplesMap;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.template.TemplateFactory;
import it.unibz.inf.ontop.model.template.impl.BnodeTemplateFactory;
import it.unibz.inf.ontop.model.template.impl.IRITemplateFactory;
import it.unibz.inf.ontop.model.template.impl.LiteralTemplateFactory;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.model.term.RDFTermTypeConstant;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBTypeConversionFunctionSymbol;
import it.unibz.inf.ontop.model.type.LanguageTag;
import it.unibz.inf.ontop.model.type.ObjectRDFType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.vocabulary.RDFS;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.spec.mapping.exception.R2RMLSerializationException;
import it.unibz.inf.ontop.spec.mapping.parser.impl.R2RMLVocabulary;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Literal;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFTerm;

public class SQLPPTriplesMapToR2RMLConverter {
    private final RDF rdfFactory;
    private final MappingFactory mappingFactory;
    private static final String baseIRIString = "urn:r2rml:";
    private final Function<RDFTermType, TermMapFactory<GraphMap>> graphTermMapFactorySupplier;
    private final Function<RDFTermType, TermMapFactory<SubjectMap>> subjectTermMapFactorySupplier;
    private final Function<RDFTermType, TermMapFactory<PredicateMap>> predicateTermMapFactorySupplier;
    private final Function<RDFTermType, TermMapFactory<ObjectMap>> objectTermMapFactorySupplier;

    public SQLPPTriplesMapToR2RMLConverter(RDF rdfFactory, MappingFactory mappingFactory) {
        this.rdfFactory = rdfFactory;
        this.mappingFactory = mappingFactory;
        this.graphTermMapFactorySupplier = new TermMapFactorySupplier<GraphMap>(arg_0 -> ((MappingFactory)mappingFactory).createGraphMap(arg_0), arg_0 -> ((MappingFactory)mappingFactory).createGraphMap(arg_0), arg_0 -> ((MappingFactory)mappingFactory).createGraphMap(arg_0));
        this.subjectTermMapFactorySupplier = new TermMapFactorySupplier<SubjectMap>(arg_0 -> ((MappingFactory)mappingFactory).createSubjectMap(arg_0), arg_0 -> ((MappingFactory)mappingFactory).createSubjectMap(arg_0), arg_0 -> ((MappingFactory)mappingFactory).createSubjectMap(arg_0));
        this.predicateTermMapFactorySupplier = new TermMapFactorySupplier<PredicateMap>(arg_0 -> ((MappingFactory)mappingFactory).createPredicateMap(arg_0), arg_0 -> ((MappingFactory)mappingFactory).createPredicateMap(arg_0), arg_0 -> ((MappingFactory)mappingFactory).createPredicateMap(arg_0));
        this.objectTermMapFactorySupplier = new ObjectTermMapFactorySupplier<ObjectMap>(arg_0 -> ((MappingFactory)mappingFactory).createObjectMap(arg_0), arg_0 -> ((MappingFactory)mappingFactory).createObjectMap(arg_0), arg_0 -> ((MappingFactory)mappingFactory).createObjectMap(arg_0));
    }

    public Stream<TriplesMap> convert(SQLPPTriplesMap triplesMap) {
        String mapping_id = triplesMap.getId();
        Object mainNodeIriPrefix = !mapping_id.contains(":") ? baseIRIString + mapping_id : mapping_id;
        ImmutableMap subjectMap = ((ImmutableMultimap)triplesMap.getTargetAtoms().stream().filter(t -> t.getProjectionAtom().getPredicate() instanceof RDFAtomPredicate).map(t -> Maps.immutableEntry((Object)((RDFAtomPredicate)t.getProjectionAtom().getPredicate()), (Object)t)).collect(ImmutableCollectors.toMultimap(e -> ((RDFAtomPredicate)e.getKey()).getSubject(((TargetAtom)e.getValue()).getSubstitutedTerms()), e -> e))).asMap();
        String sql = triplesMap.getSourceQuery().getSQL();
        return subjectMap.entrySet().stream().flatMap(arg_0 -> this.lambda$convert$4(sql, subjectMap, (String)mainNodeIriPrefix, arg_0));
    }

    private Stream<TriplesMap> processSameSubjectGroup(LogicalTable logicalTable, ImmutableTerm subject, Collection<Map.Entry<RDFAtomPredicate, TargetAtom>> targetAtoms, String mainNodeIriPrefix) {
        ImmutableMap graphMap = ((ImmutableMultimap)targetAtoms.stream().collect(ImmutableCollectors.toMultimap(e -> ((RDFAtomPredicate)e.getKey()).getGraph(((TargetAtom)e.getValue()).getSubstitutedTerms()), e -> e))).asMap();
        return graphMap.entrySet().stream().map(e -> this.processSameSubjectGraphGroup(logicalTable, subject, (Optional)e.getKey(), (Collection)e.getValue(), mainNodeIriPrefix));
    }

    private TriplesMap processSameSubjectGraphGroup(LogicalTable logicalTable, ImmutableTerm subject, Optional<ImmutableTerm> graph, Collection<Map.Entry<RDFAtomPredicate, TargetAtom>> targetAtoms, String mainNodeIriPrefix) {
        IRI iri = this.rdfFactory.createIRI(graph.map(t -> mainNodeIriPrefix + "-" + UUID.randomUUID()).orElse(mainNodeIriPrefix));
        TriplesMap tm = this.mappingFactory.createTriplesMap(logicalTable, (SubjectMap)this.getTermMap(subject, this.subjectTermMapFactorySupplier), (BlankNodeOrIRI)iri);
        graph.ifPresent(t -> tm.getSubjectMap().addGraphMap((GraphMap)this.getTermMap((ImmutableTerm)t, this.graphTermMapFactorySupplier)));
        for (Map.Entry<RDFAtomPredicate, TargetAtom> e : targetAtoms) {
            ImmutableList terms;
            RDFAtomPredicate predicate = e.getKey();
            Optional classIri = predicate.getClassIRI(terms = e.getValue().getSubstitutedTerms());
            if (classIri.isPresent()) {
                tm.getSubjectMap().addClass((IRI)classIri.get());
                continue;
            }
            tm.addPredicateObjectMap(this.mappingFactory.createPredicateObjectMap((PredicateMap)this.getTermMap(predicate.getProperty(terms), this.predicateTermMapFactorySupplier), (ObjectMap)this.getTermMap(predicate.getObject(terms), this.objectTermMapFactorySupplier)));
        }
        return tm;
    }

    private <T extends TermMap> T getTermMap(ImmutableTerm term, Function<RDFTermType, TermMapFactory<T>> termMapFactorySupplier) {
        if (term instanceof RDFConstant) {
            RDFConstant constant = (RDFConstant)term;
            RDFTermType termType = constant.getType();
            return termMapFactorySupplier.apply(termType).forConstant(constant.getValue());
        }
        if (term instanceof ImmutableFunctionalTerm) {
            ImmutableFunctionalTerm rdfFunctionalTerm = (ImmutableFunctionalTerm)term;
            ImmutableTerm lexicalTerm = DBTypeConversionFunctionSymbol.uncast((ImmutableTerm)rdfFunctionalTerm.getTerm(0));
            RDFTermType termType = Optional.of(rdfFunctionalTerm.getTerm(1)).filter(t -> t instanceof RDFTermTypeConstant).map(t -> (RDFTermTypeConstant)t).map(RDFTermTypeConstant::getRDFTermType).orElseThrow(() -> new R2RMLSerializationException("Was expecting a RDFTermTypeConstant in the mapping assertion, not " + rdfFunctionalTerm.getTerm(1)));
            return termMapFactorySupplier.apply(termType).create(lexicalTerm);
        }
        throw new MinorOntopInternalBugException("Unexpected term: " + term);
    }

    private /* synthetic */ Stream lambda$convert$4(String sql, ImmutableMap subjectMap, String mainNodeIriPrefix, Map.Entry e) {
        return this.processSameSubjectGroup((LogicalTable)this.mappingFactory.createR2RMLView(sql), (ImmutableTerm)e.getKey(), (Collection)e.getValue(), (String)(subjectMap.size() == 1 ? mainNodeIriPrefix : mainNodeIriPrefix + "-" + UUID.randomUUID()));
    }

    private class LiteralTermMapFactory<T extends ObjectMap>
    extends TermMapFactory<T> {
        private final RDFDatatype datatype;
        private final Function<Literal, T> constantFct;

        LiteralTermMapFactory(RDFDatatype datatype, Function<String, T> columnFct, Function<Template, T> templateFct, Function<Literal, T> constantFct) {
            super(R2RMLVocabulary.literal, (TemplateFactory)new LiteralTemplateFactory(null, null), columnFct, templateFct);
            this.datatype = datatype;
            this.constantFct = constantFct;
        }

        @Override
        public T forConstant(String value) {
            Literal literal = this.datatype.getLanguageTag().map(lang -> SQLPPTriplesMapToR2RMLConverter.this.rdfFactory.createLiteral(value, lang.getFullString())).orElseGet(() -> SQLPPTriplesMapToR2RMLConverter.this.rdfFactory.createLiteral(value, this.datatype.getIRI()));
            return (T)((ObjectMap)this.constantFct.apply(literal));
        }

        @Override
        protected T forColumn(Variable term) {
            return (T)this.setDatatype((ObjectMap)super.forColumn(term), this.datatype);
        }

        @Override
        protected T forTemplate(ImmutableFunctionalTerm term) {
            return (T)this.setDatatype((ObjectMap)super.forTemplate(term), this.datatype);
        }

        private T setDatatype(T objectMap, RDFDatatype datatype) {
            Optional optionalLangTag = datatype.getLanguageTag();
            if (optionalLangTag.isPresent()) {
                objectMap.setLanguageTag(((LanguageTag)optionalLangTag.get()).getFullString());
            } else if (!datatype.getIRI().equals((Object)RDFS.LITERAL)) {
                objectMap.setDatatype(datatype.getIRI());
            }
            return objectMap;
        }
    }

    private class IriTermMapFactory<T extends TermMap>
    extends TermMapFactory<T> {
        private final Function<IRI, T> constantFct;

        IriTermMapFactory(Function<String, T> columnFct, Function<Template, T> templateFct, Function<IRI, T> constantFct) {
            super(R2RMLVocabulary.iri, (TemplateFactory)new IRITemplateFactory(null), columnFct, templateFct);
            this.constantFct = constantFct;
        }

        @Override
        public T forConstant(String value) {
            return (T)((TermMap)this.constantFct.apply(SQLPPTriplesMapToR2RMLConverter.this.rdfFactory.createIRI(value)));
        }
    }

    private class BnodeTermMapFactory<T extends TermMap>
    extends TermMapFactory<T> {
        BnodeTermMapFactory(Function<String, T> columnFct, Function<Template, T> templateFct) {
            super(R2RMLVocabulary.blankNode, (TemplateFactory)new BnodeTemplateFactory(null), columnFct, templateFct);
        }

        @Override
        public T forConstant(String value) {
            TermMap termMap = (TermMap)this.templateFct.apply(SQLPPTriplesMapToR2RMLConverter.this.mappingFactory.createTemplate(value));
            termMap.setTermType(this.termType);
            return (T)termMap;
        }
    }

    private abstract class TermMapFactory<T extends TermMap> {
        protected final IRI termType;
        protected final TemplateFactory templateFactory;
        protected final Function<String, T> columnFct;
        protected final Function<Template, T> templateFct;

        TermMapFactory(IRI termType, TemplateFactory templateFactory, Function<String, T> columnFct, Function<Template, T> templateFct) {
            this.termType = termType;
            this.templateFactory = templateFactory;
            this.columnFct = columnFct;
            this.templateFct = templateFct;
        }

        public abstract T forConstant(String var1);

        protected T forColumn(Variable term) {
            TermMap termMap = (TermMap)this.columnFct.apply(term.getName());
            termMap.setTermType(this.termType);
            return (T)termMap;
        }

        protected T forTemplate(ImmutableFunctionalTerm term) {
            String templateString = this.templateFactory.serializeTemplateTerm(term);
            TermMap termMap = (TermMap)this.templateFct.apply(SQLPPTriplesMapToR2RMLConverter.this.mappingFactory.createTemplate(templateString));
            termMap.setTermType(this.termType);
            return (T)termMap;
        }

        public T create(ImmutableTerm term) {
            if (term instanceof DBConstant) {
                return this.forConstant(((DBConstant)term).getValue());
            }
            if (term instanceof Variable) {
                return this.forColumn((Variable)term);
            }
            if (term instanceof ImmutableFunctionalTerm) {
                return this.forTemplate((ImmutableFunctionalTerm)term);
            }
            throw new MinorOntopInternalBugException("Unexpected lexical term for an termMap: " + term);
        }
    }

    private class ObjectTermMapFactorySupplier<T extends ObjectMap>
    extends TermMapFactorySupplier<T> {
        private final Map<RDFDatatype, LiteralTermMapFactory<T>> map;
        private final Function<Literal, T> rdfTermFct;

        ObjectTermMapFactorySupplier(Function<Template, T> templateFct, Function<String, T> columnFct, Function<RDFTerm, T> rdfTermFct) {
            super(templateFct, columnFct, rdfTermFct::apply);
            this.map = new HashMap<RDFDatatype, LiteralTermMapFactory<T>>();
            this.rdfTermFct = rdfTermFct::apply;
        }

        @Override
        public TermMapFactory<T> apply(RDFTermType type) {
            if (type instanceof RDFDatatype) {
                RDFDatatype datatype = (RDFDatatype)type;
                return this.map.computeIfAbsent(datatype, d -> new LiteralTermMapFactory(datatype, this.iri.columnFct, this.iri.templateFct, this.rdfTermFct));
            }
            return super.apply(type);
        }
    }

    private class TermMapFactorySupplier<T extends TermMap>
    implements Function<RDFTermType, TermMapFactory<T>> {
        protected final TermMapFactory<T> bnode;
        protected final TermMapFactory<T> iri;

        TermMapFactorySupplier(Function<Template, T> templateFct, Function<String, T> columnFct, Function<IRI, T> iriFct) {
            this.bnode = new BnodeTermMapFactory<T>(columnFct, templateFct);
            this.iri = new IriTermMapFactory<T>(columnFct, templateFct, iriFct);
        }

        @Override
        public TermMapFactory<T> apply(RDFTermType type) {
            if (type instanceof ObjectRDFType) {
                return ((ObjectRDFType)type).isBlankNode() ? this.bnode : this.iri;
            }
            throw new MinorOntopInternalBugException("Unexpected term type: " + type);
        }
    }
}

