/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.parser.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import eu.optique.r2rml.api.binding.rdf4j.RDF4JR2RMLMappingManager;
import eu.optique.r2rml.api.model.impl.InvalidR2RMLMappingException;
import it.unibz.inf.ontop.exception.InvalidMappingException;
import it.unibz.inf.ontop.exception.MappingIOException;
import it.unibz.inf.ontop.injection.SQLPPMappingFactory;
import it.unibz.inf.ontop.injection.SpecificationFactory;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import it.unibz.inf.ontop.spec.mapping.parser.SQLMappingParser;
import it.unibz.inf.ontop.spec.mapping.parser.impl.R2RMLToSQLPPTriplesMapConverter;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.rdf4j.RDF4J;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;

public class R2RMLMappingParser
implements SQLMappingParser {
    private final SQLPPMappingFactory ppMappingFactory;
    private final SpecificationFactory specificationFactory;
    private final R2RMLToSQLPPTriplesMapConverter transformer;
    private final RDF4JR2RMLMappingManager manager;

    @Inject
    private R2RMLMappingParser(SQLPPMappingFactory ppMappingFactory, SpecificationFactory specificationFactory, R2RMLToSQLPPTriplesMapConverter transformer) {
        this.ppMappingFactory = ppMappingFactory;
        this.specificationFactory = specificationFactory;
        this.transformer = transformer;
        this.manager = RDF4JR2RMLMappingManager.getInstance();
    }

    public SQLPPMapping parse(File mappingFile) throws InvalidMappingException, MappingIOException {
        SQLPPMapping sQLPPMapping;
        LinkedHashModel rdf4jGraph = new LinkedHashModel();
        RDFParser parser = Rio.createParser((RDFFormat)RDFFormat.TURTLE);
        StatementCollector collector = new StatementCollector((Collection)rdf4jGraph);
        parser.setRDFHandler((RDFHandler)collector);
        FileInputStream in = new FileInputStream(mappingFile);
        try {
            URL documentUrl = new URL("file://" + mappingFile);
            parser.parse((InputStream)in, documentUrl.toString());
            sQLPPMapping = this.parse((Graph)new RDF4J().asGraph((Model)rdf4jGraph), this.extractPrefixes(rdf4jGraph));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new MappingIOException((Exception)e);
            }
            catch (RDFHandlerException | RDFParseException e) {
                throw new InvalidMappingException(e.getMessage());
            }
        }
        ((InputStream)in).close();
        return sQLPPMapping;
    }

    public SQLPPMapping parse(Reader reader) throws InvalidMappingException, MappingIOException {
        SQLPPMapping sQLPPMapping;
        block9: {
            LinkedHashModel rdf4jGraph = new LinkedHashModel();
            RDFParser parser = Rio.createParser((RDFFormat)RDFFormat.TURTLE);
            StatementCollector collector = new StatementCollector((Collection)rdf4jGraph);
            parser.setRDFHandler((RDFHandler)collector);
            Reader r = reader;
            try {
                parser.parse(r, "http://example.org/baseIRI/");
                sQLPPMapping = this.parse((Graph)new RDF4J().asGraph((Model)rdf4jGraph), this.extractPrefixes(rdf4jGraph));
                if (r == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MappingIOException((Exception)e);
                }
                catch (RDFHandlerException | RDFParseException e) {
                    throw new InvalidMappingException(e.getMessage());
                }
            }
            r.close();
        }
        return sQLPPMapping;
    }

    private ImmutableMap<String, String> extractPrefixes(LinkedHashModel rdf4jGraph) {
        return (ImmutableMap)rdf4jGraph.getNamespaces().stream().collect(ImmutableCollectors.toMap(namespace -> namespace.getPrefix() + ":", Namespace::getName));
    }

    public SQLPPMapping parse(Graph mappingGraph) throws InvalidMappingException {
        return this.parse(mappingGraph, (ImmutableMap<String, String>)ImmutableMap.of());
    }

    protected SQLPPMapping parse(Graph mappingGraph, ImmutableMap<String, String> prefixes) throws InvalidMappingException {
        try {
            Collection tripleMaps = this.manager.importMappings(mappingGraph);
            ImmutableList<SQLPPTriplesMap> sourceMappings = this.transformer.convert(tripleMaps);
            PrefixManager prefixManager = this.specificationFactory.createPrefixManager(prefixes);
            return this.ppMappingFactory.createSQLPreProcessedMapping(sourceMappings, prefixManager);
        }
        catch (InvalidR2RMLMappingException e) {
            throw new InvalidMappingException(e.getMessage());
        }
    }
}

