/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.templates;

import com.ontotext.models.templates.Template;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public interface TemplateParser {
    public boolean isApplicable(String var1);

    public Optional<Template> parse(String var1, String var2);

    default public String[] splitToNameAndType(String name) {
        return name.split(":", 3);
    }

    default public String[] splitNameInParts(String name) {
        return name.split("\\.");
    }

    default public String resolveType(String name, boolean isCollection) {
        String[] nameType = this.splitToNameAndType(name);
        String defaultType = isCollection ? "object" : "string";
        return nameType.length > 1 && StringUtils.isNotBlank((CharSequence)nameType[1]) ? nameType[1] : defaultType;
    }

    @Nullable
    default public String resolveDefaultValue(String name) {
        String[] nameType = this.splitToNameAndType(name);
        return nameType.length > 2 ? StringUtils.trimToNull((String)nameType[2]) : null;
    }

    default public boolean isOptional(String variable) {
        return false;
    }
}

