/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.templates;

import com.ontotext.models.ScalarTypes;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class TemplateArgs {
    public static final String NO_VALUE_CONVERT = "sparql";
    public static final String CONDITIONAL_TYPE = "condition";
    public static final String DEFAULT_TYPE = "string";
    public static final String DEFAULT_NESTED_TYPE = "object";
    public static final TemplateArgs ARGS = new TemplateArgs("args", "object", null, false);
    private final String name;
    private final String defaultValue;
    private final boolean isCollection;
    private final String type;
    private final Map<String, TemplateArgs> argsMap = new LinkedHashMap<String, TemplateArgs>();

    public TemplateArgs(String name, String type, String defaultValue, boolean isCollection) {
        this.name = name;
        this.type = type;
        this.defaultValue = TemplateArgs.escapeDefaultValue(type, defaultValue);
        this.isCollection = isCollection && !CONDITIONAL_TYPE.equals(type);
    }

    private static String escapeDefaultValue(String type, String defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        if (ScalarTypes.DECIMAL_NUMBER_TYPES.contains(type)) {
            defaultValue = defaultValue.replace(",", ".");
        }
        return defaultValue.replace("##", ".");
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, TemplateArgs> getArgsMap() {
        return this.argsMap;
    }

    public TemplateArgs addArg(TemplateArgs argument) {
        this.argsMap.put(argument.getName(), argument);
        return this;
    }

    public TemplateArgs addArg(String name, TemplateArgs argument) {
        this.argsMap.put(name, argument);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TemplateArgs)) {
            return false;
        }
        TemplateArgs args = (TemplateArgs)obj;
        return this.isCollection == args.isCollection && Objects.equals(this.name, args.name) && Objects.equals(this.type, args.type) && Objects.equals(this.defaultValue, args.defaultValue) && this.argsMap.equals(args.argsMap);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.isCollection, this.type, this.defaultValue, this.argsMap);
    }

    public String toString() {
        return String.format("{name='%s', defaultValue='%s', isCollection=%s, type='%s', argsMap=%s}", this.name, this.defaultValue, this.isCollection, this.type, this.argsMap);
    }

    public boolean isEmpty() {
        return this.getArgsMap().isEmpty();
    }

    public boolean isOptional() {
        return ("args".equals(this.getName()) || NO_VALUE_CONVERT.equalsIgnoreCase(this.getType())) && this.getArgsMap().values().stream().allMatch(TemplateArgs::isOptional) || this.defaultValue != null;
    }
}

