/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.subscriptions;

import com.ontotext.models.OperationType;
import com.ontotext.models.OperationVisitor;
import com.ontotext.models.OperationVisitorContext;
import com.ontotext.models.Selection;
import com.ontotext.models.Shape;
import com.ontotext.models.query.Query;
import com.ontotext.models.subscriptions.SubscriptionRequest;
import org.jetbrains.annotations.Nullable;

public class Subscription
extends Query {
    @Nullable
    public Shape getSubscriptionType() {
        SubscriptionRequest subscriptionRequest = this.getSubscriptionRequest();
        if (subscriptionRequest != null) {
            return subscriptionRequest.getSubscriptionType();
        }
        return null;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.SUBSCRIPTION;
    }

    @Override
    public <R, Q extends OperationVisitorContext> R accept(OperationVisitor<R, Q> visitor, Q context) {
        return visitor.visit(this, context);
    }

    public SubscriptionRequest getSubscriptionRequest() {
        return (SubscriptionRequest)this.getArguments().get("stream");
    }

    public void markSubscriptionTypeAsPassThrough() {
        Shape subscriptionType = this.getSubscriptionType();
        if (subscriptionType == null) {
            return;
        }
        String name = this.getSchema().getPrefixes().toName(subscriptionType.getId());
        this.getSelections().stream().filter(selection -> selection.getType().equals(name)).forEach(Selection::setAsPassThrough);
    }
}

