/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.shacl;

import com.ontotext.models.shacl.ConstraintContext;
import com.ontotext.models.shacl.ShaclConstraint;
import com.ontotext.models.shacl.ShaclNode;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.IRI;

public class HasValueIn
implements ShaclNode {
    private List<Object> values;

    public HasValueIn(ConstraintContext context) {
        this.values = (List)context.getConstraintValue();
        for (int i = 0; i < this.values.size(); ++i) {
            Object value = this.values.get(i);
            if (value instanceof String && Boolean.TRUE.equals(context.isTargetScalar())) {
                this.values.set(i, StringUtils.wrapIfMissing((String)((String)value), (char)'\"'));
                continue;
            }
            if (!(value instanceof IRI)) continue;
            this.values.set(i, "<" + value.toString() + ">");
        }
    }

    @Override
    public String getName() {
        return ShaclConstraint.HAS_VALUE_IN.getLocalName();
    }

    @Override
    public Object getValue() {
        return this.values;
    }

    @Override
    public void addValues(Object values) {
        this.values = (List)values;
    }

    @Override
    public String toTurtle() {
        return "dash:" + this.getName() + " " + this.getValue().toString().replace(",", "").replace("[", "(").replace("]", ")") + " ; ";
    }
}

