/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.security;

import com.ontotext.models.ActionFilter;
import com.ontotext.models.CompositeActionFilter;
import com.ontotext.models.Constraint;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.RoleAction;
import com.ontotext.models.RoleActionType;
import com.ontotext.models.Shape;
import com.ontotext.models.security.ModelRestrictions;
import com.ontotext.models.security.RbacResult;
import com.ontotext.models.security.Role;
import com.ontotext.models.security.ShapeRestrictions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class RbacRestrictions {
    private final Map<String, ShapeRestrictions> shapeRestrictions = new LinkedHashMap<String, ShapeRestrictions>(512);

    public void addAction(Shape shape, RoleAction action) {
        RoleAction clone = action.createDuplicate();
        if (!action.getProperty().equals("*")) {
            clone.setActionFilter(null);
        }
        this.getOrCreateShapeRestrictions(shape).addAction(clone);
    }

    public void addAction(Shape shape, PropertyShape propertyShape, RoleAction action) {
        this.getOrCreateShapeRestrictions(shape).getOrCreatePropertyRestrictions(propertyShape.getName()).addAction(action);
    }

    public void addNotAction(Shape shape, RoleAction notAction) {
        this.getOrCreateShapeRestrictions(shape).addNotAction(notAction);
    }

    public void addNotAction(Shape shape, PropertyShape propertyShape, RoleAction notAction) {
        this.getOrCreateShapeRestrictions(shape).getOrCreatePropertyRestrictions(propertyShape.getName()).addNotAction(notAction);
    }

    public RbacResult canRead(Shape shape, Set<Role> roles) {
        return this.checkAction(shape, roles, RoleActionType.READ);
    }

    public RbacResult canRead(Shape shape, String property, Set<Role> roles) {
        return this.checkAction(shape, property, roles, RoleActionType.READ, false);
    }

    public RbacResult canRead(Shape shape, String property, Set<Role> roles, boolean exact) {
        return this.checkAction(shape, property, roles, RoleActionType.READ, exact);
    }

    public RbacResult canWrite(Shape shape, Set<Role> roles) {
        return this.checkAction(shape, roles, RoleActionType.WRITE);
    }

    public RbacResult canWrite(Shape shape, String property, Set<Role> roles) {
        return this.checkAction(shape, property, roles, RoleActionType.WRITE, false);
    }

    public RbacResult canDelete(Shape shape, Set<Role> roles) {
        return this.checkAction(shape, roles, RoleActionType.DELETE);
    }

    public RbacResult canDelete(Shape shape, String property, Set<Role> roles) {
        return this.checkAction(shape, property, roles, RoleActionType.DELETE, false);
    }

    public ShapeRestrictions getShapeRestrictions(String shapeId) {
        return this.shapeRestrictions.get(shapeId);
    }

    public void clearAllRestrictions() {
        this.shapeRestrictions.clear();
    }

    private ShapeRestrictions getOrCreateShapeRestrictions(Shape shape) {
        return this.shapeRestrictions.computeIfAbsent(shape.getId(), ShapeRestrictions::new);
    }

    private RbacResult checkAction(Shape shape, Set<Role> roles, RoleActionType actionType) {
        if (shape.isAbstract() || shape.isUnion()) {
            return this.checkAbstractShapeAction(shape, roles, actionType);
        }
        return this.checkShapeAction(shape, roles, actionType);
    }

    private RbacResult checkAction(Shape shape, String property, Set<Role> roles, RoleActionType actionType, boolean exact) {
        if ((shape.isAbstract() || shape.isUnion()) && !exact) {
            return this.checkAbstractShapeAction(shape, property, roles, actionType);
        }
        return this.checkShapeAction(shape, property, roles, actionType);
    }

    private RbacResult checkShapeAction(Shape shape, Set<Role> roles, RoleActionType actionType) {
        Collection<Shape> hierarchy = RbacRestrictions.getHierarchy(shape);
        LinkedHashSet<ActionFilter> positives = new LinkedHashSet<ActionFilter>();
        LinkedHashSet<ActionFilter> negatives = new LinkedHashSet<ActionFilter>();
        for (Shape node : hierarchy) {
            ShapeRestrictions nodeRestrictions = this.getOrCreateShapeRestrictions(node);
            RbacResult result = this.getResult(nodeRestrictions, roles, actionType, shape, positives, negatives);
            if (result == null) continue;
            return result;
        }
        return RbacResult.forbidden();
    }

    private RbacResult checkShapeAction(Shape shape, String property, Set<Role> roles, RoleActionType actionType) {
        Collection<Shape> hierarchy = RbacRestrictions.getHierarchy(shape);
        LinkedHashSet<ActionFilter> positives = new LinkedHashSet<ActionFilter>();
        LinkedHashSet<ActionFilter> negatives = new LinkedHashSet<ActionFilter>();
        for (Shape node : hierarchy) {
            ShapeRestrictions nodeRestrictions = this.getOrCreateShapeRestrictions(node);
            ModelRestrictions propertyRestrictions = nodeRestrictions.getOrCreatePropertyRestrictions(property);
            RbacResult result = this.getResult(propertyRestrictions, roles, actionType, shape, positives, negatives);
            if (result == null) continue;
            return result;
        }
        return RbacResult.forbidden();
    }

    private RbacResult getResult(ModelRestrictions propertyRestrictions, Set<Role> roles, RoleActionType actionType, Shape shape, Set<ActionFilter> positives, Set<ActionFilter> negatives) {
        Boolean allow = null;
        if (propertyRestrictions.hasNotAction(roles, actionType, negatives::add)) {
            if (negatives.isEmpty()) {
                return RbacResult.forbidden();
            }
            allow = Boolean.FALSE;
        }
        if (propertyRestrictions.hasAction(roles, actionType, positives::add)) {
            allow = Boolean.TRUE;
        }
        if (allow != null) {
            if (positives.isEmpty() && negatives.isEmpty()) {
                return allow != false ? RbacResult.allowed() : RbacResult.forbidden();
            }
            if (allow.booleanValue()) {
                return RbacResult.constrained(Collections.singleton(new Constraint(shape.getId(), this.combineInFilter(positives, negatives))));
            }
        }
        return null;
    }

    private CompositeActionFilter combineInFilter(Set<ActionFilter> positives, Set<ActionFilter> negatives) {
        return new CompositeActionFilter(positives, negatives);
    }

    private RbacResult checkAbstractShapeAction(Shape shape, Set<Role> roles, RoleActionType actionType) {
        Function<Shape, RbacResult> permissionFilter = subType -> this.checkShapeAction((Shape)subType, roles, actionType);
        return this.checkAbstractActionInternal(shape, permissionFilter);
    }

    private RbacResult checkAbstractShapeAction(Shape shape, String property, Set<Role> roles, RoleActionType actionType) {
        Function<Shape, RbacResult> permissionFilter = subType -> this.checkShapeAction((Shape)subType, property, roles, actionType);
        return this.checkAbstractActionInternal(shape, permissionFilter);
    }

    private RbacResult checkAbstractActionInternal(Shape shape, Function<Shape, RbacResult> permissionFilter) {
        Collection<Shape> nonAbstractSubTypes = shape.getConcreteSubTypes();
        if (shape.getSubTypes().isEmpty() && nonAbstractSubTypes.isEmpty()) {
            return RbacResult.notCalculated();
        }
        LinkedHashMap<String, RbacResult> rbacResults = new LinkedHashMap<String, RbacResult>();
        nonAbstractSubTypes.forEach(type -> rbacResults.put(type.getId(), (RbacResult)permissionFilter.apply((Shape)type)));
        long readableTypes = rbacResults.values().stream().filter(RbacResult::isAllowed).count();
        if (readableTypes == 0L) {
            return RbacResult.forbidden();
        }
        long withConstraints = rbacResults.values().stream().filter(RbacResult::isConstrained).count();
        if (readableTypes == (long)nonAbstractSubTypes.size() && withConstraints == 0L) {
            return RbacResult.allowed();
        }
        LinkedHashSet<Constraint> constraints = new LinkedHashSet<Constraint>();
        if (withConstraints == (long)nonAbstractSubTypes.size() && this.allConstraintsHaveTheSameFilter(rbacResults)) {
            Set<Constraint> sampleResult = ((RbacResult)rbacResults.values().iterator().next()).getConstraints();
            if (sampleResult.isEmpty()) {
                constraints.add(new Constraint(shape.getId()));
            } else {
                sampleResult.stream().map(constr -> new Constraint(shape.getId(), constr.getFilter())).forEach(constraints::add);
            }
        } else {
            rbacResults.entrySet().stream().filter(entry -> ((RbacResult)entry.getValue()).isAllowed()).forEach(entry -> {
                Set<Constraint> typeConstr = ((RbacResult)entry.getValue()).getConstraints();
                if (typeConstr.isEmpty()) {
                    constraints.add(new Constraint((String)entry.getKey()));
                } else {
                    constraints.addAll(typeConstr);
                }
            });
        }
        return RbacResult.constrained(constraints);
    }

    private boolean allConstraintsHaveTheSameFilter(Map<String, RbacResult> rbacResults) {
        return rbacResults.values().stream().map(RbacResult::getConstraints).flatMap(Collection::stream).map(Constraint::getFilter).distinct().count() == 1L;
    }

    private static Collection<Shape> getHierarchy(Shape shape) {
        ArrayList<Shape> hierarchy = new ArrayList<Shape>(shape.getContainedIn().getHierarchy(shape.getId()));
        Collections.reverse(hierarchy);
        return hierarchy;
    }
}

