/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.search;

import com.ontotext.models.ModelTracker;
import com.ontotext.models.TrackedModel;
import com.ontotext.models.yaml.YamlPrinter;
import com.ontotext.models.yaml.YamlRepresentable;
import com.ontotext.soaas.common.ObjectsUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class Type
extends LinkedHashMap<String, Object>
implements TrackedModel,
YamlRepresentable {
    public static final String NAME_FIELD = "name";
    public static final String NESTING_LEVEL_FIELD = "nestingLevel";
    public static final int DEFAULT_NESTING_LEVEL = 0;
    public static final int ALLOWED_NESTING_LEVEL_LOW = 0;
    public static final int ALLOWED_NESTING_LEVEL_HIGH = 5;
    private boolean singleValueMode;
    private String name;
    private Integer nestingLevel;
    private transient ModelTracker tracker = ModelTracker.notTracked();

    public Type() {
        this.tracker = ModelTracker.tracked();
    }

    public Type(boolean notTracked) {
        this.name = "default";
        this.nestingLevel = 0;
    }

    public Type(String name) {
        this.singleValueMode = true;
        this.tracker = ModelTracker.tracked();
        this.setName(Objects.toString(name, null));
        this.nestingLevel = 0;
    }

    public Type(Type copyFrom) {
        if (copyFrom.hasValue()) {
            this.tracker = ModelTracker.tracked();
        }
        this.singleValueMode = copyFrom.singleValueMode;
        this.name = copyFrom.name;
        this.nestingLevel = copyFrom.nestingLevel;
        copyFrom.forEach(this::put);
        this.copyTrackInformation(copyFrom);
        this.stopTracking();
    }

    protected Type(Map<String, Object> values) {
        if (!values.isEmpty()) {
            this.tracker = ModelTracker.tracked();
        }
        this.setNameInternal(values.remove(NAME_FIELD));
        this.setNestingLevelInternal(values.remove(NESTING_LEVEL_FIELD));
        values.forEach(this::put);
    }

    public static Type parse(Object value) {
        if (value instanceof String) {
            return new Type(value.toString());
        }
        if (value instanceof Type) {
            return new Type((Type)value);
        }
        if (value instanceof Map) {
            return new Type((Map)value);
        }
        return new Type();
    }

    private void setNameInternal(Object nameValue) {
        if (nameValue instanceof String) {
            this.setName(nameValue.toString());
        } else {
            this.name = "default";
        }
    }

    private void setNestingLevelInternal(Object levelValue) {
        if (levelValue instanceof String) {
            levelValue = StringUtils.trimToNull((String)levelValue.toString());
            levelValue = Objects.toString(levelValue, Integer.toString(0));
            this.setNestingLevel(Integer.valueOf(levelValue.toString()));
        } else if (levelValue instanceof Number) {
            this.setNestingLevel(((Number)levelValue).intValue());
        } else {
            this.nestingLevel = 0;
        }
    }

    private void copyTrackInformation(Type parentConfig) {
        if (parentConfig.isTracked(NAME_FIELD)) {
            this.tracker.trackModelEntry(NAME_FIELD);
        }
        if (parentConfig.isTracked(NESTING_LEVEL_FIELD)) {
            this.tracker.trackModelEntry(NESTING_LEVEL_FIELD);
        }
        for (String key : parentConfig.keySet()) {
            if (!parentConfig.isTracked(key)) continue;
            this.tracker.trackModelEntry(key);
        }
    }

    private boolean hasValue() {
        return !"".equals(this.name) || !this.isEmpty() || this.nestingLevel != 0;
    }

    @Override
    public void startTracking() {
        this.tracker = ModelTracker.enableTracking(this.tracker);
    }

    @Override
    public void stopTracking() {
        this.tracker = ModelTracker.disableTracking(this.tracker);
    }

    @Override
    public Object put(String key, Object value) {
        if (NAME_FIELD.equals(key)) {
            this.setNameInternal(value);
            return null;
        }
        if (NESTING_LEVEL_FIELD.equals(key)) {
            this.setNestingLevelInternal(value);
            return null;
        }
        this.tracker.trackValue(key, value);
        return super.put(key, value);
    }

    @Override
    public void clearTrackedInformation() {
        this.tracker.clear();
    }

    @Override
    public String toYaml(YamlPrinter.Configuration configuration) {
        if (this.singleValueMode && this.name != null) {
            if (this.name.isEmpty()) {
                return "\"\"";
            }
            return this.name;
        }
        StringBuilder builder = new StringBuilder(32);
        builder.append('{');
        this.propertiesToYaml(builder, configuration);
        builder.append('}');
        String yaml = builder.toString();
        if (yaml.equals("{}") && this.hasValue()) {
            return "";
        }
        return yaml;
    }

    @Override
    public boolean isTracked(String modelId) {
        return this.tracker.isTracked(modelId);
    }

    private void propertiesToYaml(StringBuilder builder, YamlPrinter.Configuration configuration) {
        boolean hasPreviousValue = this.appendProperty(builder, false, NAME_FIELD, this.name, configuration);
        hasPreviousValue = this.appendProperty(builder, hasPreviousValue, NESTING_LEVEL_FIELD, this.nestingLevel, configuration);
        for (Map.Entry entry : this.entrySet()) {
            hasPreviousValue = this.appendProperty(builder, hasPreviousValue, (String)entry.getKey(), entry.getValue(), configuration);
        }
    }

    private boolean appendProperty(StringBuilder builder, boolean hasPreviousValue, String property, Object value, YamlPrinter.Configuration configuration) {
        if (this.tracker.isTracked(property) && value != null) {
            if (hasPreviousValue) {
                builder.append(", ");
            }
            builder.append(property).append(": ").append(YamlPrinter.getValueAsString(value, configuration));
            hasPreviousValue = true;
        }
        return hasPreviousValue;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.tracker.trackValue(NAME_FIELD, name);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Type)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Type type = (Type)obj;
        return Objects.equals(this.name, type.name) && Objects.equals(this.nestingLevel, type.nestingLevel);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.nestingLevel);
    }

    @Override
    public String toString() {
        return String.format("{name: '%s', nestingLevel: '%s'%s}", this.name, this.nestingLevel, this.entrySet().stream().map(entry -> (String)entry.getKey() + ": '" + String.valueOf(entry.getValue()) + "'").collect(Collectors.joining(", ", ", ", "")));
    }

    void merge(Type parentType) {
        if (parentType == null) {
            return;
        }
        Type.merge(value -> {
            this.name = value;
        }, this.getName(), parentType.getName());
        Type.merge(value -> {
            this.nestingLevel = value;
        }, this.getNestingLevel(), parentType.getNestingLevel());
        parentType.forEach((key, value) -> Type.merge(newValue -> super.put(key, newValue), this.get(key), value));
    }

    private static <T> void merge(Consumer<T> valueConsumer, T value, T defaultValue) {
        valueConsumer.accept(ObjectsUtil.getOrDefault(value, defaultValue));
    }

    public boolean isDefault() {
        return this.name == null || "default".equalsIgnoreCase(this.name);
    }

    public boolean isRelationType() {
        return "join".equalsIgnoreCase(this.name) || "nested".equalsIgnoreCase(this.name);
    }

    public Integer getNestingLevel() {
        return this.nestingLevel;
    }

    public void setNestingLevel(Integer nestingLevel) {
        this.nestingLevel = nestingLevel;
        this.tracker.trackValue(NESTING_LEVEL_FIELD, nestingLevel);
    }
}

