/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.search;

import com.google.common.collect.ImmutableMap;
import com.ontotext.models.ModelTracker;
import com.ontotext.models.TrackedModel;
import com.ontotext.models.query.LangFilter;
import com.ontotext.models.yaml.YamlPrinter;
import com.ontotext.models.yaml.YamlRepresentable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class Analysis
implements TrackedModel,
YamlRepresentable {
    public static final String ANALYZER_FIELD = "analyzer";
    public static final String LANG_FIELD = "lang";
    private String analyzer;
    private Map<String, Analysis> lang;
    private Map<LangFilter.Token, Analysis> tokenMap;
    private ModelTracker tracker = ModelTracker.tracked();

    public Analysis() {
    }

    public Analysis(String analyzer) {
        this();
        this.analyzer = analyzer;
    }

    public Analysis(Analysis copy) {
        this();
        this.analyzer = copy.analyzer;
        if (copy.getLang() != null) {
            this.lang = new HashMap<String, Analysis>();
            copy.lang.forEach((key, val) -> this.lang.put((String)key, new Analysis((Analysis)val)));
        }
        this.copyTrackInformation(copy);
        this.stopTracking();
    }

    public static Analysis fromMap(Map map) {
        if (map == null) {
            return null;
        }
        Analysis analysis = new Analysis();
        analysis.setAnalyzer((String)map.get(ANALYZER_FIELD));
        if (map.containsKey(LANG_FIELD)) {
            Map langs = (Map)map.get(LANG_FIELD);
            analysis.lang = new HashMap<String, Analysis>();
            langs.forEach((key, val) -> analysis.lang.put((String)key, Analysis.fromMap((Map)val)));
        }
        return analysis;
    }

    private void copyTrackInformation(Analysis copy) {
        if (copy.tracker.isTracked(ANALYZER_FIELD)) {
            this.tracker.trackModelEntry(ANALYZER_FIELD);
        }
        if (copy.tracker.isTracked(LANG_FIELD)) {
            this.tracker.trackModelEntry(LANG_FIELD);
        }
    }

    void merge(Analysis other) {
        if (other == null) {
            return;
        }
        this.analyzer = (String)StringUtils.defaultIfBlank((CharSequence)this.analyzer, (CharSequence)other.analyzer);
        if (this.lang == null && other.lang != null) {
            this.setLang(other.lang);
        } else if (other.lang != null) {
            HashMap<String, Analysis> copy = new HashMap<String, Analysis>(this.lang);
            other.lang.forEach(copy::putIfAbsent);
            this.setLang(copy);
        }
    }

    @Override
    public void stopTracking() {
        this.tracker = ModelTracker.disableTracking(this.tracker);
    }

    @Override
    public void startTracking() {
        this.tracker = ModelTracker.enableTracking(this.tracker);
    }

    @Override
    public void clearTrackedInformation() {
        this.tracker.clear();
    }

    @Override
    public boolean isTracked(String modelId) {
        return this.tracker.isTracked(modelId);
    }

    @Override
    public String toYaml(YamlPrinter.Configuration configuration) {
        ArrayList<Object> entries = new ArrayList<Object>();
        if (this.analyzer != null) {
            entries.add(String.format("%s: %s", ANALYZER_FIELD, this.analyzer));
        }
        if (this.lang != null) {
            Object langEntry = "lang:";
            langEntry = (String)langEntry + this.lang.entrySet().stream().map(this.toStringRepresentation(configuration)).collect(Collectors.joining(",", "{", "}"));
            entries.add(langEntry);
        }
        return entries.stream().collect(Collectors.joining(",", "{", "}"));
    }

    private Function<Map.Entry<String, Analysis>, String> toStringRepresentation(YamlPrinter.Configuration config) {
        return enrty -> String.format("%s: %s", enrty.getKey(), ((Analysis)enrty.getValue()).toYaml(config));
    }

    public String getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(String analyzer) {
        this.analyzer = analyzer;
        this.tracker.trackValue(ANALYZER_FIELD, analyzer);
    }

    public String getAnalyzerForLang(String lang) {
        if (this.lang == null) {
            return this.getAnalyzer();
        }
        Analysis analysis = this.lang.get(lang);
        if (analysis == null) {
            analysis = this.tokenMap.entrySet().stream().filter(this.tokenMatchesTheLang(lang)).map(Map.Entry::getValue).findFirst().orElse(this);
        }
        return analysis.getAnalyzer();
    }

    public Map<String, Analysis> getLang() {
        return this.lang;
    }

    public void setLang(Map<String, Analysis> lang) {
        if (lang == null) {
            this.lang = null;
            this.tokenMap = null;
            return;
        }
        this.lang = ImmutableMap.copyOf(lang);
        this.buildTokenMap();
        this.tracker.trackValue(LANG_FIELD, lang);
    }

    public void setLangFromTokenMap(Map<LangFilter.Token, Analysis> lang) {
        this.lang = new HashMap<String, Analysis>();
        this.tokenMap = new HashMap<LangFilter.Token, Analysis>();
        lang.forEach((key, val) -> {
            String langAsString = key.toString();
            this.lang.put(langAsString, (Analysis)val);
            this.tokenMap.put((LangFilter.Token)key, (Analysis)val);
        });
        this.lang = ImmutableMap.copyOf(this.lang);
        this.tracker.trackValue(LANG_FIELD, lang);
    }

    private Predicate<Map.Entry<LangFilter.Token, Analysis>> tokenMatchesTheLang(String lang) {
        return entry -> ((LangFilter.Token)entry.getKey()).matchValue(Collections.singletonList(lang), true).findAny().isPresent();
    }

    private void buildTokenMap() {
        this.tokenMap = new HashMap<LangFilter.Token, Analysis>();
        this.lang.forEach((key, val) -> {
            List<LangFilter.Token> tokens = LangFilter.parse(key).getTokens();
            if (tokens.size() != 1) {
                throw new IllegalArgumentException("Only exact/wildcard langs can be used as search langs. Following value is invalid: " + key);
            }
            this.tokenMap.put(tokens.get(0), (Analysis)val);
        });
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Analysis analysis = (Analysis)obj;
        return Objects.equals(this.analyzer, analysis.analyzer) && Objects.equals(this.lang, analysis.lang);
    }

    public int hashCode() {
        return Objects.hash(this.analyzer, this.lang);
    }
}

