/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.sanitizing;

import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaExtension;
import com.ontotext.models.sanitizing.Sanitizable;
import com.ontotext.soaas.plugin.Order;

@Order(value=41)
public class SchemaSanitizer
implements SchemaExtension {
    @Override
    public boolean canHandle(SomlSchema somlSchema) {
        return Boolean.FALSE.equals(somlSchema.getInternal()) && somlSchema.getSpecialPrefixes().getVocabPrefix().isPresent();
    }

    @Override
    public void process(SomlSchema somlSchema) {
        Sanitizable.Context context = new Sanitizable.Context();
        somlSchema.sanitize(context);
        OperationResponse report = context.getOperationReport();
        if (!report.isValid()) {
            throw new InvalidSchemaException("Found ambiguous names during sanitizing.", report);
        }
        if (context.isSanitizingApplied()) {
            somlSchema.setSanitized();
        }
    }
}

