/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.query;

import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.ExpressionVisitor;
import com.ontotext.models.query.ExpressionVisitorContext;
import java.util.Objects;

public class Value<V>
implements ExpressionValue<V> {
    public static final Value NULL_VALUE = new Value<Object>(null);
    private V value;

    public Value(V value) {
        this.value = value;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public <R, C extends ExpressionVisitorContext> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visit(this, context);
    }

    @Override
    public Value<V> deepCopy() {
        if (this.value == null) {
            return NULL_VALUE;
        }
        return new Value<V>(this.value);
    }

    public String toString() {
        if (this.value == null) {
            return "null";
        }
        return this.getValue().toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ExpressionValue)) {
            return false;
        }
        ExpressionValue that = (ExpressionValue)obj;
        return Objects.equals(this.getValue(), that.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.getValue());
    }

    public void setValue(V value) {
        this.value = value;
    }
}

