/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.mutation;

import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.FilteredSelection;
import com.ontotext.models.query.SourceLocation;
import com.ontotext.soaas.common.CollectionsUtil;
import com.ontotext.soaas.common.ObjectsUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.UnaryOperator;

public class PropertyChange {
    private final String name;
    private final Object rawValue;
    private final UnaryOperator<Object> converter;
    private final Object rawPatch;
    private final boolean replace;
    private final List<SourceLocation> sourceLocations;
    private final FilteredSelection where;

    private PropertyChange(String name, Object value, Object patch, Object replace, UnaryOperator<Object> converter, List<SourceLocation> sourceLocations) {
        this(name, value, patch, replace, converter, sourceLocations, null);
    }

    private PropertyChange(String name, Object value, Object patch, Object replace, UnaryOperator<Object> converter, List<SourceLocation> sourceLocations, ExpressionValue where) {
        this.name = name;
        this.rawValue = value;
        this.converter = converter;
        this.rawPatch = patch;
        this.sourceLocations = (List)ObjectsUtil.getOrDefault(sourceLocations, Collections.emptyList());
        this.where = new FilteredSelection(where);
        this.replace = replace instanceof Boolean ? (Boolean)replace : false;
    }

    private PropertyChange(String name, Object value, Object patch, Boolean replace, UnaryOperator<Object> converter, List<SourceLocation> sourceLocations, FilteredSelection where) {
        this.name = name;
        this.rawValue = value;
        this.converter = converter;
        this.rawPatch = patch;
        this.sourceLocations = (List)ObjectsUtil.getOrDefault(sourceLocations, Collections.emptyList());
        this.where = new FilteredSelection(where);
        this.replace = (Boolean)ObjectsUtil.getOrDefault((Object)replace, (Object)Boolean.FALSE);
    }

    static PropertyChange fromMap(String name, Map<String, Object> changes, UnaryOperator<Object> converter, List<SourceLocation> sourceLocations) {
        return new PropertyChange(name, changes.get("value"), changes.get("patch"), changes.get("replace"), converter, sourceLocations, (ExpressionValue)changes.get("where"));
    }

    static PropertyChange add(String name, Object value, UnaryOperator<Object> converter, List<SourceLocation> sourceLocations) {
        return new PropertyChange(name, value, null, Boolean.FALSE, converter, sourceLocations);
    }

    static PropertyChange update(String name, Object value, Object patch, UnaryOperator<Object> converter, List<SourceLocation> sourceLocations) {
        return new PropertyChange(name, value, patch, Boolean.FALSE, converter, sourceLocations);
    }

    static PropertyChange replace(String name, Object value, UnaryOperator<Object> converter, List<SourceLocation> sourceLocations) {
        return new PropertyChange(name, value, null, Boolean.TRUE, converter, sourceLocations);
    }

    static PropertyChange delete(String name, Object patch, UnaryOperator<Object> converter, List<SourceLocation> sourceLocations) {
        return new PropertyChange(name, null, patch, patch == null, converter, sourceLocations);
    }

    static PropertyChange mergePropertyValues(PropertyChange oldChange, Object value, SourceLocation sourceLocation) {
        LinkedHashSet<Object> mergedChange = new LinkedHashSet<Object>();
        if (oldChange.rawValue instanceof Collection) {
            mergedChange.addAll((Collection)oldChange.rawValue);
        } else {
            mergedChange.add(oldChange.rawValue);
        }
        if (value instanceof Collection) {
            mergedChange.addAll((Collection)value);
        } else {
            mergedChange.add(value);
        }
        return oldChange.copyChange(mergedChange, oldChange.getPatch(), sourceLocation);
    }

    public String getName() {
        return this.name;
    }

    public Object getRawValue() {
        return this.rawValue;
    }

    public Collection<Object> getRawValueAsCollection() {
        return this.getAsCollection(this.getRawValue());
    }

    private Collection<Object> getAsCollection(Object object) {
        if (object == null) {
            return Collections.emptyList();
        }
        if (object instanceof Collection) {
            return Collections.unmodifiableCollection((Collection)object);
        }
        return Collections.singletonList(object);
    }

    public List<SourceLocation> getSourceLocations() {
        return this.sourceLocations;
    }

    public Object getValue() {
        if (this.hasValue()) {
            try {
                return this.converter.apply(this.rawValue);
            }
            catch (RuntimeException re) {
                return this.rawValue;
            }
        }
        return null;
    }

    public Object getValueOrFail() {
        if (this.hasValue()) {
            return this.converter.apply(this.rawValue);
        }
        return null;
    }

    public Collection<Object> getValueAsCollection() {
        return this.getAsCollection(this.getValue());
    }

    public boolean hasValue() {
        return Objects.nonNull(this.rawValue);
    }

    public Object getRawPatch() {
        return this.rawPatch;
    }

    public Object getPatch() {
        if (this.hasPatch()) {
            try {
                return this.converter.apply(this.rawPatch);
            }
            catch (RuntimeException re) {
                return this.rawPatch;
            }
        }
        return null;
    }

    public Object getPatchOrFail() {
        if (this.hasPatch()) {
            return this.converter.apply(this.rawPatch);
        }
        return null;
    }

    public boolean hasPatch() {
        return Objects.nonNull(this.rawPatch);
    }

    public boolean isReplace() {
        return this.replace;
    }

    public String toString() {
        return new StringBuilder(120).append("PropertyChange{").append("name='").append(this.name).append('\'').append(", value=").append(this.rawValue).append(", patch=").append(this.rawPatch).append(", replace=").append(this.replace).append(", where=").append(this.where).append('}').toString();
    }

    public PropertyChange copyChange(Object newValue, Object newPatch, SourceLocation location) {
        List<SourceLocation> locations = this.sourceLocations;
        if (location != null) {
            locations = new LinkedList<SourceLocation>(locations);
            locations.add(location);
        }
        return new PropertyChange(this.name, newValue, newPatch, this.replace, this.converter, locations, this.where);
    }

    public static boolean sortValuesForChanges(Set<Object> valuesToAdd, Set<Object> valuesToRemove, List<PropertyChange> changeList) {
        boolean hasConditions = false;
        for (PropertyChange propertyChange : changeList) {
            Collection<Object> rawValue = propertyChange.getRawValueAsCollection();
            hasConditions |= propertyChange.getWhere() != null;
            valuesToAdd.addAll(rawValue);
            CollectionsUtil.addIfNotNull(valuesToRemove, (Object)propertyChange.getRawPatch());
        }
        return hasConditions;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PropertyChange)) {
            return false;
        }
        PropertyChange that = (PropertyChange)obj;
        return this.replace == that.replace && this.name.equals(that.name) && Objects.equals(this.rawValue, that.rawValue) && Objects.equals(this.rawPatch, that.rawPatch) && Objects.equals(this.where, that.where);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.rawValue, this.rawPatch, this.replace, this.where);
    }

    public ExpressionValue getWhere() {
        return this.where.getExpression();
    }

    public boolean hasWhere() {
        return Objects.nonNull(this.where.getExpression());
    }

    public FilteredSelection getWhereSelection() {
        return this.where;
    }
}

