/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.mutation;

import com.ontotext.models.BaseOperation;
import com.ontotext.models.OperationType;
import com.ontotext.models.Selectable;
import com.ontotext.models.Selection;
import com.ontotext.models.Shape;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.query.Arguments;
import com.ontotext.models.query.Query;
import com.ontotext.soaas.common.logging.Loggers;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class Mutation
extends BaseOperation {
    public static final String AFFECTED_OBJECTS = "affected_objects";
    public static final String AFFECTED_COUNT = "affected_count";
    private String responseType;
    private Shape responseTypeInstance;

    public List<Change> getChanges() {
        return this.arguments.getChanges().orElseThrow(() -> new IllegalStateException("Undefined mutation changes"));
    }

    @Override
    public void setSelections(List<Selection> selections) {
        this.selections = selections;
        if (selections != null) {
            selections.forEach(selection -> selection.setParent(this));
        }
    }

    public Optional<Selection> getAffectedCountSelection() {
        return this.selections.stream().filter(Selectable.byName(AFFECTED_COUNT)).findFirst();
    }

    public Optional<Selection> getAffectedObjectsSelection() {
        return this.selections.stream().filter(Selectable.byName(AFFECTED_OBJECTS)).findFirst();
    }

    public boolean requestedChanges() {
        return this.selections.stream().anyMatch(Selectable.byName(AFFECTED_COUNT).or(Selectable.byName(AFFECTED_OBJECTS)));
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public void setResponseTypeInstance(Shape responseTypeInstance) {
        this.responseTypeInstance = responseTypeInstance;
    }

    public Shape getResponseTypeInstance() {
        return this.responseTypeInstance;
    }

    public Query toQuery() {
        Query newQuery = new Query();
        newQuery.setAlias(this.getAlias());
        newQuery.setName(this.getName());
        newQuery.setRequestOperationName(this.getRequestOperationName());
        Arguments args = new Arguments();
        if (this.getOperationType() != OperationType.UPDATE) {
            try {
                args.setId(this.getChanges().stream().filter(Change::isRootChange).map(this.resolveId()).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new)));
            }
            catch (IllegalStateException ise) {
                Loggers.graphqlLogger().trace("", (Throwable)ise);
            }
            args.setWhere(this.getArguments().getWhere().orElse(null));
        }
        if (!this.getArguments().containsKey("using") && !this.getArguments().containsKey("usingNamed")) {
            this.getArguments().getWith().ifPresent(from -> args.put("from", from));
        } else {
            this.getArguments().getUsing().ifPresent(from -> args.put("from", from));
            this.getArguments().getUsingNamed().ifPresent(from -> args.put("fromNamed", from));
        }
        this.getArguments().getIncludeInferred().ifPresent(args::setIncludeInferred);
        this.getArguments().getExpandOverOwlSameAs().ifPresent(args::setExpandOverOwlSameAs);
        this.getMutationQuerySelection().ifPresent(selection -> {
            Arguments arguments = selection.getArguments();
            Optional<Collection<String>> from = arguments.getFrom();
            Optional<Collection<String>> fromNamed = arguments.getFromNamed();
            if (from.isPresent() || fromNamed.isPresent()) {
                args.remove("from");
                args.remove("fromNamed");
                from.ifPresent(graphs -> args.put("from", graphs));
                fromNamed.ifPresent(graphs -> args.put("fromNamed", graphs));
            }
            arguments.getIncludeInferred().ifPresent(args::setIncludeInferred);
            arguments.getExpandOverOwlSameAs().ifPresent(args::setExpandOverOwlSameAs);
        });
        this.getArguments().getRepository().ifPresent(args::setRepository);
        if (this.getOperationType() == OperationType.DELETE) {
            newQuery.setConstraints(this.getConstraints());
        }
        this.addResponseTypeArguments(args);
        newQuery.setArguments(args);
        newQuery.setReturnTypeInstance(this.getQueryReturnTypeInstance());
        newQuery.setReturnType(this.responseType);
        newQuery.setReturnTypeAsList(this.isReturnTypeAsList());
        newQuery.setLocation(this.getLocation());
        newQuery.setRangeCheck(this.isRangeCheck());
        newQuery.setSelections(this.getSelections().stream().filter(selection -> selection.getName().equalsIgnoreCase(this.responseType)).flatMap(selection -> selection.getSelections().stream()).map(Selection::deepCopy).collect(Collectors.toList()));
        this.getWhereSelections().stream().map(Selection::deepCopy).forEach(newQuery.getWhereSelections()::add);
        this.getMutationQuerySelection().ifPresent(selection -> selection.getWhereSelections().stream().map(Selection::deepCopy).forEach(newQuery.getWhereSelections()::add));
        return newQuery;
    }

    public Optional<Selection> getMutationQuerySelection() {
        return this.getSelections().stream().filter(selection -> selection.getName().equalsIgnoreCase(this.responseType)).findFirst();
    }

    private Shape getQueryReturnTypeInstance() {
        return (Shape)this.getReturnTypeInstance().getContainedIn().get(this.returnTypeInstance.getContainedIn().getContainedIn().getPrefixes().toModelShortIri(this.responseType));
    }

    private Function<Change, String> resolveId() {
        return change -> change.getNewEntityId().orElseGet(() -> change.getEntityId().orElse(null));
    }

    private void addResponseTypeArguments(Arguments args) {
        this.getSelections().stream().filter(selection -> selection.getName().equalsIgnoreCase(this.responseType)).map(Selection::getArguments).findFirst().ifPresent(args::putAll);
    }
}

