/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.extensions;

import com.ontotext.models.ErrorMessages;
import com.ontotext.models.extensions.ConditionalReport;
import com.ontotext.models.extensions.Severity;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class OperationResponse
implements ConditionalReport,
Serializable {
    private static final long serialVersionUID = 2402122083956257207L;
    public static final OperationResponse EMPTY = new OperationResponse(){

        @Override
        List<OperationMessage> createMessageList() {
            return Collections.emptyList();
        }
    };
    private List<OperationMessage> messages = this.createMessageList();
    private boolean forceFail = false;

    public static OperationResponse createFailed() {
        OperationResponse response = new OperationResponse();
        response.forceFail = true;
        return response;
    }

    @Override
    public List<OperationMessage> getMessages() {
        return this.messages;
    }

    List<OperationMessage> createMessageList() {
        return new LinkedList<OperationMessage>();
    }

    public boolean isValid() {
        return !this.forceFail && this.getMessages().stream().noneMatch(OperationMessage::isFailureMessage);
    }

    public boolean hasFatalErrors() {
        return this.getMessages().stream().anyMatch(OperationMessage::isFatal);
    }

    public List<OperationMessage> getErrors() {
        return this.getMessageOfType(OperationMessage::isError);
    }

    public boolean hasWarnings() {
        return this.getMessages().stream().anyMatch(OperationMessage::isWarning);
    }

    public List<OperationMessage> getWarnings() {
        return this.getMessageOfType(OperationMessage::isWarning);
    }

    public List<OperationMessage> getInfos() {
        return this.getMessageOfType(OperationMessage::isInfo);
    }

    private List<OperationMessage> getMessageOfType(Predicate<OperationMessage> filter) {
        return this.getMessages().stream().filter(filter).collect(Collectors.toList());
    }

    public OperationResponse addErrorMessage(String message, Object ... args) {
        this.messages.add(new OperationMessage(Severity.ERROR, (Serializable)((Object)ErrorMessages.get(message, args))));
        return this;
    }

    public OperationResponse addErrorMessage(String message) {
        this.messages.add(new OperationMessage(Severity.ERROR, (Serializable)((Object)ErrorMessages.get(message))));
        return this;
    }

    public OperationResponse addErrorMessage(Serializable message) {
        this.messages.add(new OperationMessage(Severity.ERROR, message));
        return this;
    }

    public OperationResponse addFatalMessage(String message, Object ... args) {
        this.messages.add(new OperationMessage(Severity.FATAL, (Serializable)((Object)ErrorMessages.get(message, args))));
        return this;
    }

    public OperationResponse addWarningMessage(Serializable message) {
        Object warningMessage = message;
        if (message instanceof String) {
            warningMessage = ErrorMessages.get(message.toString());
        }
        this.messages.add(new OperationMessage(Severity.WARN, (Serializable)warningMessage));
        return this;
    }

    public OperationResponse addWarningMessage(String message, Object ... args) {
        this.messages.add(new OperationMessage(Severity.WARN, (Serializable)((Object)ErrorMessages.get(message, args))));
        return this;
    }

    public OperationResponse addError(String message) {
        this.messages.add(new OperationMessage(Severity.ERROR, (Serializable)((Object)message)));
        return this;
    }

    public OperationResponse addWarning(String message) {
        this.messages.add(new OperationMessage(Severity.WARN, (Serializable)((Object)message)));
        return this;
    }

    public OperationResponse addInfo(String message) {
        this.messages.add(new OperationMessage(Severity.INFO, (Serializable)((Object)message)));
        return this;
    }

    public OperationResponse addAll(OperationResponse otherReport) {
        this.messages.addAll(otherReport.getMessages());
        return this;
    }

    public OperationResponse add(OperationMessage message) {
        this.messages.add(message);
        return this;
    }

    public String toString() {
        return this.getMessages().toString();
    }

    public List<Serializable> getErrorMessages() {
        return this.getSerializedMessagesOfType(OperationMessage::isError, OperationMessage::getMessage);
    }

    public List<Serializable> getWarningMessages() {
        return this.getSerializedMessagesOfType(OperationMessage::isWarning, OperationMessage::getMessage);
    }

    public List<Serializable> getInfoMessages() {
        return this.getSerializedMessagesOfType(OperationMessage::isInfo, OperationMessage::serialize);
    }

    private List<Serializable> getSerializedMessagesOfType(Predicate<OperationMessage> filter, Function<OperationMessage, Serializable> mapper) {
        return this.messages.stream().filter(filter).map(mapper).collect(Collectors.toList());
    }

    public static OperationResponse merge(OperationResponse previous, OperationResponse next) {
        if (previous == null) {
            previous = new OperationResponse();
        }
        previous.messages.addAll(next.messages);
        return previous;
    }

    public static class OperationMessage
    implements Serializable {
        private static final long serialVersionUID = 2704322080956297230L;
        private final Severity severity;
        private final Serializable message;

        OperationMessage(Severity severity, Serializable message) {
            this.severity = severity;
            this.message = message;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public Serializable getMessage() {
            return this.message;
        }

        public boolean isError() {
            return this.severity == Severity.ERROR;
        }

        public boolean isFailureMessage() {
            return this.severity == Severity.ERROR || this.severity == Severity.FATAL;
        }

        public boolean isWarning() {
            return this.severity == Severity.WARN;
        }

        public boolean isFatal() {
            return this.severity == Severity.FATAL;
        }

        public boolean isInfo() {
            return this.severity == Severity.INFO;
        }

        public String toString() {
            return String.valueOf((Object)this.severity) + ": " + String.valueOf(this.message);
        }

        public Serializable serialize() {
            if (this.message instanceof String) {
                return this.toString();
            }
            return this.message;
        }
    }
}

