/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.extensions;

import com.ontotext.models.PropertyShape;
import com.ontotext.models.ScalarType;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.SchemaExtension;
import com.ontotext.soaas.plugin.Order;
import java.util.Objects;
import java.util.function.Predicate;

@Order(value=25)
public class GenerateNameProperty
implements SchemaExtension {
    @Override
    public void process(SomlSchema somlSchema) {
        for (Shape shape : somlSchema.getObjects().values()) {
            String name = GenerateNameProperty.getNameIfDefinedAndNotPresent(shape);
            if (name == null) continue;
            PropertyShape propertyShape = GenerateNameProperty.createNameProperty(somlSchema, name);
            shape.addProperty(propertyShape);
            propertyShape = GenerateNameProperty.createNameProperty(somlSchema, name);
            shape.getAllProperties().put(propertyShape.getName(), propertyShape);
            propertyShape.setContainedIn(shape.getAllProperties());
        }
    }

    private static String getNameIfDefinedAndNotPresent(Shape shape) {
        String name = shape.getName();
        if (name == null) {
            return null;
        }
        PropertyShape property = (PropertyShape)shape.getAllProperties().get(name);
        if (property != null) {
            return null;
        }
        String shortIri = shape.getContainedIn().getContainedIn().getPrefixes().toShortIri(name);
        if (shape.getAllProperties().values().stream().map(PropertyShape::getAsAbsoluteRdfProp).anyMatch(Predicate.isEqual(name).or(Predicate.isEqual(shortIri)))) {
            return null;
        }
        return name;
    }

    private static PropertyShape createNameProperty(SomlSchema somlSchema, String name) {
        String escapedName = null;
        if (name.startsWith("<") && name.endsWith(">")) {
            escapedName = name.substring(1, name.length() - 1);
        }
        PropertyShape propertyShape = PropertyShape.create(Objects.toString(escapedName, name), "string", 1, "1");
        propertyShape.setRdfProp(escapedName == null ? somlSchema.getPrefixes().nameToShortIri(name) : name);
        propertyShape.setScalarType((ScalarType)somlSchema.getTypes().get("string"));
        return propertyShape;
    }
}

