/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.extensions;

import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.SchemaExtension;
import com.ontotext.models.sanitizing.SchemaSanitizerUtils;
import com.ontotext.soaas.common.StringManipulation;
import com.ontotext.soaas.plugin.Order;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@Order(value=50)
public class GenerateMutationResponseTypes
implements SchemaExtension {
    private static final Set<String> SYSTEM_SHAPES = Shapes.SYSTEM_SHAPES.stream().filter(Predicate.isEqual("HealthCheck").negate()).collect(Collectors.toSet());
    public static final String MUTATION_RESPONSE_SUFFIX = "_Mutation_Response";

    @Override
    public boolean canHandle(SomlSchema somlSchema) {
        return !Boolean.TRUE.equals(somlSchema.getInternal()) && somlSchema.getSpecialPrefixes().getVocabPrefix().isPresent();
    }

    @Override
    public void process(SomlSchema somlSchema) {
        Shapes objects = somlSchema.getObjects();
        LinkedHashMap<String, Shape> typesCopy = new LinkedHashMap<String, Shape>(objects);
        typesCopy.keySet().removeAll(SYSTEM_SHAPES);
        typesCopy.values().removeIf(Shape::isSynthetic);
        typesCopy.forEach((name, shape) -> objects.computeIfAbsent(name + MUTATION_RESPONSE_SUFFIX, newName -> this.createMutationResponseFor((String)newName, (Shape)shape)));
        somlSchema.expandSchema();
    }

    private Shape createMutationResponseFor(String newName, Shape base) {
        String typeName;
        Shape shape = new Shape(true);
        shape.setId(newName);
        shape.setDescr("System generated type used for mutation response for " + SchemaSanitizerUtils.sanitizeValue(base.getId()));
        shape.setInherits("MutationResponse");
        shape.setSynthetic(Boolean.TRUE);
        if (base.getId().contains(":")) {
            typeName = base.getId();
        } else {
            String shapeId = base.getId();
            typeName = StringUtils.uncapitalize((String)shapeId);
        }
        PropertyShape typeProperty = PropertyShape.create(typeName, base.getId(), null, "1");
        typeProperty.setDescr("Contains references to all affected " + SchemaSanitizerUtils.sanitizeValue(StringManipulation.replaceColonWithUnderscore((String)base.getId())) + " objects");
        shape.addProperty(typeProperty);
        return shape;
    }
}

