/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.extensions;

import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.SchemaExtension;
import com.ontotext.soaas.plugin.Order;
import java.util.ArrayList;
import java.util.function.Predicate;

@Order(value=70)
public class GenerateCountProperties
implements SchemaExtension {
    @Override
    public boolean canHandle(SomlSchema somlSchema) {
        return somlSchema.getConfig().isCollectionCountingEnabled().filter(Predicate.isEqual(Boolean.TRUE)).isPresent();
    }

    @Override
    public void preBaseSchemaMergeProcessing(SomlSchema soml) {
        for (Shape shape : soml.getObjects().values()) {
            if (shape.isSystem() || shape.isUnion()) continue;
            for (PropertyShape property : new ArrayList(shape.getProps().values())) {
                if (!property.isMultivalued() || !shape.getProperty(property.getName() + "_count").isEmpty()) continue;
                PropertyShape countProperty = PropertyShape.create(property.getName() + "_count", "nonNegativeInteger", null, "1");
                countProperty.setAsGenerated();
                countProperty.setReadOnly(true);
                countProperty.setFiltered(true);
                countProperty.setOrdered(true);
                countProperty.setRestrictive(false);
                countProperty.setValidationIgnored(true);
                countProperty.setRangeCheck(Boolean.TRUE.equals(property.getRangeCheck()) || property.getInverseAlias() != null);
                countProperty.setDescr("Count property for " + property.getName());
                shape.addProperty(countProperty);
            }
        }
    }
}

