/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.extensions;

import com.ontotext.models.extensions.ConfigurationResolver;
import com.ontotext.models.extensions.SchemaExtension;
import com.ontotext.models.extensions.SchemaValidator;
import com.ontotext.soaas.plugin.PluginLoader;
import com.ontotext.soaas.plugin.PluginsManager;
import java.util.List;

public class Extensions {
    private static PluginLoader<SchemaExtension> schemaExtensionsLoader = PluginsManager.loader(SchemaExtension.class);
    private static PluginLoader<SchemaValidator> schemaValidatorsLoader = PluginsManager.loader(SchemaValidator.class);
    private static volatile boolean schemaExtensionsChanged = false;
    private static volatile boolean schemaValidatorsChanged = false;
    private List<SchemaExtension> schemaExtensions;
    private List<SchemaValidator> schemaValidators;

    public List<SchemaExtension> getSchemaExtensions() {
        if (this.schemaExtensions == null || schemaExtensionsChanged) {
            this.schemaExtensions = schemaExtensionsLoader.load();
            schemaExtensionsChanged = false;
        }
        return this.schemaExtensions;
    }

    public List<SchemaValidator> getSchemaValidators() {
        if (this.schemaValidators == null || schemaValidatorsChanged) {
            this.schemaValidators = schemaValidatorsLoader.load();
            schemaValidatorsChanged = false;
        }
        return this.schemaValidators;
    }

    public static void configure(ConfigurationResolver configurationResolver) {
        schemaExtensionsLoader.withConfig(ConfigurationResolver.class, () -> configurationResolver);
        schemaValidatorsLoader.withConfig(ConfigurationResolver.class, () -> configurationResolver);
        schemaExtensionsChanged = true;
        schemaValidatorsChanged = true;
    }

    public static void reset() {
        schemaExtensionsLoader.reset();
        schemaValidatorsLoader.reset();
        schemaExtensionsChanged = true;
        schemaValidatorsChanged = true;
    }
}

