/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.extensions;

import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.SchemaExtension;
import com.ontotext.models.query.LangFilter;
import com.ontotext.models.search.Analysis;
import com.ontotext.models.search.BuiltInAnalyzers;
import com.ontotext.models.search.SearchConfig;
import com.ontotext.soaas.plugin.Order;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

@Order(value=1010)
public class AssignSearchConfigDefaults
implements SchemaExtension {
    public static final String DEFAULT_ANALYZER = "standard";

    @Override
    public void process(SomlSchema soml) {
        boolean defaultUsed = true;
        String defaultAnalyzer = DEFAULT_ANALYZER;
        Optional<String> somlDefined = this.getSystemDefault(soml);
        if (somlDefined.isPresent()) {
            defaultUsed = false;
            defaultAnalyzer = somlDefined.get();
        }
        this.processGlobalProperties(soml, defaultAnalyzer, defaultUsed);
        this.processShapes(soml, defaultAnalyzer, defaultUsed);
    }

    private void processShapes(SomlSchema soml, String defaultAnalyzer, boolean defaultUsed) {
        soml.getObjects().values().stream().filter(this::isProcessable).forEach(shape -> this.processShape(soml, (Shape)shape, defaultAnalyzer, defaultUsed));
    }

    private boolean isProcessable(Shape shape) {
        return !shape.isHierarchyInvalid() && !shape.isSystem() && shape.isSynthetic() == false && !shape.isUnion();
    }

    private void processGlobalProperties(SomlSchema soml, String defaultAnalyzer, boolean defaultUsed) {
        soml.getProperties().values().stream().filter(PropertyShape::isSearchable).filter(this::isStringOrLang).forEach(prop -> this.processProp((PropertyShape)prop, defaultAnalyzer, defaultUsed));
    }

    private void processShape(SomlSchema soml, Shape shape, String defaultAnalyzer, boolean defaultUsed) {
        if (shape.getSearch() == null && !shape.isHierarchyInvalid()) {
            shape.setSearch(this.getDefaultSearch(defaultAnalyzer));
        } else {
            defaultUsed &= this.addShapeAnalyzer(shape, defaultAnalyzer);
        }
        this.processShapeProps(shape, defaultUsed);
        this.addCronExpressionIfMissing(soml, shape);
    }

    private void addCronExpressionIfMissing(SomlSchema soml, Shape shape) {
        soml.getConfig().getSearch().map(SearchConfig::getCron).filter(StringUtils::isNotBlank).ifPresent(globalCron -> {
            SearchConfig search = shape.getSearch();
            if (StringUtils.isBlank((CharSequence)search.getCron())) {
                search.setCron((String)globalCron);
            }
        });
    }

    private void processShapeProps(Shape shape, boolean defaultUsed) {
        shape.getAllProperties().values().stream().filter(this::isStringOrLang).forEach(prop -> this.processProp((PropertyShape)prop, shape.getSearch().getAnalysis().getAnalyzer(), defaultUsed));
    }

    private boolean addShapeAnalyzer(Shape shape, String defaultAnalyzer) {
        boolean defaultUsed = this.addAnalyzerToConfig(shape.getSearch(), defaultAnalyzer);
        if (!defaultUsed) {
            return false;
        }
        String parentAnalyzer = this.getAnalyzerFromParentIfExists(shape);
        if (parentAnalyzer != null) {
            shape.getSearch().getAnalysis().setAnalyzer(parentAnalyzer);
            return false;
        }
        return true;
    }

    private String getAnalyzerFromParentIfExists(Shape shape) {
        return shape.forEachParentShape().map(parent -> {
            Analysis analysis = parent.getSearchSafe().getAnalysis();
            if (analysis != null && analysis.isTracked("analyzer")) {
                return analysis.getAnalyzer();
            }
            return null;
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private boolean addAnalyzerToConfig(SearchConfig config, String defaultAnalyzer) {
        Analysis configAnalysis;
        if (config.getAnalysis() == null) {
            Analysis analysis = new Analysis();
            analysis.stopTracking();
            config.setAnalysis(analysis);
        }
        if ((configAnalysis = config.getAnalysis()).getAnalyzer() == null || !configAnalysis.isTracked("analyzer")) {
            configAnalysis.setAnalyzer(defaultAnalyzer);
            return true;
        }
        return false;
    }

    private void processProp(PropertyShape propertyShape, String defaultAnalyzer, boolean defaultUsed) {
        if (propertyShape.getSearch() == null) {
            propertyShape.setSearch(this.getDefaultSearch(defaultAnalyzer));
        } else {
            defaultUsed &= this.addPropAnalyzer(propertyShape, defaultAnalyzer);
        }
        if (propertyShape.getScalarType().isLangStringSupported()) {
            this.addOrClearLangConfiguration(propertyShape, defaultUsed);
        }
    }

    private SearchConfig getDefaultSearch(String defaultAnalyzer) {
        Analysis analysis = new Analysis();
        analysis.setAnalyzer(defaultAnalyzer);
        analysis.clearTrackedInformation();
        SearchConfig search = new SearchConfig();
        search.setIndex(SearchConfig.Index.FALSE);
        search.setAnalysis(analysis);
        search.clearTrackedInformation();
        return search;
    }

    private void addOrClearLangConfiguration(PropertyShape propertyShape, boolean defaultUsed) {
        if (defaultUsed) {
            this.addDefaultLangConfiguration(propertyShape);
        } else {
            Analysis analysis = propertyShape.getSearch().getAnalysis();
            if (analysis != null && !analysis.isTracked("lang")) {
                analysis.setLang(null);
            }
        }
    }

    private void addDefaultLangConfiguration(PropertyShape propertyShape) {
        if (propertyShape.getLangConfig() != null) {
            List<Object> validationTokens;
            HashMap<LangFilter.Token, Analysis> langMap = new HashMap<LangFilter.Token, Analysis>();
            try {
                validationTokens = propertyShape.getLangConfig().getValidator().getTokens();
            }
            catch (IllegalArgumentException ex) {
                validationTokens = Collections.emptyList();
            }
            if (!validationTokens.isEmpty()) {
                validationTokens.stream().flatMap(this::toValidTokens).forEach(token -> token.getLanguage().flatMap(BuiltInAnalyzers::analyzerForLang).ifPresent(analyzer -> langMap.put((LangFilter.Token)token, new Analysis((String)analyzer))));
            }
            if (!langMap.isEmpty()) {
                this.mergeLangConfig(propertyShape, langMap);
            }
        }
    }

    private Stream<LangFilter.Token> toValidTokens(LangFilter.Token token) {
        List<LangFilter.Token> tokens = token instanceof LangFilter.TokenGroup ? ((LangFilter.TokenGroup)token).getTokens() : Collections.singletonList(token);
        return tokens.stream().filter(LangFilter.Token::isInclusion).filter(tok -> tok.getType() == LangFilter.TokenType.EXACT_MATCH);
    }

    private void mergeLangConfig(PropertyShape propertyShape, Map<LangFilter.Token, Analysis> langMap) {
        Analysis analysis = propertyShape.getSearch().getAnalysis();
        if (analysis.getLang() == null) {
            analysis.stopTracking();
            analysis.setLangFromTokenMap(langMap);
        } else {
            HashMap<String, Analysis> langs = new HashMap<String, Analysis>(analysis.getLang());
            langMap.forEach((key, val) -> langs.putIfAbsent(key.toString(), (Analysis)val));
            analysis.setLang(langs);
        }
    }

    private boolean isStringOrLang(PropertyShape propertyShape) {
        return propertyShape.isScalarType() && (propertyShape.getScalarType().is("string") || propertyShape.getScalarType().isLangStringSupported());
    }

    private boolean addPropAnalyzer(PropertyShape propertyShape, String defaultAnalyzer) {
        return this.addAnalyzerToConfig(propertyShape.getSearch(), defaultAnalyzer);
    }

    private Optional<String> getSystemDefault(SomlSchema soml) {
        SearchConfig config;
        Optional<SearchConfig> search = soml.getConfig().getSearch();
        if (search.isPresent() && (config = search.get()).getAnalysis() != null && config.getAnalysis().getAnalyzer() != null) {
            return Optional.of(config.getAnalysis().getAnalyzer());
        }
        return Optional.empty();
    }

    @Override
    public boolean canHandle(SomlSchema soml) {
        return Boolean.FALSE.equals(soml.getInternal()) || !"/soml/soml-rbac".equals(soml.getId());
    }
}

