/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.ActionFilter;
import com.ontotext.models.Selectable;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.ExpressionVisitor;
import com.ontotext.models.query.ExpressionVisitorContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SimpleActionFilter
implements ActionFilter {
    private final ExpressionValue<Object> filter;
    private final List<Selectable> selections;

    public SimpleActionFilter(ExpressionValue<Object> filter, List<Selectable> selections) {
        this.filter = filter;
        this.selections = selections;
    }

    @Override
    public ExpressionValue<Object> getFilter() {
        return this.filter;
    }

    @Override
    public List<Selectable> getSelections() {
        return this.selections;
    }

    @Override
    public <R, C extends ExpressionVisitorContext> SimpleActionFilter acceptFilterVisitor(ExpressionVisitor<R, C> visitor, C context) {
        ExpressionValue<Object> filterCopy = this.filter.deepCopy();
        filterCopy.accept(visitor, context);
        if (this.filter.equals(filterCopy)) {
            return this;
        }
        return new SimpleActionFilter(filterCopy, new ArrayList<Selectable>(this.selections));
    }

    public SimpleActionFilter deepCopy() {
        return new SimpleActionFilter(this.filter.deepCopy(), new ArrayList<Selectable>(this.selections));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleActionFilter that = (SimpleActionFilter)obj;
        return Objects.equals(this.filter, that.filter) && Objects.equals(this.selections, that.selections);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.selections);
    }

    public String toString() {
        return "ActionFilter{filter=" + String.valueOf(this.filter) + ", selections=" + String.valueOf(this.selections) + "}";
    }
}

