/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.ContainedIn;
import com.ontotext.models.ErrorMessages;
import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.LangConfig;
import com.ontotext.models.ModelTracker;
import com.ontotext.models.Prefixes;
import com.ontotext.models.Properties;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.ScalarType;
import com.ontotext.models.ScalarTypes;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.TrackedModel;
import com.ontotext.models.TypeAccessMode;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.sanitizing.Sanitizable;
import com.ontotext.models.sanitizing.SchemaSanitizerUtils;
import com.ontotext.models.yaml.YamlPrinter;
import com.ontotext.models.yaml.YamlRepresentable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Shapes
extends LinkedHashMap<String, Shape>
implements ContainedIn<SomlSchema>,
TrackedModel,
YamlRepresentable,
Sanitizable {
    public static final String OBJECT = "Object";
    public static final String NAMEABLE = "Nameable";
    public static final String LITERAL = "Literal";
    public static final String MUTATION_RESPONSE = "MutationResponse";
    public static final String SUBSCRIPTION_REQUEST = "SubscriptionRequest";
    public static final String SUBSCRIPTION_RESPONSE = "SubscriptionResponse";
    public static final String HEALTH_CHECK = "HealthCheck";
    public static final String SERVICE = "_Service";
    public static final String AFFECTED_COUNT_TYPENAME = "AffectedCount";
    public static final String AFFECTED_OBJECTS_TYPENAME = "AffectedObjects";
    private static final String[] INTERNAL_SUFFIXES = new String[]{"_Mutation_Response", "_Subscription"};
    public static final Set<String> AFFECTED_TYPES = Stream.of("AffectedCount", "AffectedObjects").collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    public static final Set<String> RESPONSE_TYPES = Stream.of("MutationResponse", "SubscriptionRequest", "SubscriptionResponse").collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    public static final Set<String> SYSTEM_SHAPES = Stream.of("Object", "Nameable", "Literal", "MutationResponse", "SubscriptionRequest", "SubscriptionResponse", "HealthCheck", "_Service", "AffectedCount", "AffectedObjects", "Query", "Mutation", "Subscription").collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    public static final Set<String> SYSTEM_INTERFACES = SYSTEM_SHAPES.stream().map(type -> type + "Interface").collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    public static final Set<String> TYPES_THAT_NOT_INHERIT_OBJECT = Stream.of("Literal", "Nameable", "Object", "MutationResponse", "SubscriptionRequest", "SubscriptionResponse", "AffectedCount", "AffectedObjects").collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    public static final String DUMMY_TYPE_NAME = "_type";
    private transient SomlSchema schema;
    private Map<String, List<Shape>> parentToChildMapping;
    private transient Map<String, List<Shape>> hierarchyMapping;
    private Set<String> typeDescriptors;
    private transient Map<String, Shape> typeToShape;
    private transient ModelTracker tracker = ModelTracker.notTracked();

    public Shapes() {
        this.hierarchyMapping = new ConcurrentHashMap<String, List<Shape>>();
        this.tracker = ModelTracker.tracked();
    }

    public Shapes(boolean flag) {
        this.hierarchyMapping = new ConcurrentHashMap<String, List<Shape>>();
    }

    public static boolean isSystemShapeOrInterface(String name) {
        return SYSTEM_SHAPES.contains(name) || SYSTEM_INTERFACES.contains(name);
    }

    public Collection<Shape> getConcreteSubTypes(String name) {
        List children = this.getParentToChildMapping().getOrDefault(name, Collections.emptyList());
        LinkedHashSet<Shape> shapesTree = new LinkedHashSet<Shape>();
        children.stream().filter(shape -> !shape.isAbstract()).forEach(shapesTree::add);
        for (Shape child : children) {
            Collection<Shape> subTypes = this.getConcreteSubTypes(child.getId());
            shapesTree.addAll(subTypes);
        }
        return shapesTree;
    }

    public Collection<Shape> getSubTypes(String name) {
        List children = this.getParentToChildMapping().getOrDefault(name, Collections.emptyList());
        LinkedHashSet<Shape> shapesTree = new LinkedHashSet<Shape>(children);
        for (Shape child : children) {
            Collection<Shape> subTypes = this.getSubTypes(child.getId());
            shapesTree.addAll(subTypes);
        }
        return shapesTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<Shape>> getParentToChildMapping() {
        if (this.parentToChildMapping == null) {
            Shapes shapes = this;
            synchronized (shapes) {
                LinkedHashMap<String, List> mapping = new LinkedHashMap<String, List>();
                for (Shape shape : this.values()) {
                    if (!shape.getInheritsAsList().isEmpty() && !shape.isHierarchyInvalid()) {
                        shape.getInheritsAsList().forEach((? super T parent) -> mapping.computeIfAbsent((String)parent, (? super K k) -> new LinkedList()).add(shape));
                    }
                    if (!TYPES_THAT_NOT_INHERIT_OBJECT.contains(shape.getId())) {
                        mapping.computeIfAbsent(OBJECT, (? super K k) -> new LinkedList()).add(shape);
                    }
                    if (shape.getName() == null) continue;
                    mapping.computeIfAbsent(NAMEABLE, (? super K k) -> new LinkedList()).add(shape);
                }
                mapping.replaceAll((parent, children) -> Collections.unmodifiableList(children));
                this.parentToChildMapping = Collections.unmodifiableMap(mapping);
            }
        }
        return this.parentToChildMapping;
    }

    public Optional<Shape> getIfPresent(String id) {
        return Optional.ofNullable((Shape)this.get(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Shape getByType(String type) {
        if (this.typeToShape == null) {
            Shapes shapes = this;
            synchronized (shapes) {
                LinkedHashMap<String, Shape> mapping = new LinkedHashMap<String, Shape>(this.size() * 5);
                Prefixes prefixes = this.getContainedIn().getPrefixes();
                for (Shape shape : this.values()) {
                    try {
                        if (shape.isHierarchyInvalid()) continue;
                        Shapes.buildTypeMapping(shape, mapping);
                        if (!shape.isTypePropRdfType()) continue;
                        shape.getTypeAsList().forEach((? super T typeValue) -> Shapes.buildTypeMapping(typeValue, shape, mapping, prefixes));
                    }
                    catch (InvalidSchemaException | ClassCastException runtimeException) {}
                }
                this.typeToShape = mapping;
            }
        }
        return this.typeToShape.get(type);
    }

    private static void buildTypeMapping(String typeValue, Shape shape, Map<String, Shape> mapping, Prefixes prefixes) {
        try {
            mapping.put(typeValue, shape);
            String iri = prefixes.toIri(typeValue);
            mapping.put(iri, shape);
            mapping.put(prefixes.toShortIri(iri), shape);
            mapping.put(prefixes.toName(iri), shape);
        }
        catch (InvalidSchemaException invalidSchemaException) {
            // empty catch block
        }
    }

    private static void buildTypeMapping(Shape shape, Map<String, Shape> mapping) {
        try {
            mapping.put(shape.getId(), shape);
            mapping.put(shape.asGraphQl(), shape);
            mapping.put(shape.asShortIri(), shape);
            mapping.put(shape.asIri(), shape);
        }
        catch (InvalidSchemaException invalidSchemaException) {
            // empty catch block
        }
    }

    public String resolveByType(String typeValue, Function<Shape, String> transform) {
        Shape shape = this.getByType(typeValue);
        if (shape != null) {
            return transform.apply(shape);
        }
        return typeValue;
    }

    public Properties getAllShapeProperties(String name) {
        return ((Shape)this.get(name)).getAllProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Shape> getHierarchy(String name) {
        List<Shape> hierarchy;
        if (this.hierarchyMapping == null) {
            Shapes shapes = this;
            synchronized (shapes) {
                HashMap mapping = new HashMap();
                OperationResponse errors = new OperationResponse();
                for (Shape shape : this.values()) {
                    try {
                        mapping.put(shape.getId(), List.copyOf(this.getShapeHierarchy(shape)));
                    }
                    catch (InvalidSchemaException ise) {
                        mapping.put(shape.getId(), List.of());
                        errors.addAll(ise.getValidationReport());
                    }
                }
                this.hierarchyMapping = Collections.unmodifiableMap(mapping);
                if (!errors.isValid()) {
                    throw new InvalidSchemaException(null, errors);
                }
            }
        }
        if ((hierarchy = this.hierarchyMapping.get(name)) == null) {
            throw new IllegalArgumentException(ErrorMessages.get("undefined.type", name));
        }
        return hierarchy;
    }

    public List<Shape> getHierarchyOnDemand(String name) {
        Shape shape = (Shape)this.get(name);
        if (shape == null) {
            throw new IllegalArgumentException(ErrorMessages.get("undefined.type", name));
        }
        return this.getShapeHierarchy(shape);
    }

    private LinkedList<Shape> getShapeHierarchy(Shape shape) {
        LinkedList<Shape> hierarchy = new LinkedList<Shape>();
        hierarchy.add(shape);
        shape.forEachParent(hierarchy::addFirst);
        hierarchy.stream().map(Shape::getName).filter(Objects::nonNull).findFirst().ifPresent(definedName -> hierarchy.addFirst((Shape)this.get(NAMEABLE)));
        if (!TYPES_THAT_NOT_INHERIT_OBJECT.contains(shape.getId())) {
            hierarchy.addFirst((Shape)this.get(OBJECT));
        }
        return hierarchy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getSoTypeDescriptors() {
        if (this.typeDescriptors == null) {
            Shapes shapes = this;
            synchronized (shapes) {
                this.typeDescriptors = this.schema.getObjects().values().stream().filter(sh -> sh.getType() != null).map(Shape::getTypePropIri).collect(Collectors.toSet());
            }
        }
        return this.typeDescriptors;
    }

    void expand(SomlSchema somlSchema, Properties baseProperties, ScalarTypes scalars) {
        this.schema = somlSchema;
        this.typeToShape = null;
        this.parentToChildMapping = null;
        this.hierarchyMapping = null;
        String vocPfx = this.schema.getSpecialPrefixes().getVocabPrefix().orElse(null);
        this.forEach((key, shape) -> {
            shape.setId((String)key);
            if (shape.getLabel() == null) {
                shape.setLabel(SchemaSanitizerUtils.keyToDisplayLabel(key));
            }
            if (shape.getTypeProp() == null) {
                shape.setTypeProp("rdf:type");
            } else {
                String typeProp = shape.getTypeProp();
                if ("none".equalsIgnoreCase(typeProp) && (shape.getProps() == null || !shape.getProps().containsKey(DUMMY_TYPE_NAME))) {
                    this.generateDummyType(scalars, (String)key, (Shape)shape);
                } else {
                    shape.setTypeProp(Properties.simplifyName(vocPfx, typeProp));
                }
                shape.setAccess((Object)Objects.requireNonNullElse(shape.getAccessMode(), TypeAccessMode.DEFAULT));
            }
        });
        this.values().forEach(this.setContainedIn());
        this.values().forEach(this.addPropertiesIfNon());
        Properties baseAndObjectProperties = new Properties(true);
        baseAndObjectProperties.merge(baseProperties);
        Shape object = (Shape)this.get(OBJECT);
        if (object != null) {
            this.expandShape(object, baseProperties, scalars);
            object.setAllProperties(this.computeAllShapeProperties(OBJECT));
            baseAndObjectProperties.merge(object.getProps());
        }
        Properties nameableProperties = new Properties(true);
        Shape nameable = (Shape)this.get(NAMEABLE);
        if (nameable != null) {
            this.expandShape(nameable, baseProperties, scalars);
            nameable.setAllProperties(this.computeAllShapeProperties(NAMEABLE));
            nameableProperties.merge(nameable.getProps());
        }
        this.traverseChildrenFirsts(this.addInheritedProperties(scalars));
        this.traverseChildrenFirsts(this.addBaseProperties(baseAndObjectProperties, scalars));
        this.traverseChildrenFirsts(this.addBasePropertiesIf(nameableProperties, scalars, shape -> shape.getName() != null));
        this.traverseChildrenFirsts(this.setDefaults());
        this.traverseParentsFirsts(this.setNameProperty());
        this.traverseParentsFirsts(this.addBaseProperties(baseAndObjectProperties, scalars));
        this.traverseParentsFirsts(this.copyLangConfigFromRoot());
        this.traverseParentsFirsts(this.setDefaults());
        this.traverseParentsFirsts(this.setAllProperties());
        this.traverseParentsFirsts(this.inheritServiceFromParent());
        this.values().forEach((? super T shape) -> shape.setPattern(Objects.toString(shape.getPattern(), "uuid")));
        this.parentToChildMapping = null;
        this.hierarchyMapping = null;
        this.typeToShape = null;
        this.getParentToChildMapping();
        this.getByType("");
    }

    private void generateDummyType(ScalarTypes scalars, String key, Shape shape) {
        PropertyShape dummyType = PropertyShape.create(DUMMY_TYPE_NAME, "iri", 1, "1");
        dummyType.setScalarType((ScalarType)scalars.get("iri"));
        dummyType.setAsGenerated();
        dummyType.setReadOnly(true);
        dummyType.setLabel("Type");
        dummyType.setDescr("System generated type property");
        try {
            dummyType.setRdfProp(String.format("BIND(<%s> as ?_value).", this.schema.getPrefixes().toIri(key)));
            dummyType.setDefaults();
            shape.addProperty(dummyType);
            shape.setTypeProp(dummyType.getName());
        }
        catch (InvalidSchemaException invalidSchemaException) {
            // empty catch block
        }
    }

    private Consumer<Shape> inheritServiceFromParent() {
        return shape -> {
            if (shape.isTracked("sparqlFederatedService")) {
                return;
            }
            shape.getInheritsAsList().stream().map(this::get).filter(Objects::nonNull).map(Shape::getSparqlFederatedService).filter(Objects::nonNull).findFirst().ifPresent(shape::setSparqlFederatedService);
        };
    }

    private Consumer<Shape> setContainedIn() {
        return sh -> sh.setContainedIn(this);
    }

    private Consumer<Shape> addPropertiesIfNon() {
        return shape -> {
            Properties props;
            if (shape.getProps() == null) {
                props = new Properties(true);
                props.setContainedIn((Shape)shape);
                shape.setProps(props);
            }
            if (shape.getAllProperties() == null) {
                props = new Properties(true);
                props.setContainedIn((Shape)shape);
                shape.setAllProperties(props);
            }
        };
    }

    private Consumer<Shape> addInheritedProperties(ScalarTypes scalars) {
        return shape -> Stream.concat(shape.getInheritsAsList().stream(), Stream.of(OBJECT)).map(this::get).filter(Objects::nonNull).forEach((? super T parentShape) -> shape.expand((Shape)parentShape, parentShape.getProps(), scalars, this));
    }

    private Consumer<Shape> addBaseProperties(Properties baseProperties, ScalarTypes scalars) {
        return shape -> {
            shape.getProps().fillInContainedIn();
            shape.getProps().expand(baseProperties, scalars, (Shape)shape, this.getContainedIn().getSpecialPrefixes().getVocabPrefix().orElse(null));
        };
    }

    private Consumer<Shape> addBasePropertiesIf(Properties nameableProperties, ScalarTypes scalars, Predicate<Shape> predicate) {
        return shape -> {
            if (predicate.test((Shape)shape)) {
                this.addBaseProperties(nameableProperties, scalars).accept((Shape)shape);
            }
        };
    }

    private Consumer<Shape> setDefaults() {
        return shape -> shape.getProps().setDefaults();
    }

    private Consumer<Shape> setAllProperties() {
        return shape -> shape.setAllProperties(this.computeAllShapeProperties(shape.getId()));
    }

    private Consumer<Shape> setNameProperty() {
        return shape -> {
            if (shape.getName() != null) {
                return;
            }
            shape.getParents().filter(parent -> parent.getName() != null).findFirst().ifPresent(parent -> shape.setName(parent.getName()));
        };
    }

    private Consumer<Shape> copyLangConfigFromRoot() {
        LangConfig langConfig = this.getContainedIn().getConfig().getLang().orElse(null);
        if (langConfig == null) {
            return shape -> {};
        }
        return shape -> shape.getProps().values().forEach((? super T property) -> property.copyLangConfigFrom(langConfig));
    }

    void traverseParentsFirsts(Consumer<Shape> consumer) {
        List roots = this.values().stream().filter(shape -> shape.getInherits() == null).map(Shape::getId).map(this::get).filter(Objects::nonNull).collect(Collectors.toList());
        for (Shape root : roots) {
            this.traverseParentFirst(root, consumer);
        }
    }

    private void traverseParentFirst(Shape node, Consumer<Shape> consumer) {
        if (node == null || node.isHierarchyInvalid()) {
            return;
        }
        consumer.accept(node);
        List children = this.values().stream().filter(sh -> sh.getInheritsAsList().contains(node.getId())).collect(Collectors.toList());
        for (Shape child : children) {
            this.traverseParentFirst(child, consumer);
        }
    }

    private void traverseChildrenFirsts(Consumer<Shape> consumer) {
        HashSet children = new HashSet(this.values());
        this.values().stream().flatMap(shape -> shape.getInheritsAsList().stream()).filter(Objects::nonNull).forEach((? super T id) -> children.remove(this.get(id)));
        for (Shape child : children) {
            this.traverseChildFirst(child, consumer);
        }
    }

    private void traverseChildFirst(Shape node, Consumer<Shape> consumer) {
        if (node == null || node.isHierarchyInvalid()) {
            return;
        }
        consumer.accept(node);
        node.getParents().forEach((? super T parent) -> this.traverseChildFirst((Shape)parent, consumer));
    }

    private Properties computeAllShapeProperties(String name) {
        Properties allProperties = new Properties(true);
        allProperties.setContainedIn((Shape)this.get(name));
        try {
            List<Shape> hierarchy = this.getHierarchyOnDemand(name);
            for (Shape shape : hierarchy) {
                if (shape == null || shape.isHierarchyInvalid()) continue;
                this.updateCovariance(hierarchy, shape);
                this.clonePropsIntoAllProperties(allProperties, shape);
            }
        }
        catch (InvalidSchemaException invalidSchemaException) {
            // empty catch block
        }
        return allProperties;
    }

    private void updateCovariance(Collection<Shape> hierarchy, Shape shape) {
        if (!shape.isAbstract()) {
            for (PropertyShape ps : shape.getProps().values()) {
                ps.setHasCovariant(hierarchy.stream().anyMatch(parent -> parent != null && !parent.equals(shape) && parent.getProps().containsKey(ps.getName()) && !((PropertyShape)parent.getProps().get(ps.getName())).getRange().equals(ps.getRange())));
            }
        }
    }

    String simplifyTypeName(String name) {
        String vocPfx = null;
        Predicate<String> isScalarType = string -> true;
        if (null != this.schema) {
            vocPfx = this.schema.getSpecialPrefixes().getVocabPrefix().orElse(null);
            if (!this.schema.getTypes().isEmpty()) {
                isScalarType = this.schema.getTypes()::isScalarType;
            }
        }
        return Shapes.simplifyTypeName(vocPfx, name, isScalarType);
    }

    public static String simplifyTypeName(String prefix, String name, Predicate<String> isScalarType) {
        String nameWithoutPrefix;
        if (null == name) {
            return null;
        }
        if (null == prefix) {
            return name;
        }
        if (name.startsWith((String)(prefix = (String)prefix + ":")) && !Shapes.isSystemShapeOrInterface(nameWithoutPrefix = Shapes.stringInternalSuffix(name.replace((CharSequence)prefix, ""))) && isScalarType.negate().test(nameWithoutPrefix)) {
            return nameWithoutPrefix;
        }
        return name;
    }

    static String stringInternalSuffix(String name) {
        for (String internalSuffix : INTERNAL_SUFFIXES) {
            if (!name.endsWith(internalSuffix)) continue;
            return name.substring(0, name.length() - internalSuffix.length());
        }
        return name;
    }

    public Optional<Shape> resolveShape(String shapeName) {
        return Optional.ofNullable((Shape)this.get(this.resolveShapeName(shapeName)));
    }

    public String resolveShapeName(String shapeName) {
        return this.getContainedIn().getPrefixes().nameToShortIri(shapeName);
    }

    private void expandShape(Shape shape, Properties baseProperties, ScalarTypes scalars) {
        shape.expand(null, baseProperties, scalars, this);
        shape.getProps().setDefaults();
        shape.expand(null, baseProperties, scalars, this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Shapes)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public Shape put(String key, Shape value) {
        this.tracker.trackModelEntry(key);
        if (value == null) {
            return super.put(key, new Shape(true));
        }
        return super.put(key, value);
    }

    @Override
    public Shape putIfAbsent(String key, Shape value) {
        if (!this.containsKey(key)) {
            return this.put(key, value);
        }
        return super.putIfAbsent(key, value);
    }

    @Override
    public Shape computeIfAbsent(String key, Function<? super String, ? extends Shape> mappingFunction) {
        if (!this.containsKey(key)) {
            return this.put(key, mappingFunction.apply(key));
        }
        return super.computeIfAbsent(key, mappingFunction);
    }

    public void merge(Shapes objects) {
        this.putAll(objects);
        objects.keySet().forEach(this.tracker::trackModelEntry);
    }

    @Override
    public SomlSchema getContainedIn() {
        return this.schema;
    }

    @Override
    public void startTracking() {
        this.tracker = ModelTracker.enableTracking(this.tracker);
        this.values().forEach(Shape::startTracking);
    }

    @Override
    public void stopTracking() {
        this.tracker = ModelTracker.disableTracking(this.tracker);
        this.values().forEach(TrackedModel::stopTracking);
    }

    @Override
    public void clearTrackedInformation() {
        this.tracker.clear();
        this.values().forEach(TrackedModel::clearTrackedInformation);
    }

    @Override
    public boolean isTracked(String modelId) {
        return this.tracker.isTracked(modelId) || this.tracker.isTracked(this.simplifyTypeName(modelId)) || this.tracker.isTracked(this.addVocPfx(modelId));
    }

    private String addVocPfx(String name) {
        if (null != this.schema) {
            return this.schema.getSpecialPrefixes().getVocabPrefix().map(vocab -> vocab + ":" + name).orElse(name);
        }
        return name;
    }

    @Override
    public String toYaml(YamlPrinter.Configuration configuration) {
        return new YamlPrinter(configuration).addMapValues("objects", this, shape -> shape.isSynthetic() == false && this.isTracked(shape.getId())).asString();
    }

    private void clonePropsIntoAllProperties(Properties allProperties, Shape shape) {
        for (PropertyShape prop : shape.getProps().values()) {
            PropertyShape clone = prop.copy();
            clone.setContainedIn(allProperties);
            allProperties.put(prop.getName(), clone);
        }
    }

    @Override
    public void sanitize(Sanitizable.Context context) {
        Map<String, String> sanitizedObjectIds = SchemaSanitizerUtils.sanitizeMap(this, context.getOperationReport());
        sanitizedObjectIds.forEach(this.tracker::updateKey);
        context.setSanitizedObjectIds(sanitizedObjectIds);
        this.values().stream().forEach((? super T shape) -> Sanitizable.sanitize(context, (Sanitizable)shape));
    }

    public Shapes getUserDefinedShapes() {
        Shapes userDefinedShapes = new Shapes();
        userDefinedShapes.putAll(this);
        RESPONSE_TYPES.forEach(userDefinedShapes::remove);
        AFFECTED_TYPES.forEach(userDefinedShapes::remove);
        userDefinedShapes.remove(HEALTH_CHECK);
        userDefinedShapes.remove(SERVICE);
        userDefinedShapes.entrySet().removeIf(entry -> ((Shape)entry.getValue()).isSynthetic());
        return userDefinedShapes;
    }

    public void simplifyNames() {
        HashSet shapesToReinsert = new HashSet();
        UnaryOperator nameSimplifier = this::simplifyTypeName;
        this.values().forEach((? super T shape) -> {
            this.simplifyInherits(nameSimplifier, (Shape)shape);
            this.simplifyShapeId(shapesToReinsert, nameSimplifier, (Shape)shape);
            this.simplifyPropertyRanges(nameSimplifier, (Shape)shape);
        });
        shapesToReinsert.forEach((? super T oldKey) -> {
            Shape renamedShape = (Shape)this.remove(oldKey);
            String newId = (String)nameSimplifier.apply(renamedShape.getId());
            this.put(newId, renamedShape);
            this.tracker.updateKey((String)oldKey, newId);
        });
    }

    private void simplifyInherits(UnaryOperator<String> nameSimplifier, Shape shape) {
        List updatedNames = shape.getInheritsAsList().stream().map(nameSimplifier).collect(Collectors.toList());
        if (!updatedNames.isEmpty()) {
            shape.setInherits(updatedNames);
        }
    }

    private void simplifyShapeId(Set<String> shapesToReinsert, UnaryOperator<String> nameSimplifier, Shape shape) {
        String oldId = shape.getId();
        String newId = (String)nameSimplifier.apply(oldId);
        if (!shape.getId().equals(newId)) {
            shape.setId(newId);
            shapesToReinsert.add(oldId);
        }
    }

    private void simplifyPropertyRanges(UnaryOperator<String> nameSimplifier, Shape shape) {
        shape.getProps().values().stream().filter(prop -> !prop.isScalarType()).forEach((? super T prop) -> prop.setRange((String)nameSimplifier.apply(prop.getRange())));
    }

    public Set<String> getAllObjectPropertyRanges() {
        return this.values().stream().flatMap(shape -> shape.getAllProperties().values().stream().filter(PropertyShape::isObjectType).map(PropertyShape::getRange)).collect(Collectors.toSet());
    }
}

