/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.ContainedIn;
import com.ontotext.models.ErrorMessages;
import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.ModelTracker;
import com.ontotext.models.Prefixes;
import com.ontotext.models.Properties;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.ScalarTypes;
import com.ontotext.models.Shapes;
import com.ontotext.models.SpecialPrefixes;
import com.ontotext.models.TrackedModel;
import com.ontotext.models.TypeAccessMode;
import com.ontotext.models.sanitizing.Sanitizable;
import com.ontotext.models.sanitizing.SchemaSanitizerUtils;
import com.ontotext.models.search.SearchConfig;
import com.ontotext.models.templates.Template;
import com.ontotext.models.yaml.YamlPrinter;
import com.ontotext.models.yaml.YamlRepresentable;
import com.ontotext.soaas.common.ObjectsUtil;
import com.ontotext.soaas.common.SparqlUtil;
import com.ontotext.soaas.common.StringManipulation;
import com.ontotext.soaas.common.rdf.LiteralValue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class Shape
implements ContainedIn<Shapes>,
TrackedModel,
YamlRepresentable,
Sanitizable {
    public static final String LABEL_KEY = "label";
    public static final String DESCR_KEY = "descr";
    public static final String INHERITS_KEY = "inherits";
    public static final String REGEX_KEY = "regex";
    public static final String REGEX_FLAGS_KEY = "regexFlags";
    public static final String PREFIX_KEY = "prefix";
    public static final String PATTERN_KEY = "pattern";
    public static final String KIND_KEY = "kind";
    public static final String TYPE_KEY = "type";
    public static final String TYPE_PROP_KEY = "typeProp";
    public static final String NAME_KEY = "name";
    public static final String EXTEND_KEY = "extend";
    public static final String CONSTRAINTS_KEY = "constraints";
    public static final String CLOSED_KEY = "closed";
    public static final String SEARCH_KEY = "search";
    public static final String SPARQL_FEDERATION_SERVICE_KEY = "sparqlFederatedService";
    public static final String META_KEY = "meta";
    public static final String ACCESS_KEY = "access";
    public static final String UNION_OF_KEY = "unionOf";
    private String id;
    private String graphqlId;
    private String fullIriId;
    private String shortIriId;
    private String label;
    private String descr;
    private Object inherits;
    private String regex;
    private String regexFlags;
    private String prefix;
    private String kind;
    private Object type;
    private String typeProp;
    private String typePropIri;
    private Template typePropTemplate;
    private Boolean ignoredType;
    private String name;
    private String nameIri;
    private Template nameTemplate;
    private String pattern;
    private List<String> constraints;
    private Boolean closed;
    private Boolean extend;
    private Properties props;
    private Properties allProperties;
    private Boolean synthetic = Boolean.FALSE;
    private TypeAccessMode access;
    private SearchConfig search;
    private String sparqlFederatedService;
    private List<String> unionOf;
    private List<Shape> unionOfShapes;
    private Map<String, Object> meta = Collections.emptyMap();
    private String serviceAddress;
    private Boolean invalidHierarcy;
    private Properties propertiesLookup;
    private Shapes containedIn;
    private ModelTracker tracker = ModelTracker.notTracked();

    public Shape() {
        this.tracker = ModelTracker.tracked();
    }

    public Shape(boolean flag) {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        this.graphqlId = null;
        this.fullIriId = null;
        this.shortIriId = null;
    }

    public String asGraphQl() {
        if (this.graphqlId == null) {
            if (Shapes.isSystemShapeOrInterface(this.getId())) {
                return StringManipulation.toGraphQlModelName((String)this.getId());
            }
            this.graphqlId = StringManipulation.toGraphQlModelName((String)this.getContainedIn().getContainedIn().getPrefixes().toName(this.getId()));
        }
        return this.graphqlId;
    }

    public String asIri() {
        if (this.fullIriId == null) {
            this.fullIriId = this.getContainedIn().getContainedIn().getPrefixes().toIri(this.getId());
        }
        return this.fullIriId;
    }

    public String asShortIri() {
        if (this.shortIriId == null) {
            this.shortIriId = this.getContainedIn().getContainedIn().getPrefixes().toShortIri(this.getId());
        }
        return this.shortIriId;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        this.tracker.trackValue(LABEL_KEY, label);
    }

    public String getDescr() {
        return this.descr;
    }

    public void setDescr(String descr) {
        this.descr = descr;
        this.tracker.trackValue(DESCR_KEY, descr);
    }

    public Object getInherits() {
        return this.inherits;
    }

    public void setInherits(Object inherits) {
        if (inherits instanceof String) {
            inherits = Collections.singletonList(this.simplifyTypeName((String)((Object)inherits)));
        } else if (inherits instanceof Collection) {
            inherits = ((Collection)inherits).isEmpty() ? null : ((Collection)inherits).stream().map(Object::toString).map(this::simplifyTypeName).distinct().collect(Collectors.toList());
        } else if (inherits != null) {
            throw new InvalidSchemaException("inherits could be only string or list of string");
        }
        this.inherits = inherits;
        this.tracker.trackValue(INHERITS_KEY, inherits);
        this.invalidHierarcy = null;
    }

    private String simplifyTypeName(String value) {
        if (this.containedIn == null) {
            return value;
        }
        return this.containedIn.simplifyTypeName(value);
    }

    public List<String> getInheritsAsList() {
        if (this.inherits == null) {
            return Collections.emptyList();
        }
        return (List)this.inherits;
    }

    public Stream<Shape> getSuperTypes() {
        return this.getInheritsAsList().stream().map(this.getContainedIn()::get).filter(Objects::nonNull);
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
        this.tracker.trackValue(REGEX_KEY, regex);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        this.tracker.trackValue(PREFIX_KEY, prefix);
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
        this.tracker.trackValue(KIND_KEY, kind);
    }

    public Object getType() {
        return this.type;
    }

    public List<String> getTypeAsList() {
        if (this.type == null) {
            return Collections.emptyList();
        }
        return (List)this.type;
    }

    public void setType(Object type) {
        if (type instanceof List) {
            this.type = type;
        } else if (type instanceof String) {
            this.type = Collections.singletonList((String)type);
        } else if (null == type) {
            this.type = Collections.emptyList();
        } else {
            throw new IllegalArgumentException(String.format("The type of shape %s is an illegal value: %s", this.id, type));
        }
        this.tracker.trackValue(TYPE_KEY, type != null && this.getTypeAsList().isEmpty() ? null : type);
    }

    public String getTypeProp() {
        return this.typeProp;
    }

    public void setTypeProp(String typeProp) {
        this.typeProp = typeProp;
        if (!this.tracker.isTracked(TYPE_PROP_KEY)) {
            this.ignoredType = "none".equalsIgnoreCase(typeProp);
        }
        this.tracker.trackValue(TYPE_PROP_KEY, typeProp);
    }

    public String getTypePropIri() {
        this.resolveTypePropIri();
        return this.typePropIri;
    }

    public boolean isIgnoredType() {
        return this.ignoredType;
    }

    public boolean isTypePropRdfType() {
        boolean isRdfType = "rdf:type".equals(this.getTypePropIri());
        if (!isRdfType) {
            return false;
        }
        return this.getParents().allMatch(Shape::isTypePropRdfType);
    }

    public Stream<Shape> getParents() {
        if (this.getInherits() == null) {
            return Stream.empty();
        }
        return this.getInheritsAsList().stream().map(parentId -> {
            Shape parent = (Shape)this.getContainedIn().get(parentId);
            if (parent == null) {
                throw new InvalidSchemaException(ErrorMessages.get("undefined.referenced.type", this.getId(), parentId));
            }
            return parent;
        });
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (null != this.props) {
            name = this.props.simplifyName(name);
        }
        this.name = name;
        this.tracker.trackValue(NAME_KEY, name);
    }

    public boolean isNameLiteral() {
        if (this.name == null) {
            return false;
        }
        return this.getProperty(this.name).orElseThrow(() -> new InvalidSchemaException("name points to a non-existing prop: " + this.name)).isLiteral();
    }

    public Boolean isExtend() {
        return this.extend;
    }

    public void setExtend(Boolean extend) {
        this.extend = extend;
        this.tracker.trackValue(EXTEND_KEY, extend);
    }

    public String getSparqlFederatedService() {
        return this.sparqlFederatedService;
    }

    public void setSparqlFederatedService(String sparqlFederatedService) {
        this.sparqlFederatedService = sparqlFederatedService;
        this.tracker.trackValue(SPARQL_FEDERATION_SERVICE_KEY, sparqlFederatedService);
    }

    public String getServiceAddress() {
        return this.serviceAddress;
    }

    public Optional<String> resolveCommonServiceAddress() {
        Set distinctServices;
        if (this.serviceAddress != null) {
            return Optional.of(this.serviceAddress);
        }
        if (this.isAbstract() && this.containedIn != null && !(distinctServices = this.getConcreteSubTypes().stream().map(subType -> Objects.toString(subType.getServiceAddress(), "NO_SERVICE")).collect(Collectors.toSet())).contains("NO_SERVICE") && distinctServices.size() == 1) {
            return Optional.of((String)distinctServices.iterator().next());
        }
        return Optional.empty();
    }

    public void setServiceAddress(String serviceAddress) {
        this.serviceAddress = serviceAddress;
    }

    public Map<String, Object> getMeta() {
        return this.meta;
    }

    public void setMeta(Map<String, Object> meta) {
        this.meta = meta;
    }

    public String getNameIri() {
        if (NAME_KEY.equals(this.name) && this.nameIri == null) {
            this.nameIri = this.getContainedIn().getContainedIn().getPrefixes().toShortIri(this.name);
        } else {
            this.resolveNameIri();
        }
        return this.nameIri;
    }

    public void setNameIri(String nameIri) {
        this.nameIri = nameIri;
    }

    public Properties getProps() {
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public Shape addProperty(PropertyShape propertyShape) {
        if (this.props == null) {
            this.props = new Properties(true);
            this.props.setContainedIn(this);
        }
        this.props.put(propertyShape.getName(), propertyShape);
        propertyShape.setContainedIn(this.props);
        if (this.allProperties != null) {
            this.getAllProperties().put(propertyShape.getName(), propertyShape);
        }
        if (this.propertiesLookup == null) {
            this.propertiesLookup = new Properties();
        }
        this.fillInPropertyLookup(propertyShape);
        return this;
    }

    public Properties getAllProperties() {
        return this.allProperties;
    }

    public Stream<PropertyShape> getOwnSearchableProperties() {
        List parents = this.getParents().collect(Collectors.toList());
        return this.getAllProperties().entrySet().stream().filter(entry -> parents.isEmpty() || parents.stream().noneMatch(parent -> parent.getProperty((String)entry.getKey()).isPresent())).map(Map.Entry::getValue).filter(PropertyShape::isSearchable).filter(PropertyShape::isTripleSelection);
    }

    public void setAllProperties(Properties allProperties) {
        this.allProperties = allProperties;
        this.propertiesLookup = new Properties();
        this.propertiesLookup.putAll(allProperties);
        for (PropertyShape ps : allProperties.values()) {
            this.fillInPropertyLookup(ps);
        }
        for (String key : this.props.keySet()) {
            if (!allProperties.containsKey(key)) continue;
            this.props.put(key, (PropertyShape)allProperties.get(key));
        }
    }

    private void fillInPropertyLookup(PropertyShape ps) {
        this.propertiesLookup.put(ps.getName(), ps);
        try {
            String rdfProperty = ps.getRdfProperty();
            this.propertiesLookup.put(rdfProperty, ps);
            if (this.getContainedIn() != null && this.getContainedIn().getContainedIn() != null) {
                Prefixes prefixes = this.getContainedIn().getContainedIn().getPrefixes();
                if (!SparqlUtil.isSparqlTemplate((String)rdfProperty)) {
                    this.propertiesLookup.put(prefixes.toIri(rdfProperty), ps);
                }
                String gqlName = ps.asGraphQl();
                this.propertiesLookup.put(gqlName, ps);
                this.propertiesLookup.put(prefixes.nameToShortIri(gqlName), ps);
                String modelKey = prefixes.toModelShortIri(gqlName);
                if (!Properties.PROPS_THAT_USE_VOCAB_PREFIX.contains(modelKey)) {
                    this.propertiesLookup.put(modelKey, ps);
                }
            }
        }
        catch (InvalidSchemaException invalidSchemaException) {
            // empty catch block
        }
    }

    public void setContainedIn(Shapes shapes) {
        this.containedIn = shapes;
        this.invalidHierarcy = null;
    }

    public Optional<PropertyShape> getProperty(String propertyName) {
        PropertyShape value = (PropertyShape)this.propertiesLookup.get(propertyName);
        if (value == null && !"Literal".equals(this.getId()) && (LiteralValue.PROPERTIES.contains(propertyName) || NAME_KEY.equals(propertyName))) {
            SpecialPrefixes specialPrefixes = this.getContainedIn().getContainedIn().getSpecialPrefixes();
            value = (PropertyShape)this.propertiesLookup.get(specialPrefixes.getVocabPrefix().map(vocab -> vocab + ":" + propertyName).orElse(propertyName));
        }
        return Optional.ofNullable(value);
    }

    public PropertyShape getPropertyOrFail(String propertyName) throws InvalidSchemaException {
        PropertyShape propertyShape = (PropertyShape)this.propertiesLookup.get(propertyName);
        if (propertyShape == null) {
            throw InvalidSchemaException.propertyNotFound(propertyName, this.getId());
        }
        return propertyShape;
    }

    public Map<String, PropertyShape> getPropertyRepresentationInSubTypes(String name) {
        if (!this.isAbstract()) {
            return Collections.emptyMap();
        }
        Optional<PropertyShape> localProperty = this.getProperty(name);
        if (!localProperty.isPresent()) {
            return Collections.emptyMap();
        }
        Collection<Shape> subTypes = this.getSubTypes();
        PropertyShape property = localProperty.get();
        return subTypes.stream().filter(subType -> Shape.isPropertyOverridden(subType, property)).collect(Collectors.toMap(Shape::getId, subType -> (PropertyShape)subType.getProps().get(property.getName())));
    }

    public static boolean isPropertyOverridden(Shape shape, PropertyShape property) {
        PropertyShape localProperty = (PropertyShape)shape.getProps().get(property.getName());
        if (localProperty == null) {
            return false;
        }
        return localProperty.isTracked("rdfProp") && !Objects.equals(localProperty.getAsAbsoluteRdfProp(), property.getAsAbsoluteRdfProp());
    }

    public boolean isAbstract() {
        return "abstract".equals(this.kind);
    }

    public Collection<Shape> getConcreteSubTypes() {
        return this.isUnion() ? this.getUnionOfShapes() : this.containedIn.getConcreteSubTypes(this.getId());
    }

    public Collection<Shape> getSubTypes() {
        return this.containedIn.getSubTypes(this.getId());
    }

    public boolean isParentOf(String type) {
        return this.isAbstract() && this.getSubTypes().stream().anyMatch(subType -> subType.getId().equals(type));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Shape)) {
            return false;
        }
        Shape shape = (Shape)obj;
        return Objects.equals(this.getId(), shape.getId()) && Objects.equals(this.getLabel(), shape.getLabel()) && Objects.equals(this.getDescr(), shape.getDescr()) && Objects.equals(this.getInherits(), shape.getInherits()) && Objects.equals(this.getRegex(), shape.getRegex()) && Objects.equals(this.getRegexFlags(), shape.getRegexFlags()) && Objects.equals(this.getPrefix(), shape.getPrefix()) && Objects.equals(this.getKind(), shape.getKind()) && Objects.equals(this.getType(), shape.getType()) && Objects.equals(this.getTypeProp(), shape.getTypeProp()) && Objects.equals(this.getName(), shape.getName()) && Objects.equals(this.getPattern(), shape.getPattern()) && Objects.equals(this.isExtend(), shape.isExtend()) && Objects.equals(this.getProps(), shape.getProps()) && Objects.equals(this.getConstraints(), shape.getConstraints()) && Objects.equals(this.isClosed(), shape.isClosed()) && Objects.equals(this.getSearch(), shape.getSearch()) && Objects.equals(this.getSparqlFederatedService(), shape.getSparqlFederatedService()) && Objects.equals(this.getMeta(), shape.getMeta()) && Objects.equals(this.getAccess(), shape.getAccess()) && Objects.equals(this.getUnionOfAsList(), shape.getUnionOfAsList());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getLabel(), this.getDescr(), this.getInherits(), this.getRegex(), this.getRegexFlags(), this.getPrefix(), this.getKind(), this.getType(), this.getTypeProp(), this.getName(), this.getPattern(), this.isExtend(), this.getProps(), this.getConstraints(), this.isClosed(), this.getSearch(), this.getSparqlFederatedService(), this.getMeta(), this.getAccess(), this.getUnionOfAsList());
    }

    public String toString() {
        return "Shape [id=" + this.id + ", label=" + this.label + ", descr=" + this.descr + ", inherits=" + this.inherits + ", regex=" + this.regex + ", regexFlags=" + this.regexFlags + ", prefix=" + this.prefix + ", kind=" + this.kind + ", unionOf=" + this.unionOf + ", pattern=" + this.pattern + ", constraints=" + this.constraints + ", type=" + this.type + ", typeProp=" + this.typeProp + ", typePropIri=" + this.typePropIri + ", name=" + this.name + ", nameIri=" + this.nameIri + ", extend=" + this.extend + ", closed=" + this.closed + ", search=" + this.search + ", sparqlFederatedService=" + this.sparqlFederatedService + ", meta=" + this.meta + ", access=" + (Object)((Object)this.access) + ", props=" + this.props + ", allProperties=" + this.allProperties + "]";
    }

    @Override
    public String toYaml(YamlPrinter.Configuration configuration) {
        boolean shapeIdPrintLevel = true;
        int characteristicsPrintLevel = 3;
        return new YamlPrinter(configuration).addField(this.id, 1).addString(LABEL_KEY, this.label, 3, this.tracker::isTracked).addString(NAME_KEY, this.name, 3, this.tracker::isTracked).addString(INHERITS_KEY, this.getInheritsInYaml(), 3, this.tracker::isTracked).addString(UNION_OF_KEY, this.getUnionOfAsList(), 3, this.tracker::isTracked).addString(REGEX_KEY, this.regex, 3, this.tracker::isTracked).addString(REGEX_FLAGS_KEY, this.regexFlags, 3, this.tracker::isTracked).addString(PREFIX_KEY, this.prefix, 3, this.tracker::isTracked).addString(PATTERN_KEY, this.pattern, 3, this.tracker::isTracked).addString(KIND_KEY, this.kind, 3, this.tracker::isTracked).addArray(TYPE_KEY, this.getTypeAsList(), 3, this.tracker::isTracked).addString(TYPE_PROP_KEY, this.isIgnoredType() ? "none" : this.typeProp, 3, this.tracker::isTracked).addString(DESCR_KEY, this.descr, 3, this.tracker::isTracked).addString(EXTEND_KEY, this.extend, 3, this.tracker::isTracked).addString(CONSTRAINTS_KEY, this.constraints, 3, this.tracker::isTracked).addString(CLOSED_KEY, this.closed, 3, this.tracker::isTracked).addString(SEARCH_KEY, this.search, 3, this.tracker::isTracked).addString(META_KEY, this.meta, 3, this.tracker::isTracked).addString(ACCESS_KEY, (Object)this.access, 3, key -> this.access != TypeAccessMode.DEFAULT && this.tracker.isTracked((String)key)).addString(SPARQL_FEDERATION_SERVICE_KEY, this.sparqlFederatedService, 3, this.tracker::isTracked).addField("props", 3).addWithIndent(2, this.printProps()).asString();
    }

    private Object getInheritsInYaml() {
        if (this.inherits == null) {
            return null;
        }
        if (this.inherits instanceof String) {
            return this.inherits;
        }
        if (this.inherits instanceof Collection) {
            if (((Collection)this.inherits).isEmpty()) {
                return null;
            }
            if (((Collection)this.inherits).size() == 1) {
                return ((Collection)this.inherits).iterator().next();
            }
        }
        return this.inherits;
    }

    private Consumer<YamlPrinter> printProps() {
        return printer -> printer.addMapValues(this.props, prop -> this.props.isTracked(prop.getName()));
    }

    void expand(Shape parentShape, Properties properties, ScalarTypes scalars, Shapes shapes) {
        this.setContainedIn(shapes);
        if (parentShape != null) {
            this.setName((String)ObjectsUtil.getOrDefault((Object)this.getName(), (Object)parentShape.getName()));
            this.setPattern((String)ObjectsUtil.getOrDefault((Object)this.getPattern(), (Object)parentShape.getPattern()));
            this.mergeMeta(parentShape);
        }
        if (this.unionOf != null && !this.unionOf.isEmpty()) {
            this.setKind((String)ObjectsUtil.getOrDefault((Object)StringUtils.trimToNull((String)this.getKind()), (Object)"union"));
        }
        if (this.props == null) {
            this.props = new Properties(true);
        }
        this.props.fillInContainedIn();
        this.props.expand(properties, scalars, this, this.containedIn.getContainedIn().getSpecialPrefixes().getVocabPrefix().orElse(null));
        if (parentShape != null) {
            this.expandParentProperties(parentShape, scalars);
            if (!Shapes.TYPES_THAT_NOT_INHERIT_OBJECT.contains(parentShape.getId())) {
                Shape nameable;
                Shape object = (Shape)this.containedIn.get("Object");
                if (object != null) {
                    this.props.expand(object.getProps(), scalars, this, this.containedIn.getContainedIn().getSpecialPrefixes().getVocabPrefix().orElse(null));
                }
                if ((nameable = (Shape)this.containedIn.get("Nameable")) != null) {
                    this.props.expand(nameable.getProps(), scalars, this, this.containedIn.getContainedIn().getSpecialPrefixes().getVocabPrefix().orElse(null));
                }
            }
        }
        this.extend = (Boolean)ObjectsUtil.getOrDefault((Object)this.extend, (Object)Boolean.FALSE);
        this.synthetic = (Boolean)ObjectsUtil.getOrDefault((Object)this.synthetic, (Object)Boolean.FALSE);
    }

    private void expandParentProperties(Shape parent, ScalarTypes scalars) {
        parent.forEachParentShape().forEach(distParentShape -> this.props.expand(distParentShape.getProps(), scalars, this, this.containedIn.getContainedIn().getSpecialPrefixes().getVocabPrefix().orElse(null)));
    }

    public Stream<String> forEachParent() {
        return this.forEachParent(new HashSet<String>());
    }

    private Stream<String> forEachParent(Set<String> visited) {
        return Stream.concat(this.getInheritsAsList().stream(), this.getInheritsAsList().stream().filter(visited::add).map(this.getContainedIn()::get).filter(Objects::nonNull).flatMap(Shape::forEachParent)).distinct();
    }

    public void forEachParent(Consumer<Shape> parentConsumer) {
        this.forEachParentShape().forEach(parentConsumer);
    }

    public Stream<Shape> forEachParentShape() {
        return this.forEachParentShape(new HashSet<String>());
    }

    private Stream<Shape> forEachParentShape(Set<String> visited) {
        return Stream.concat(this.getParents(), this.getParents().filter(parent -> visited.add(parent.getId())).flatMap(parent -> parent.forEachParentShape(visited)));
    }

    private void mergeMeta(Shape parentShape) {
        if (!parentShape.getMeta().isEmpty()) {
            LinkedHashMap<String, Object> combined = new LinkedHashMap<String, Object>();
            combined.putAll(parentShape.getMeta());
            combined.putAll(this.getMeta());
            this.setMeta(combined);
        }
    }

    @Override
    public Shapes getContainedIn() {
        return this.containedIn;
    }

    public boolean isSubClassOf(String parent) {
        return this.getContainedIn().getHierarchy(this.getId()).stream().map(Shape::getId).anyMatch(parent::equals);
    }

    public boolean isHierarchyInvalid() {
        if (this.invalidHierarcy == null) {
            this.invalidHierarcy = this.isHierarchyInvalid(this.getContainedIn());
        }
        return this.invalidHierarcy;
    }

    private boolean isHierarchyInvalid(Shapes containedIn) {
        HashSet<String> visited = new HashSet<String>();
        HashSet<String> visiting = new HashSet<String>();
        return this.hasLoopDfs(this.getId(), containedIn, visited, visiting);
    }

    private boolean hasLoopDfs(String type, Shapes containedIn, Set<String> visited, Set<String> visiting) {
        visited.add(type);
        visiting.add(type);
        Shape currentType = (Shape)containedIn.get(type);
        if (currentType == null) {
            return true;
        }
        for (String parent : currentType.getInheritsAsList()) {
            if (!(!visited.contains(parent) ? this.hasLoopDfs(parent, containedIn, visited, visiting) : visiting.contains(parent))) continue;
            return true;
        }
        visiting.remove(type);
        return false;
    }

    @Override
    public void startTracking() {
        this.tracker = ModelTracker.enableTracking(this.tracker);
        if (this.props != null) {
            this.props.startTracking();
        }
        if (this.search != null) {
            this.search.startTracking();
        }
    }

    @Override
    public void stopTracking() {
        this.tracker = ModelTracker.disableTracking(this.tracker);
        if (this.props != null) {
            this.props.stopTracking();
        }
        if (this.search != null) {
            this.search.stopTracking();
        }
    }

    @Override
    public void clearTrackedInformation() {
        this.tracker.clear();
        if (this.props != null) {
            this.props.clearTrackedInformation();
        }
        if (this.search != null) {
            this.search.clearTrackedInformation();
        }
    }

    @Override
    public boolean isTracked(String modelId) {
        return this.tracker.isTracked(modelId);
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.tracker.trackValue(PATTERN_KEY, pattern);
    }

    private void resolveNameIri() {
        this.initRdfPropertyForProperty(this.nameIri, this::setNameIri, this.name);
    }

    private void resolveTypePropIri() {
        this.initRdfPropertyForProperty(this.typePropIri, this::setTypePropIri, this.typeProp);
    }

    private void initRdfPropertyForProperty(String currentValue, Consumer<String> setter, String propName) {
        if (currentValue != null || propName == null) {
            return;
        }
        Optional<PropertyShape> propShape = this.getProperty(propName);
        String value = propShape.isPresent() ? propShape.get().getRdfProperty() : (!SparqlUtil.isSparqlTemplate((String)propName) ? this.getContainedIn().getContainedIn().getPrefixes().toShortIri(propName) : propName);
        setter.accept(value);
    }

    public boolean isMutable() {
        if (Boolean.TRUE.equals(this.isSynthetic()) || SparqlUtil.isSparqlTemplate((String)this.getTypePropIri()) || this.getSparqlFederatedService() != null) {
            return false;
        }
        if (this.isUnion() || this.getInherits() != null) {
            return (this.isUnion() ? this.getUnionOfShapes().stream() : this.getParents()).anyMatch(parent -> {
                if (parent.isIgnoredType()) {
                    if (parent.getInherits() == null) {
                        return !parent.isReadOnly();
                    }
                    return parent.getParents().anyMatch(Shape::isMutable);
                }
                return parent.isMutable();
            });
        }
        return !this.isReadOnly();
    }

    public boolean isMutableThroughOtherTypes() {
        return this.getAccessMode().canBeNested();
    }

    public boolean isReadOnly() {
        return !this.getAccessMode().canWrite() && !this.getAccessMode().canDelete();
    }

    public boolean isApplicableForSubscription() {
        return !this.isIgnoredType() && Boolean.FALSE.equals(this.isSynthetic()) && !SparqlUtil.isSparqlTemplate((String)this.getTypePropIri()) && this.getSparqlFederatedService() == null && this.getAccessMode().canRead() && !this.isUnion();
    }

    public Boolean isSynthetic() {
        return this.synthetic;
    }

    public void setSynthetic(Boolean synthetic) {
        this.synthetic = (Boolean)ObjectsUtil.getOrDefault((Object)synthetic, (Object)Boolean.FALSE);
    }

    public boolean isSystem() {
        return this.isSynthetic() != false || Shapes.SYSTEM_SHAPES.contains(this.getId());
    }

    @Override
    public void sanitize(Sanitizable.Context context) {
        Map<String, String> objectIds = context.getSanitizedObjectIds();
        String sanitizedId = objectIds.get(this.getId());
        if (this.getId().equals(this.getLabel())) {
            ObjectsUtil.setIfNotNull(() -> sanitizedId, this::setLabel);
        }
        ObjectsUtil.setIfNotNull(() -> sanitizedId, this::setId);
        Sanitizable.sanitize(context, (Sanitizable)this.props);
        this.sanitizeTypeIfNotNull(context);
        this.sanitizeUnionOfIfNotNull(context);
        Map<String, String> namespaces = context.getSanitizedPrefixNamespaces();
        ObjectsUtil.setIfNotNull(() -> SchemaSanitizerUtils.resolveIfPrefixed(this.getTypeProp(), namespaces, Collections.emptyMap()), this::setTypeProp);
        Map<String, String> propertiesNames = context.getOrCreateSanitizedPropertiesNames();
        ObjectsUtil.setIfNotNull(() -> (String)propertiesNames.get(this.getName()), this::setName);
        List inheritsList = this.getInheritsAsList().stream().map(objectIds::get).filter(Objects::nonNull).collect(Collectors.toList());
        if (!inheritsList.isEmpty()) {
            this.setInherits(inheritsList);
        }
    }

    private void sanitizeUnionOfIfNotNull(Sanitizable.Context context) {
        if (this.isUnion()) {
            Map<String, String> objectIds = context.getSanitizedObjectIds();
            this.setUnionOf(this.getUnionOfAsList().stream().map(unionType -> objectIds.getOrDefault(unionType, (String)unionType)).collect(Collectors.toList()));
        }
    }

    private void sanitizeTypeIfNotNull(Sanitizable.Context context) {
        if (this.getType() != null) {
            if (this.type instanceof Collection && ((Collection)this.type).stream().anyMatch(item -> !(item instanceof String))) {
                throw new InvalidSchemaException(String.format("Type '%s' has invalid type value: '%s'", this.getId(), this.type));
            }
            Map<String, String> namespaces = context.getSanitizedPrefixNamespaces();
            List sanitizedTypes = this.getTypeAsList().stream().map(typeValue -> SchemaSanitizerUtils.resolveIfPrefixed(typeValue, namespaces, Collections.emptyMap())).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
            this.setType(sanitizedTypes);
        }
    }

    public List<String> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(List<String> constraints) {
        this.constraints = constraints;
        this.tracker.trackValue(CONSTRAINTS_KEY, constraints);
    }

    public String getRegexFlags() {
        return this.regexFlags;
    }

    public void setRegexFlags(String regexFlags) {
        this.regexFlags = regexFlags;
        this.tracker.trackValue(REGEX_FLAGS_KEY, regexFlags);
    }

    private Boolean isClosed() {
        return this.closed;
    }

    public void setClosed(Boolean closed) {
        this.closed = closed;
        this.tracker.trackValue(CLOSED_KEY, closed);
    }

    public SearchConfig getSearch() {
        return this.search;
    }

    public SearchConfig getSearchSafe() {
        return this.search != null ? this.search : SearchConfig.DEFAULT;
    }

    public void setSearch(SearchConfig search) {
        this.search = search;
        this.tracker.trackValue(SEARCH_KEY, search);
    }

    public boolean isSearchable() {
        return this.search != null && this.search.isSearchable();
    }

    public Stream<Shape> getNestedSearchShapes() {
        return this.getContainedIn().getParentToChildMapping().getOrDefault(this.getId(), Collections.emptyList()).stream().flatMap(this.getNestedShapes());
    }

    private Function<Shape, Stream<Shape>> getNestedShapes() {
        return shape -> {
            if (Boolean.FALSE.equals(shape.getSearchSafe().isNested())) {
                return Stream.empty();
            }
            if (!shape.isAbstract()) {
                return Stream.of(shape);
            }
            return Stream.concat(Stream.of(shape), shape.getNestedSearchShapes());
        };
    }

    public boolean hasSearchableProperties() {
        return this.getAllProperties().values().stream().anyMatch(PropertyShape::isSearchable);
    }

    public void setTypePropIri(String typeIriProp) {
        this.typePropIri = typeIriProp;
    }

    public Template getTypePropTemplate() {
        return this.typePropTemplate;
    }

    public void setTypePropTemplate(Template typePropTemplate) {
        this.typePropTemplate = typePropTemplate;
    }

    public Template getNameTemplate() {
        return this.nameTemplate;
    }

    public void setNameTemplate(Template nameTemplate) {
        this.nameTemplate = nameTemplate;
    }

    public Object getAccess() {
        return this.access;
    }

    public void setAccess(Object access) {
        if (access == null) {
            this.access = TypeAccessMode.DEFAULT;
        } else if (access instanceof String) {
            this.access = TypeAccessMode.parse(access.toString());
        } else if (access instanceof TypeAccessMode) {
            this.access = (TypeAccessMode)((Object)access);
        }
        this.tracker.trackValue(ACCESS_KEY, access);
    }

    public TypeAccessMode getAccessMode() {
        return this.access;
    }

    public boolean isUnion() {
        return this.unionOf != null && !this.unionOf.isEmpty() || "union".equals(this.getKind());
    }

    @NotNull
    public List<String> getUnionOfAsList() {
        if (this.unionOf == null) {
            return List.of();
        }
        return this.unionOf;
    }

    public Object getUnionOf() {
        return this.unionOf;
    }

    public void setUnionOf(Object unionOf) {
        if (unionOf instanceof String) {
            unionOf = List.of(unionOf);
        } else if (unionOf instanceof Collection) {
            unionOf = ((Collection)unionOf).isEmpty() ? null : ((Collection)unionOf).stream().map(Object::toString).collect(Collectors.toList());
        } else if (unionOf != null) {
            throw new InvalidSchemaException("unionOf could be only string or list of string");
        }
        this.unionOf = unionOf;
        this.tracker.trackValue(UNION_OF_KEY, unionOf);
        this.unionOfShapes = null;
    }

    public List<Shape> getUnionOfShapes() {
        if (this.unionOfShapes == null) {
            if (this.isUnion()) {
                HashSet<String> visited = new HashSet<String>();
                visited.add(this.getId());
                this.unionOfShapes = this.getUnionOfAsList().stream().flatMap(subType -> this.expandUnionMember((String)subType, (Set<String>)visited)).collect(Collectors.toList());
            } else {
                this.unionOfShapes = List.of();
            }
        }
        return this.unionOfShapes;
    }

    private Stream<Shape> expandUnionMember(String subType, Set<String> visited) {
        if (!visited.add(subType)) {
            return Stream.empty();
        }
        Shape shape = this.getContainedIn().resolveShape(subType).orElse(null);
        if (shape == null || shape.isHierarchyInvalid()) {
            return Stream.empty();
        }
        if (shape.isUnion()) {
            return shape.getUnionOfAsList().stream().flatMap(member -> this.expandUnionMember((String)member, visited));
        }
        if (shape.isAbstract() || shape.isIgnoredType()) {
            return shape.getConcreteSubTypes().stream().filter(Predicate.not(Shape::isSystem)).flatMap(sub -> this.expandUnionMember(sub.getId(), visited));
        }
        return Stream.of(shape);
    }
}

