/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.ShaclProperty;
import com.ontotext.models.ShaclSchema;
import com.ontotext.models.ShaclType;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.shacl.And;
import com.ontotext.models.shacl.ConstraintContext;
import com.ontotext.models.shacl.HasValue;
import com.ontotext.models.shacl.HasValueIn;
import com.ontotext.models.shacl.NodeChain;
import com.ontotext.models.shacl.Or;
import com.ontotext.models.shacl.Path;
import com.ontotext.models.shacl.Pattern;
import com.ontotext.models.shacl.PatternFlags;
import com.ontotext.models.shacl.Property;
import com.ontotext.models.shacl.ShaclConstraint;
import com.ontotext.models.shacl.ShaclContainerNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class ShaclTargetNode {
    private final Shape targetShape;
    private final ShaclSchema containedIn;
    private final ShaclType type;
    private ShaclContainerNode shapeTypes;
    private List<ShaclProperty> properties = new ArrayList<ShaclProperty>();

    public ShaclTargetNode(Shape targetShape, ShaclType type, ShaclSchema containedIn) {
        this.targetShape = targetShape;
        this.type = type;
        this.containedIn = containedIn;
    }

    public ShaclContainerNode getShapeTypes() {
        return this.shapeTypes;
    }

    public void setShapeTypes(ShaclContainerNode shapeTypes) {
        this.shapeTypes = shapeTypes;
    }

    public void setShapeTypes(List<Shape> parentClasses, Collection<Shape> subClasses) {
        LinkedList<Shape> shapeList = new LinkedList<Shape>(parentClasses);
        shapeList.removeIf(shape -> Shapes.SYSTEM_SHAPES.contains(shape.getId()));
        shapeList.removeIf(shape -> !shape.getId().equals(this.targetShape.getId()) && shape.getTypeProp().equals(this.targetShape.getTypeProp()));
        shapeList.removeIf(shape -> shape.getId().equals(this.targetShape.getId()) && subClasses.stream().anyMatch(subClass -> subClass.getTypeProp().equals(this.targetShape.getTypeProp())));
        if (shapeList.size() == 1 && subClasses.isEmpty()) {
            Property prop = new Property();
            this.shapeTypes = this.buildSingleObjectTypeChain((Shape)shapeList.get(0), prop);
        } else {
            And conjunction = new And();
            Or disjunction = new Or();
            shapeList.forEach(shape -> this.buildSingleObjectTypeChain((Shape)shape, conjunction));
            if (!subClasses.isEmpty()) {
                subClasses.forEach(shape -> this.buildSingleObjectTypeChain((Shape)shape, disjunction));
                if (!conjunction.getSubNodes().isEmpty()) {
                    conjunction.appendToNodes(disjunction);
                    this.shapeTypes = conjunction;
                } else {
                    this.shapeTypes = disjunction;
                }
            } else {
                this.shapeTypes = conjunction;
            }
        }
    }

    private ShaclContainerNode buildSingleObjectTypeChain(Shape targetShape, ShaclContainerNode container) {
        NodeChain subContainer = new NodeChain();
        Path path = new Path(targetShape.getTypeProp());
        subContainer.appendToNodes(path);
        List<String> targetTypes = targetShape.getTypeAsList();
        if (targetTypes.isEmpty()) {
            HasValue hasValue = new HasValue(this.containedIn.getPrefixes().toShortIri(targetShape.getId()));
            subContainer.appendToNodes(hasValue);
        } else if (targetTypes.size() == 1) {
            HasValue hasValue = new HasValue(this.toIri(targetTypes.get(0)));
            subContainer.appendToNodes(hasValue);
        } else {
            ConstraintContext cc = new ConstraintContext(false, targetTypes.stream().map(this::toIri).collect(Collectors.toList()));
            HasValueIn hasValueIn = new HasValueIn(cc);
            subContainer.appendToNodes(hasValueIn);
        }
        container.appendToNodes(subContainer);
        return container;
    }

    public List<ShaclProperty> getProperties() {
        return this.properties;
    }

    public ShaclProperty getProperty(String name) {
        String propId = "name".equals(name) ? this.targetShape.getName() : name;
        return this.properties.stream().filter(shaclProp -> shaclProp.getTargetProp().getName().equals(propId)).findFirst().orElseThrow(this.propertyNotFound(name, ""));
    }

    public ShaclProperty getProperty(String name, String constraintName) {
        String propId = "name".equals(name) ? this.targetShape.getName() : name;
        String modelShortIri = this.containedIn.getPrefixes().toModelShortIri(name);
        return this.properties.stream().filter(shaclProp -> (shaclProp.getTargetProp().getName().equals(propId) || shaclProp.getTargetProp().getRdfProperty().equals(modelShortIri) || shaclProp.getTargetProp().getName().equals(modelShortIri)) && shaclProp.getConstraints().stream().anyMatch(constraint -> constraintName.equals(constraint.getName()))).findFirst().orElseThrow(this.propertyNotFound(name, constraintName));
    }

    private Supplier<IllegalArgumentException> propertyNotFound(String name, String constraintName) {
        return () -> new IllegalArgumentException(String.format("Unable to find property '%s.%s' in SHACL %s", this.targetShape.getId(), name, constraintName));
    }

    public void setProperties(List<ShaclProperty> properties) {
        this.properties = properties;
    }

    public Shape getTargetShape() {
        return this.targetShape;
    }

    public ShaclSchema getContainedIn() {
        return this.containedIn;
    }

    public String getTypeName() {
        return this.type.name();
    }

    public ShaclType getType() {
        return this.type;
    }

    public void addPropertyShape(ShaclProperty shaclProperty) {
        this.properties.add(shaclProperty);
    }

    @Nullable
    public Pattern getPattern() {
        if (null != this.targetShape.getRegex()) {
            return new Pattern(ShaclConstraint.toTurtleString(this.targetShape.getRegex()));
        }
        return null;
    }

    @Nullable
    public PatternFlags getPatternFlags() {
        if (null != this.targetShape.getRegex() && null != this.targetShape.getRegexFlags()) {
            return new PatternFlags(ShaclConstraint.toTurtleString(this.targetShape.getRegexFlags()));
        }
        return null;
    }

    String toTurtle() {
        StringBuilder builder = new StringBuilder();
        this.printNameAndType(builder);
        this.printTypeDiscriminator(builder);
        this.printPattern(builder);
        this.printProperties(builder);
        builder.append("\n");
        return builder.toString();
    }

    private void printNameAndType(StringBuilder builder) {
        Object shapeName = this.containedIn.getPrefixes().nameToShortIri(this.targetShape.getId());
        if (this.targetShape.isAbstract() || this.targetShape.isUnion()) {
            shapeName = "_" + (String)shapeName;
        }
        builder.append(this.containedIn.getSpecialPrefixes().getShapePrefix().orElse(this.containedIn.getSpecialPrefixes().getVocabPrefix().orElse(""))).append(":").append((String)shapeName).append("\n");
        builder.append("\ta ").append(this.type.getName()).append(" ;\n");
    }

    private void printTypeDiscriminator(StringBuilder builder) {
        if (null != this.shapeTypes) {
            builder.append("\trsx:targetShape [ ");
            if (this.shapeTypes instanceof Property) {
                builder.append("a sh:Shape ; ");
            } else {
                builder.append("a sh:NodeShape ; ");
            }
            builder.append(this.shapeTypes.toTurtle()).append(" ];\n");
            if (null == this.getPattern() && this.properties.isEmpty()) {
                builder.append(".\n");
            } else {
                builder.append(";\n");
            }
        } else {
            throw new InvalidSchemaException("The SHACL for shape " + this.targetShape.getId() + " must have a type!");
        }
    }

    private void printPattern(StringBuilder builder) {
        if (null != this.getPattern()) {
            builder.append("\t").append(this.getPattern().toTurtle()).append("\n");
            if (null != this.getPatternFlags()) {
                builder.append("\t").append(this.getPatternFlags().toTurtle()).append("\n");
            }
        }
    }

    private void printProperties(StringBuilder builder) {
        Iterator<ShaclProperty> it = this.properties.iterator();
        while (it.hasNext()) {
            ShaclProperty property = it.next();
            builder.append(property.toTurtle());
            if (it.hasNext()) {
                builder.append(" ;\n");
                continue;
            }
            builder.append(" .\n");
        }
        if (this.properties.isEmpty() && null != this.getPattern()) {
            builder.append(" .\n");
        }
    }

    private String toIri(String value) {
        return "<" + this.containedIn.getPrefixes().toIri(value) + ">";
    }
}

