/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.Configs;
import com.ontotext.models.LangConfig;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class SchemaLangConfig
extends LangConfig {
    public static final String DEFAULT_NAME_FETCH = "defaultNameFetch";
    public static final String APPEND_DEFAULT_NAME_FETCH = "appendDefaultNameFetch";
    private String defaultNameFetch;
    private String appendDefaultNameFetch;

    public SchemaLangConfig() {
    }

    SchemaLangConfig(LangConfig copyFrom) {
        super(copyFrom);
        if (copyFrom instanceof SchemaLangConfig) {
            this.defaultNameFetch = ((SchemaLangConfig)copyFrom).defaultNameFetch;
            this.appendDefaultNameFetch = ((SchemaLangConfig)copyFrom).appendDefaultNameFetch;
        }
    }

    public SchemaLangConfig(String fetch) {
        super(fetch);
    }

    SchemaLangConfig(Map<String, Object> map) {
        super(map);
        if (map.isEmpty()) {
            this.setDefaultNameFetch(Objects.toString(this.getDefaultNameFetchDefaultValue(), ""));
            this.setAppendDefaultNameFetch(Objects.toString(this.getAppendDefaultNameFetchDefaultValue(), ""));
            return;
        }
        this.setDefaultNameFetch(Objects.toString(map.get(DEFAULT_NAME_FETCH), null));
        this.setAppendDefaultNameFetch(Objects.toString(map.get(APPEND_DEFAULT_NAME_FETCH), null));
    }

    public static LangConfig parse(Object value) {
        if (value instanceof String) {
            return new SchemaLangConfig(value.toString());
        }
        if (value instanceof Map) {
            return new SchemaLangConfig((Map)value);
        }
        if (value instanceof SchemaLangConfig) {
            return new SchemaLangConfig((SchemaLangConfig)value);
        }
        return new SchemaLangConfig();
    }

    @Override
    protected void copyTrackInformation(LangConfig parentConfig) {
        super.copyTrackInformation(parentConfig);
        if (parentConfig.isTracked(DEFAULT_NAME_FETCH)) {
            this.tracker.trackModelEntry(DEFAULT_NAME_FETCH);
        }
        if (parentConfig.isTracked(APPEND_DEFAULT_NAME_FETCH)) {
            this.tracker.trackModelEntry(APPEND_DEFAULT_NAME_FETCH);
        }
    }

    private Object getDefaultNameFetchDefaultValue() {
        return Configs.getConfigInfo().get("lang.defaultNameFetch").defaultValue();
    }

    private Object getAppendDefaultNameFetchDefaultValue() {
        return Configs.getConfigInfo().get("lang.appendDefaultNameFetch").defaultValue();
    }

    public String getDefaultNameFetch() {
        return this.defaultNameFetch;
    }

    public String getAppendDefaultNameFetch() {
        return this.appendDefaultNameFetch;
    }

    public boolean hasDefaultNameFetch() {
        return StringUtils.isNotBlank((CharSequence)this.getDefaultNameFetch());
    }

    public boolean isAppendDefaultNameFetch() {
        return Boolean.parseBoolean(this.appendDefaultNameFetch);
    }

    public void setDefaultNameFetch(String defaultNameFetch) {
        this.defaultNameFetch = defaultNameFetch;
        this.tracker.trackValue(DEFAULT_NAME_FETCH, defaultNameFetch);
    }

    public void setAppendDefaultNameFetch(String appendDefaultNameFetch) {
        this.appendDefaultNameFetch = appendDefaultNameFetch;
        this.tracker.trackValue(APPEND_DEFAULT_NAME_FETCH, appendDefaultNameFetch);
    }

    @Override
    public void merge(LangConfig parentConfig) {
        super.merge(parentConfig);
        if (!(parentConfig instanceof SchemaLangConfig)) {
            return;
        }
        SchemaLangConfig parent = (SchemaLangConfig)parentConfig;
        SchemaLangConfig.merge(value -> {
            this.appendDefaultNameFetch = value;
        }, this.appendDefaultNameFetch, parent.appendDefaultNameFetch);
        SchemaLangConfig.merge(value -> {
            this.defaultNameFetch = value;
        }, this.getDefaultNameFetch(), parent.getDefaultNameFetch());
    }

    @Override
    protected boolean propertiesToYaml(StringBuilder builder) {
        boolean hasPreviousValue = super.propertiesToYaml(builder);
        hasPreviousValue = this.appendProperty(builder, hasPreviousValue, DEFAULT_NAME_FETCH, this.getDefaultNameFetch());
        return this.appendProperty(builder, hasPreviousValue, APPEND_DEFAULT_NAME_FETCH, this.appendDefaultNameFetch);
    }

    @Override
    protected boolean isEmptyValue() {
        return super.isEmptyValue() && "".equals(this.defaultNameFetch) && "".equals(this.appendDefaultNameFetch);
    }

    @Override
    protected boolean isDefault() {
        return super.isDefault() && SchemaLangConfig.isDefaultValue(this.getDefaultNameFetchDefaultValue(), this.getDefaultNameFetch()) && SchemaLangConfig.isDefaultValue(this.getAppendDefaultNameFetchDefaultValue().toString(), this.getAppendDefaultNameFetch());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SchemaLangConfig)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        SchemaLangConfig that = (SchemaLangConfig)obj;
        return Objects.equals(this.defaultNameFetch, that.defaultNameFetch) && Objects.equals(this.appendDefaultNameFetch, that.appendDefaultNameFetch);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.defaultNameFetch, this.appendDefaultNameFetch);
    }

    @Override
    public String toString() {
        return String.format("{fetch: '%s', validate: '%s', implicit: '%s', defaultNameFetch: '%s', appendDefaultNameFetch: %s}", this.getFetch(), this.getValidate(), this.getImplicit(), this.getDefaultNameFetch(), this.appendDefaultNameFetch);
    }
}

