/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.ContainedIn;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Role;
import com.ontotext.models.RoleActionType;
import com.ontotext.models.Shape;
import com.ontotext.models.SimpleActionFilter;
import com.ontotext.models.yaml.YamlPrinter;
import com.ontotext.models.yaml.YamlRepresentable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class RoleAction
implements ContainedIn<Role>,
YamlRepresentable {
    private static final String WILDCARD = "*";
    private final String action;
    private String object;
    private String property;
    private RoleActionType actionType;
    private String filter;
    private SimpleActionFilter actionFilter;
    private RoleAction wildcardGeneratedSourceAction;
    private Role role;
    private boolean relatedShapes;
    private boolean relatedPropertyShapes;

    public RoleAction(String action) {
        this.action = action;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public RoleActionType getActionType() {
        return this.actionType;
    }

    public void setActionType(RoleActionType actionType) {
        this.actionType = actionType;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public SimpleActionFilter getActionFilter() {
        return this.actionFilter;
    }

    public void setActionFilter(SimpleActionFilter actionFilter) {
        this.actionFilter = actionFilter;
    }

    public boolean hasFilter() {
        return this.getFilter() != null && this.getFilter().length() > 0;
    }

    public boolean isActionRegexWithFilter() {
        return this.hasFilter() && (this.isObjectRegex() || this.isPropertyRegex());
    }

    public boolean isActionWithoutRegexWithFilter() {
        return !this.isActionRegexWithFilter();
    }

    public boolean isObjectRegex() {
        return this.getObject() != null && this.getObject().contains(WILDCARD);
    }

    public boolean isPropertyRegex() {
        return this.getProperty() != null && this.getProperty().contains(WILDCARD) && !this.getProperty().equals(WILDCARD);
    }

    public RoleAction createDuplicate() {
        RoleAction newAction = new RoleAction(this.action);
        newAction.setObject(this.getObject());
        newAction.setProperty(this.getProperty());
        newAction.setActionType(this.getActionType());
        newAction.setContainedIn(this.getContainedIn());
        newAction.setFilter(this.getFilter());
        newAction.setActionFilter(this.getActionFilter());
        return newAction;
    }

    public RoleAction getWildcardGeneratedSourceAction() {
        return this.wildcardGeneratedSourceAction;
    }

    public boolean hasWildcardGeneratedParentAction() {
        return this.getWildcardGeneratedSourceAction() != null;
    }

    public void setWildcardGeneratedSourceAction(RoleAction wildcardGeneratedSourceAction) {
        this.wildcardGeneratedSourceAction = wildcardGeneratedSourceAction;
    }

    public String getAction() {
        return this.action;
    }

    public void setContainedIn(Role role) {
        this.role = role;
    }

    public void addRelatedShape(Shape shape) {
        this.relatedShapes |= shape != null;
    }

    public boolean hasRelatedShapes() {
        return this.relatedShapes;
    }

    public void addRelatedPropertyShape(PropertyShape shape) {
        this.relatedPropertyShapes |= shape != null;
    }

    public boolean hasRelatedPropertyShapes() {
        return this.relatedPropertyShapes;
    }

    @Override
    public Role getContainedIn() {
        return this.role;
    }

    @Override
    public String toYaml(YamlPrinter.Configuration configuration) {
        return StringUtils.wrapIfMissing((String)YamlPrinter.escapeAndFormatIfRequired(this.action), (char)'\"');
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RoleAction that = (RoleAction)obj;
        return Objects.equals(this.object, that.object) && Objects.equals(this.property, that.property) && this.actionType == that.actionType && Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.object, this.property, this.actionType, this.filter});
    }

    public String toString() {
        return "RoleAction{" + "object='" + this.object + '\'' + ", property='" + this.property + '\'' + ", actionType=" + (Object)((Object)this.actionType) + '\'' + ", filter=" + this.filter + '}';
    }
}

