/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.ContainedIn;
import com.ontotext.models.ModelTracker;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.RdfPropertyResolver;
import com.ontotext.models.ScalarType;
import com.ontotext.models.ScalarTypes;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.TrackedModel;
import com.ontotext.models.sanitizing.Sanitizable;
import com.ontotext.models.sanitizing.SchemaSanitizerUtils;
import com.ontotext.models.yaml.YamlPrinter;
import com.ontotext.models.yaml.YamlRepresentable;
import com.ontotext.soaas.common.ObjectsUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class Properties
extends LinkedHashMap<String, PropertyShape>
implements ContainedIn<Shape>,
TrackedModel,
YamlRepresentable,
Sanitizable {
    private transient Shape containedIn;
    private transient ModelTracker tracker = ModelTracker.notTracked();
    public static final String ID = "id";
    public static final String COUNT = "_count";
    public static final String TYPENAME = "__typename";
    public static final String AFFECTED_COUNT = "affected_count";
    public static final String AFFECTED_OBJECTS = "affected_objects";
    public static final Set<String> PROPS_THAT_USE_VOCAB_PREFIX = Stream.of("name", "id", "type", "value", "lang", "_count").collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));

    public Properties() {
        this(true);
        this.tracker = ModelTracker.tracked();
    }

    public Properties(boolean flag) {
    }

    void expand(Properties baseProperties, ScalarTypes scalars, Shape containedIn, String vocabPfx) {
        if (null != containedIn) {
            this.containedIn = containedIn;
        }
        HashSet modifiedNames = new HashSet();
        this.forEach((name, property) -> this.initializeProperty((String)name, (PropertyShape)property, baseProperties, scalars, containedIn, vocabPfx, modifiedNames));
        modifiedNames.forEach((? super T oldName) -> {
            PropertyShape shape = (PropertyShape)this.remove(oldName);
            this.put(shape.getName(), shape);
        });
    }

    private void initializeProperty(String name, PropertyShape property, Properties baseProperties, ScalarTypes scalars, Shape containedIn, String vocabPfx, Set<String> modifiedNames) {
        PropertyShape baseProperty;
        if (null != vocabPfx) {
            String oldName = name;
            if (Shapes.isSystemShapeOrInterface(name = Properties.simplifyName(vocabPfx, name))) {
                name = oldName;
            }
            if (!Objects.equals(name, oldName)) {
                modifiedNames.add(oldName);
                if (containedIn != null && Objects.equals(containedIn.getName(), oldName)) {
                    containedIn.setName(name);
                }
            }
        }
        property.setName(name);
        if (property.getRange() != null) {
            property.setScalarType((ScalarType)scalars.get(property.getRange()));
        }
        if ((baseProperty = (PropertyShape)baseProperties.get(name)) == null) {
            return;
        }
        this.copyPropertiesIfNotDefied(property, baseProperty);
        scalars.getContainedIn().getConfig().getLang().ifPresent(property::copyLangConfigFrom);
        this.mergeMeta(property, baseProperty);
    }

    private void mergeMeta(PropertyShape property, PropertyShape baseProperty) {
        if (!baseProperty.getMeta().isEmpty()) {
            HashMap<String, Object> combined = new HashMap<String, Object>();
            combined.putAll(baseProperty.getMeta());
            combined.putAll(property.getMeta());
            property.setMeta(combined);
        }
    }

    public String simplifyName(String name) {
        String vocPfx = null;
        if (null != this.containedIn) {
            vocPfx = this.containedIn.getContainedIn().getContainedIn().getSpecialPrefixes().getVocabPrefix().orElse(null);
        }
        return Properties.simplifyName(vocPfx, name);
    }

    public static String simplifyName(String prefix, String name) {
        if (null == name) {
            return null;
        }
        if (null == prefix) {
            return name;
        }
        if (name.startsWith((String)(prefix = (String)prefix + ":")) && !PROPS_THAT_USE_VOCAB_PREFIX.contains(name.replace((CharSequence)prefix, ""))) {
            return name.replace((CharSequence)prefix, "");
        }
        return name;
    }

    private String addVocPfx(String name) {
        if (null != this.containedIn) {
            return this.containedIn.getContainedIn().getContainedIn().getPrefixes().toShortIri(name);
        }
        return name;
    }

    public Optional<String> getResolvedRdfProp(Shape shape, PropertyShape prop) {
        return RdfPropertyResolver.resolveProperty(shape, prop);
    }

    private void copyPropertiesIfNotDefied(PropertyShape copyTo, PropertyShape copyFrom) {
        Properties.merge(copyTo::setRange, copyTo.getRange(), copyFrom.getRange());
        Properties.merge(copyTo::setGen, copyTo.getGen(), copyFrom.getGen());
        Properties.merge(copyTo::setRangeCheck, copyTo.getRangeCheck(), copyFrom.getRangeCheck());
        Properties.merge(copyTo::setTypeCast, copyTo.getTypeCast(), copyFrom.getTypeCast());
        Properties.merge(copyTo::setDescr, copyTo.getDescr(), copyFrom.getDescr());
        if (StringUtils.isBlank((CharSequence)copyTo.getRdfProp())) {
            Properties.merge(copyTo::setInverseAlias, copyTo.getInverseAlias(), copyFrom.getInverseAlias());
        }
        Properties.merge(copyTo::setSparqlTemplate, copyTo.getSparqlTemplate(), copyFrom.getSparqlTemplate());
        Properties.merge(copyTo::setInverseOf, copyTo.getInverseOf(), copyFrom.getInverseOf());
        Properties.merge(copyTo::setKind, copyTo.getKind(), copyFrom.getKind());
        Properties.merge(copyTo::setLabel, copyTo.getLabel(), copyFrom.getLabel());
        Properties.merge(copyTo::setMax, copyTo.getMax(), copyFrom.getMax());
        Properties.merge(copyTo::setMin, copyTo.getMin(), copyFrom.getMin());
        Properties.merge(copyTo::setPrefix, copyTo.getPrefix(), copyFrom.getPrefix());
        Properties.merge(copyTo::setPattern, copyTo.getPattern(), copyFrom.getPattern());
        Properties.merge(copyTo::setSymmetric, copyTo.getSymmetric(), copyFrom.getSymmetric());
        Properties.merge(copyTo::setExternal, copyTo.getExternal(), copyFrom.getExternal());
        Properties.merge(copyTo::setNonNullable, copyTo.isNonNullable(), copyFrom.isNonNullable());
        Properties.merge(copyTo::setNonNullableElements, copyTo.isNonNullableElements(), copyFrom.isNonNullableElements());
        Properties.merge(copyTo::setReadOnly, copyTo.getReadOnly(), copyFrom.getReadOnly());
        Properties.merge(copyTo::setFiltered, copyTo.getFiltered(), copyFrom.getFiltered());
        Properties.merge(copyTo::setOrdered, copyTo.getOrdered(), copyFrom.getOrdered());
        Properties.merge(copyTo::setScaleFactor, copyTo.getScaleFactor(), copyFrom.getScaleFactor());
        if (StringUtils.isBlank((CharSequence)copyTo.getInverseAlias())) {
            Properties.merge(copyTo::setRdfProp, copyTo.getRdfProp(), copyFrom.getAsAbsoluteRdfProp());
        }
        copyTo.copyLangConfigFrom(copyFrom.getLangConfig());
        copyTo.mergeSearchConfig(copyFrom.getSearch());
    }

    private static <T> void merge(Consumer<T> valueConsumer, T value, T defaultValue) {
        valueConsumer.accept(ObjectsUtil.getOrDefault(value, defaultValue));
    }

    public void merge(Properties properties) {
        this.putAll(properties);
        properties.keySet().forEach(this.tracker::trackModelEntry);
    }

    void setDefaults() {
        this.values().forEach(PropertyShape::setDefaults);
    }

    public void setContainedIn(Shape containedIn) {
        this.containedIn = containedIn;
    }

    @Override
    public PropertyShape put(String key, PropertyShape value) {
        this.tracker.trackModelEntry(key);
        if (value == null) {
            return super.put(key, new PropertyShape(true));
        }
        return super.put(key, value);
    }

    @Override
    public PropertyShape computeIfAbsent(String key, Function<? super String, ? extends PropertyShape> mappingFunction) {
        this.tracker.trackModelEntry(key);
        return super.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public PropertyShape putIfAbsent(String key, PropertyShape value) {
        this.tracker.trackValue(key, value);
        return super.putIfAbsent(key, value);
    }

    @Override
    public Shape getContainedIn() {
        return this.containedIn;
    }

    @Override
    public void stopTracking() {
        this.tracker = ModelTracker.disableTracking(this.tracker);
        this.values().forEach(TrackedModel::stopTracking);
    }

    @Override
    public void startTracking() {
        this.tracker = ModelTracker.enableTracking(this.tracker);
        this.values().forEach(TrackedModel::startTracking);
    }

    @Override
    public void clearTrackedInformation() {
        this.tracker.clear();
        this.values().forEach(TrackedModel::clearTrackedInformation);
    }

    @Override
    public boolean isTracked(String modelId) {
        return this.tracker.isTracked(modelId) || this.tracker.isTracked(this.simplifyName(modelId)) || this.tracker.isTracked(this.addVocPfx(modelId));
    }

    @Override
    public String toYaml(YamlPrinter.Configuration configuration) {
        return new YamlPrinter(configuration).addMapValues(this, prop -> this.isTracked(prop.getName())).asString();
    }

    @Override
    public void sanitize(Sanitizable.Context context) {
        Map<String, String> sanitizedPropertiesNames = SchemaSanitizerUtils.sanitizeMap(this, context.getOperationReport());
        sanitizedPropertiesNames.forEach(this.tracker::updateKey);
        context.getOrCreateSanitizedPropertiesNames().putAll(sanitizedPropertiesNames);
        this.values().forEach((? super T prop) -> Sanitizable.sanitize(context, (Sanitizable)prop));
    }

    void fillInContainedIn() {
        this.values().stream().filter(propertyShape -> propertyShape.getContainedIn() == null).forEach((? super T propertyShape) -> propertyShape.setContainedIn(this));
    }
}

