/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.MessageProvider;
import com.ontotext.soaas.plugin.PluginsManager;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ErrorMessages {
    private static final ErrorMessages INSTANCE = new ErrorMessages();
    private Map<String, String> messages;

    public static String get(String templateKey) {
        return INSTANCE.getMessages().getOrDefault(templateKey, templateKey);
    }

    public static String get(String templateKey, Object ... args) {
        String template = INSTANCE.getMessages().get(templateKey);
        if (template == null) {
            throw new IllegalArgumentException(ErrorMessages.buildNotFoundMessage(templateKey, args));
        }
        return String.format(template, args);
    }

    private static String buildNotFoundMessage(String templateKey, Object[] args) {
        return "No message defined for: '" + templateKey + "' and args: " + Arrays.stream(args).map(Object::toString).collect(Collectors.joining(", "));
    }

    private Map<String, String> getMessages() {
        if (this.messages == null) {
            this.messages = ErrorMessages.getResolvers().stream().map(MessageProvider::provide).reduce(new LinkedHashMap(), (last, current) -> {
                last.putAll(current);
                return last;
            });
        }
        return this.messages;
    }

    private static List<MessageProvider> getResolvers() {
        return PluginsManager.loadPlugins(MessageProvider.class);
    }
}

