/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.ConfigInfo;
import com.ontotext.models.LangConfig;
import com.ontotext.models.ModelTracker;
import com.ontotext.models.SchemaLangConfig;
import com.ontotext.models.SparqlFederatedServicesPriority;
import com.ontotext.models.TrackedModel;
import com.ontotext.models.search.SearchConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class Configs
extends LinkedHashMap<String, Object>
implements TrackedModel {
    public static final String ENABLE_MUTATIONS = "enable_mutations";
    public static final String LANG = "lang";
    public static final String QUERY_PFX = "queryPfx";
    public static final String MUTATION_PFX = "mutationPfx";
    public static final String SEARCH = "search";
    public static final String REPOSITORY = "repository";
    public static final String INCLUDE_INFERRED = "includeInferred";
    public static final String EXPAND_OWL_SAME_AS = "expandOwlSameAs";
    public static final String DISABLED_CHECKS = "disabledChecks";
    public static final String DEFAULT_ROLE = "defaultRole";
    public static final String ADMIN_ROLE = "adminRole";
    public static final String DEFAULT_INTEGRATION_ROLE = "defaultIntegrationRole";
    public static final String EXPOSE_SOML_IN_GRAPHQL = "exposeSomlInGraphQL";
    public static final String ENABLE_COLLECTION_COUNT = "enableCollectionCount";
    public static final String ENABLE_TYPE_COUNT = "enableTypeCount";
    public static final String COMPACT_ERROR_MESSAGES = "compactErrorMessages";
    public static final String ENABLE_GRAPHQL_EXPLAIN = "enableGraphQlExplain";
    public static final String SPARQL_FEDERATED_SERVICES = "sparqlFederatedServices";
    public static final String SPARQL_FEDERATED_SERVICES_PRIORITY = "sparqlFederatedServicesPriority";
    private static final Map<String, ConfigInfo> CONFIG_INFO_MAP;
    private transient ModelTracker tracker = ModelTracker.notTracked();
    public static final String IDENTIFIER_REGEX = "[\\w]*";

    public Configs() {
        this.tracker = ModelTracker.tracked();
    }

    public Configs(boolean notTracked) {
    }

    public Object setLang(Object lang) {
        return super.put(LANG, SchemaLangConfig.parse(lang));
    }

    public Optional<SchemaLangConfig> getLang() {
        return Optional.ofNullable((SchemaLangConfig)this.get(LANG));
    }

    public Object setSearch(Object search) {
        if (search instanceof SearchConfig) {
            return super.put(SEARCH, search);
        }
        if (search instanceof Map) {
            return super.put(SEARCH, SearchConfig.fromMap((Map)search));
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        this.tracker.trackValue(key, value);
        if (LANG.equals(key)) {
            return this.setLang(value);
        }
        if (SEARCH.equals(key)) {
            return this.setSearch(value);
        }
        return super.put(key, value);
    }

    @Override
    public Object computeIfAbsent(String key, Function<? super String, ?> mappingFunction) {
        this.tracker.trackModelEntry(key);
        return super.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public Object putIfAbsent(String key, Object value) {
        if ((LANG.equals(key) || SEARCH.equals(key)) && !this.containsKey(key)) {
            return this.put(key, value);
        }
        this.tracker.trackValue(key, value);
        return super.putIfAbsent(key, value);
    }

    public Optional<Boolean> areMutationsEnabled() {
        return this.getOrEmpty(ENABLE_MUTATIONS, value -> Boolean.valueOf(value.toString()));
    }

    public Optional<Boolean> isGraphQlExplainEnabled() {
        return this.getOrEmpty(ENABLE_GRAPHQL_EXPLAIN, value -> Boolean.valueOf(value.toString()));
    }

    public Optional<Map<String, String>> getSparqlFederatedServices() {
        return this.getOrEmpty(SPARQL_FEDERATED_SERVICES, value -> {
            if (value instanceof Map) {
                Map map = (Map)value;
                return map;
            }
            return Map.of();
        });
    }

    public Optional<SparqlFederatedServicesPriority> getSparqlFederatedServicesPriority() {
        return this.getOrEmpty(SPARQL_FEDERATED_SERVICES_PRIORITY, value -> SparqlFederatedServicesPriority.fromCode(value.toString()));
    }

    public String getQueryName(String name) {
        Optional<String> pfx = this.getQueryPfx();
        return pfx.map(s -> s + name).orElse(name);
    }

    public String getMutationName(String name) {
        Optional<String> pfx = this.getMutationPfx();
        return pfx.map(s -> s + name).orElse(name);
    }

    public Optional<String> getQueryPfx() {
        return this.getOrEmpty(QUERY_PFX, String.class::cast);
    }

    public Optional<String> getMutationPfx() {
        return this.getOrEmpty(MUTATION_PFX, String.class::cast);
    }

    public Optional<SearchConfig> getSearch() {
        return this.getOrEmpty(SEARCH, SearchConfig.class::cast);
    }

    public Optional<String> getRepository() {
        return this.getOrEmpty(REPOSITORY, String.class::cast);
    }

    public Optional<Boolean> getIncludeInferred() {
        return this.getOrEmpty(INCLUDE_INFERRED, value -> Boolean.parseBoolean(value.toString()));
    }

    public Optional<Boolean> getExpandOverOwlSameAs() {
        return this.getOrEmpty(EXPAND_OWL_SAME_AS, value -> Boolean.parseBoolean(value.toString()));
    }

    public Optional<Set<String>> getDisabledChecks() {
        return this.getOrEmpty(DISABLED_CHECKS, value -> {
            if (value instanceof String || value instanceof Boolean) {
                return Collections.singleton(value.toString());
            }
            return new HashSet((Collection)value);
        });
    }

    public boolean isCheckEnabled(String checkName) {
        return this.getDisabledChecks().filter(disabledChecks -> disabledChecks.contains(checkName)).isEmpty();
    }

    public Optional<String> getDefaultRole() {
        return this.getOrEmpty(DEFAULT_ROLE, String.class::cast);
    }

    public Optional<String> getAdminRole() {
        return this.getOrEmpty(ADMIN_ROLE, String.class::cast);
    }

    public Optional<String> getDefaultIntegrationRole() {
        return this.getOrEmpty(DEFAULT_INTEGRATION_ROLE, String.class::cast);
    }

    public Optional<Boolean> isExposeSomlInGraphQl() {
        return this.getOrEmpty(EXPOSE_SOML_IN_GRAPHQL, value -> Boolean.parseBoolean(value.toString()));
    }

    public Optional<Boolean> isCollectionCountingEnabled() {
        return this.getOrEmpty(ENABLE_COLLECTION_COUNT, value -> Boolean.parseBoolean(value.toString()));
    }

    public Optional<Boolean> isTypeCountingEnabled() {
        return this.getOrEmpty(ENABLE_TYPE_COUNT, value -> Boolean.parseBoolean(value.toString()));
    }

    public Optional<Boolean> shouldCompactMessages() {
        return this.getOrEmpty(COMPACT_ERROR_MESSAGES, value -> Boolean.parseBoolean(value.toString()));
    }

    void merge(Configs copyFrom) {
        copyFrom.forEach((key, value) -> {
            if (key.equals(LANG)) {
                this.put(LANG, (Object)this.mergeLangConfig((LangConfig)value));
            } else {
                this.put((String)key, value);
            }
        });
        copyFrom.keySet().forEach(this.tracker::trackModelEntry);
    }

    LangConfig mergeLangConfig(LangConfig copyTo) {
        SchemaLangConfig langConfig = this.getLang().orElse(null);
        if (langConfig == null) {
            return copyTo;
        }
        copyTo.merge(langConfig);
        return copyTo;
    }

    @Override
    public void clearTrackedInformation() {
        this.tracker.clear();
        this.values().stream().filter(TrackedModel.class::isInstance).map(TrackedModel.class::cast).forEach(TrackedModel::clearTrackedInformation);
    }

    @Override
    public void startTracking() {
        this.tracker = ModelTracker.enableTracking(this.tracker);
        this.values().stream().filter(TrackedModel.class::isInstance).map(TrackedModel.class::cast).forEach(TrackedModel::startTracking);
    }

    @Override
    public void stopTracking() {
        this.tracker = ModelTracker.disableTracking(this.tracker);
        this.values().stream().filter(TrackedModel.class::isInstance).map(TrackedModel.class::cast).forEach(TrackedModel::stopTracking);
    }

    @Override
    public boolean isTracked(String modelId) {
        return this.tracker.isTracked(modelId);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Configs)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31;
    }

    private <T> Optional<T> getOrEmpty(String key, Function<Object, T> valueTransformer) {
        Object value = this.get(key);
        if (value == null) {
            Object defaultValue = Configs.getConfigInfo().get(key).defaultValue();
            return defaultValue == null ? Optional.empty() : Optional.of(valueTransformer.apply(defaultValue));
        }
        return Optional.of(valueTransformer.apply(value));
    }

    public static Map<String, ConfigInfo> getConfigInfo() {
        return CONFIG_INFO_MAP;
    }

    static {
        LinkedHashMap<String, ConfigInfo> configInfoMap = new LinkedHashMap<String, ConfigInfo>();
        configInfoMap.put(ENABLE_MUTATIONS, new ConfigInfo(ENABLE_MUTATIONS, null, Boolean.TYPE.getSimpleName(), "Controls whether the generated GraphQL schema should include object mutations or not.", Boolean.TRUE, null, false, null));
        configInfoMap.put("lang.fetch", new ConfigInfo("fetch", null, String.class.getSimpleName().toLowerCase(), "Default language fetch configuration", null, null, false, "^(?:ALL:?)?(?:(?:-?[\\w]{2}(?:-[\\w]*)?~?|-?NONE|ANY|BROWSER)?(?:,(?:-?[\\w]{2}(?:-[\\w]*)?~?|-?NONE|ANY|BROWSER))*)$"));
        configInfoMap.put("lang.validate", new ConfigInfo("validate", null, String.class.getSimpleName().toLowerCase(), "Default language validation configuration", "UNIQ", null, false, "^(?:[\\w]{2}~?|NONE|ANY|ALL)?(?:,(?:[\\w]{2}~?|NONE|ANY|ALL))*(?:;?UNIQ)?$"));
        configInfoMap.put("lang.implicit", new ConfigInfo("implicit", null, String.class.getSimpleName().toLowerCase(), "Default language to use when inserting rdf:langString values.", "en", null, false, "[\\w]{2}(?:-[\\w]*)?"));
        configInfoMap.put("lang.defaultNameFetch", new ConfigInfo("defaultNameFetch", null, String.class.getSimpleName().toLowerCase(), "Default language spec to apply when loading values for the name property", "ANY", null, false, "^(?:(?:-?[\\w]{2}(?:-[\\w]*)?~?|-?NONE|ANY|BROWSER)?(?:,(?:-?[\\w]{2}(?:-[\\w]*)?~?|-?NONE|ANY|BROWSER))*)$"));
        configInfoMap.put("lang.appendDefaultNameFetch", new ConfigInfo("appendDefaultNameFetch", null, Boolean.class.getSimpleName().toLowerCase(), "Specifies whether the default spec, if any, should be appended or not to any user-defined name fetch spec", Boolean.TRUE, null, false, null));
        configInfoMap.put(QUERY_PFX, new ConfigInfo(QUERY_PFX, null, String.class.getSimpleName().toLowerCase(), "Allows setting a prefix that will be put in all queries in the GraphQL schema.", null, null, false, IDENTIFIER_REGEX));
        configInfoMap.put(MUTATION_PFX, new ConfigInfo(MUTATION_PFX, null, String.class.getSimpleName().toLowerCase(), "Allows setting a prefix that will be put in all mutations in the GraphQL schema.", null, null, false, IDENTIFIER_REGEX));
        configInfoMap.put(SEARCH, new ConfigInfo(SEARCH, null, "dictionary", "Allows you to define a structure of the searchable data for fields that are not specified in the configuration of the objects and/or properties", null, null, false, null));
        configInfoMap.put(REPOSITORY, new ConfigInfo(REPOSITORY, null, String.class.getSimpleName().toLowerCase(), "Changes the default repository used for the entire schema.", null, null, false, IDENTIFIER_REGEX));
        configInfoMap.put(INCLUDE_INFERRED, new ConfigInfo(INCLUDE_INFERRED, null, Boolean.TYPE.getSimpleName(), "Controls whether query inference is enabled or disabled by default for all queries and mutations.", Boolean.TRUE, null, false, null));
        configInfoMap.put(EXPAND_OWL_SAME_AS, new ConfigInfo(EXPAND_OWL_SAME_AS, null, Boolean.TYPE.getSimpleName(), "Controls whether owl:sameAs expansion is enabled or disabled by default for all queries and mutations.", Boolean.TRUE, null, false, null));
        configInfoMap.put(DISABLED_CHECKS, new ConfigInfo(DISABLED_CHECKS, null, "[string]", "Specifies which checks could be disabled during the schema validation.", Boolean.TRUE, List.of("regexInheritanceCheck", "rangeCheck"), false, null));
        configInfoMap.put(ADMIN_ROLE, new ConfigInfo(ADMIN_ROLE, null, String.class.getSimpleName().toLowerCase(), "An administration role that will be added to the schema if the configuration is present and no role with such name has been declared in the RBAC.", null, null, false, IDENTIFIER_REGEX));
        configInfoMap.put(DEFAULT_ROLE, new ConfigInfo(DEFAULT_ROLE, null, String.class.getSimpleName().toLowerCase(), "The default RBAC role the user will receive if no roles are found in the security JWT token or none of the roles match any in the rbac section of the current SOML schema.", "Default", null, false, IDENTIFIER_REGEX));
        configInfoMap.put(DEFAULT_INTEGRATION_ROLE, new ConfigInfo(DEFAULT_INTEGRATION_ROLE, null, String.class.getSimpleName().toLowerCase(), "The default RBAC role that will have read-only access to the data and could be used for system integrations.", "Federation_SystemRole", null, false, IDENTIFIER_REGEX));
        configInfoMap.put(EXPOSE_SOML_IN_GRAPHQL, new ConfigInfo(EXPOSE_SOML_IN_GRAPHQL, null, Boolean.TYPE.getSimpleName(), "Controls whether GraphQL schema should include directives that expose the effective SOML configurations for each output type and property.", Boolean.FALSE, null, false, null));
        configInfoMap.put(ENABLE_COLLECTION_COUNT, new ConfigInfo(ENABLE_COLLECTION_COUNT, null, Boolean.TYPE.getSimpleName(), "Controls whether the collections should have a companion property that provides counting of the collection properties.", Boolean.FALSE, null, false, null));
        configInfoMap.put(ENABLE_TYPE_COUNT, new ConfigInfo(ENABLE_TYPE_COUNT, null, Boolean.TYPE.getSimpleName(), "Controls whether new counting queries should be generated for all queryable types.", Boolean.FALSE, null, false, null));
        configInfoMap.put(COMPACT_ERROR_MESSAGES, new ConfigInfo(COMPACT_ERROR_MESSAGES, null, Boolean.TYPE.getSimpleName(), "Controls the default behavior of the GraphQL Responder how to process the errors that are returned to the client.", Boolean.FALSE, null, false, null));
        configInfoMap.put(ENABLE_GRAPHQL_EXPLAIN, new ConfigInfo(ENABLE_GRAPHQL_EXPLAIN, null, Boolean.TYPE.getSimpleName(), "Controls whether SemanticObjects should provide the generated SPARQL query or its explain plan.", Boolean.TRUE, null, false, null));
        configInfoMap.put(SPARQL_FEDERATED_SERVICES, new ConfigInfo(SPARQL_FEDERATED_SERVICES, null, "dictionary", "Allows configuring the SPARQL federated services.", null, null, false, null));
        configInfoMap.put(SPARQL_FEDERATED_SERVICES_PRIORITY, new ConfigInfo(SPARQL_FEDERATED_SERVICES_PRIORITY, null, "String", "Specifies the priority of the SPARQL federated services.", "config_first", List.of("model_first", "config_first"), false, null));
        CONFIG_INFO_MAP = Collections.unmodifiableMap(configInfoMap);
    }
}

