/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.dependencies.iterators.predicates;

import com.ontotext.trree.plugin.dependencies.DependenciesPlugin;
import com.ontotext.trree.plugin.dependencies.DependencyPredicate;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.StatementIterator;
import gnu.trove.TLongLongHashMap;
import gnu.trove.TLongLongIterator;
import gnu.trove.TLongObjectHashMap;
import gnu.trove.TLongObjectIterator;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class DependencyPredicatesMainIterator
extends StatementIterator {
    private final Entities entities;
    private final TLongObjectHashMap<TLongObjectHashMap<TLongLongHashMap>> dependenciesPredicatesCount;
    private final TLongObjectIterator<TLongObjectHashMap<TLongLongHashMap>> firstIterator;
    private TLongObjectIterator<TLongLongHashMap> secondIterator;
    private TLongLongIterator thirdIterator;
    private DependencyPredicate currentDependencyPredicate;
    private long from;
    private long to;

    public DependencyPredicatesMainIterator(DependenciesPlugin dependenciesPlugin, Entities entities, long subject, long predicate, long object, long context) {
        String stringContext = dependenciesPlugin.longContextToIRI(entities, context);
        this.dependenciesPredicatesCount = dependenciesPlugin.getDependenciesPredicatesCount(stringContext);
        this.firstIterator = dependenciesPlugin.getDependenciesPredicatesCount(stringContext).iterator();
        this.entities = entities;
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean next() {
        if (this.thirdIterator == null && this.secondIterator == null && this.firstIterator.hasNext()) {
            if (this.from != 0L) {
                if (!this.dependenciesPredicatesCount.containsKey(this.from)) return false;
                this.secondIterator = ((TLongObjectHashMap)this.dependenciesPredicatesCount.get(this.from)).iterator();
            } else {
                this.firstIterator.advance();
                this.secondIterator = ((TLongObjectHashMap)this.firstIterator.value()).iterator();
            }
            if (this.secondIterator.hasNext()) {
                if (this.from != 0L && this.to != 0L) {
                    if (!((TLongObjectHashMap)this.dependenciesPredicatesCount.get(this.from)).containsKey(this.to)) return false;
                    this.thirdIterator = ((TLongLongHashMap)((TLongObjectHashMap)this.dependenciesPredicatesCount.get(this.from)).get(this.to)).iterator();
                } else {
                    this.secondIterator.advance();
                    this.thirdIterator = ((TLongLongHashMap)this.secondIterator.value()).iterator();
                }
            }
        }
        if (this.thirdIterator == null) {
            return false;
        }
        if (!(this.thirdIterator.hasNext() || this.from != 0L && this.to != 0L)) {
            if (!this.secondIterator.hasNext()) {
                if (!this.firstIterator.hasNext()) {
                    return false;
                }
                this.firstIterator.advance();
                this.secondIterator = ((TLongObjectHashMap)this.firstIterator.value()).iterator();
                if (!this.secondIterator.hasNext()) {
                    return false;
                }
            }
            this.secondIterator.advance();
            this.thirdIterator = ((TLongLongHashMap)this.secondIterator.value()).iterator();
        }
        if (!this.thirdIterator.hasNext()) {
            return false;
        }
        this.thirdIterator.advance();
        BNode node = SimpleValueFactory.getInstance().createBNode();
        this.subject = this.entities.put((Value)node, Entities.Scope.REQUEST);
        Literal countLiteral = SimpleValueFactory.getInstance().createLiteral(this.thirdIterator.value());
        this.currentDependencyPredicate = new DependencyPredicate(this.from != 0L ? this.from : this.firstIterator.key(), this.to != 0L ? this.to : this.secondIterator.key(), this.thirdIterator.key(), this.entities.put((Value)countLiteral, Entities.Scope.REQUEST));
        return true;
    }

    public void close() {
    }

    public DependencyPredicate getCurrentDependencyPredicate() {
        return this.currentDependencyPredicate;
    }

    public long getFrom() {
        return this.from;
    }

    public void setFrom(long from) {
        this.from = from;
    }

    public long getTo() {
        return this.to;
    }

    public void setTo(long to) {
        this.to = to;
    }
}

