/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.dependencies;

import com.ontotext.trree.plugin.dependencies.DependenciesRequestContext;
import com.ontotext.trree.plugin.dependencies.iterators.dependencies.DependenciesMainIterator;
import com.ontotext.trree.plugin.dependencies.iterators.dependencies.DependenciesToIIterator;
import com.ontotext.trree.plugin.dependencies.iterators.dependencies.DependenciesWeightIterator;
import com.ontotext.trree.plugin.dependencies.iterators.predicates.DependencyPredicatesCountIterator;
import com.ontotext.trree.plugin.dependencies.iterators.predicates.DependencyPredicatesFromIterator;
import com.ontotext.trree.plugin.dependencies.iterators.predicates.DependencyPredicatesMainIterator;
import com.ontotext.trree.plugin.dependencies.iterators.predicates.DependencyPredicatesPredicateIterator;
import com.ontotext.trree.plugin.dependencies.iterators.predicates.DependencyPredicatesToIterator;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.InitReason;
import com.ontotext.trree.sdk.PatternInterpreter;
import com.ontotext.trree.sdk.PluginBase;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.Preprocessor;
import com.ontotext.trree.sdk.Request;
import com.ontotext.trree.sdk.RequestContext;
import com.ontotext.trree.sdk.StatementIterator;
import com.ontotext.trree.sdk.Statements;
import gnu.trove.TLongLongHashMap;
import gnu.trove.TLongObjectHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SESAME;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependenciesPlugin
extends PluginBase
implements PatternInterpreter,
Preprocessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependenciesPlugin.class);
    private static ValueFactory VF = SimpleValueFactory.getInstance();
    private static final String DB_FILENAME = "dependencies-graph.db";
    private static final String DEPENDENCIES_NAMESPACE = "http://www.ontotext.com/plugins/dependencies#%s";
    private static final IRI GET_DEPENDENCIES_PREDICATE = VF.createIRI(String.format("http://www.ontotext.com/plugins/dependencies#%s", "dependencies"));
    private static final IRI DEPENDENCIES_TO_PREDICATE = VF.createIRI(String.format("http://www.ontotext.com/plugins/dependencies#%s", "to"));
    private static final IRI DEPENDENCIES_COUNT_PREDICATE = VF.createIRI(String.format("http://www.ontotext.com/plugins/dependencies#%s", "count"));
    private static final IRI LIST_DEPENDENCY_PREDICATES = VF.createIRI(String.format("http://www.ontotext.com/plugins/dependencies#%s", "listPredicates"));
    private static final IRI LIST_PREDICATE = VF.createIRI(String.format("http://www.ontotext.com/plugins/dependencies#%s", "predicate"));
    private static final IRI LIST_PREDICATE_COUNT = VF.createIRI(String.format("http://www.ontotext.com/plugins/dependencies#%s", "predicateCount"));
    private static final IRI LIST_PREDICATES_FROM = VF.createIRI(String.format("http://www.ontotext.com/plugins/dependencies#%s", "fromClass"));
    private static final IRI LIST_PREDICATES_TO = VF.createIRI(String.format("http://www.ontotext.com/plugins/dependencies#%s", "toClass"));
    private static final IRI DEPENDENCIES_STATUS_PREDICATE = VF.createIRI(String.format("http://www.ontotext.com/plugins/dependencies#%s", "status"));
    private static final IRI DEPENDENCIES_UPDATE_PREDICATE = VF.createIRI(String.format("http://www.ontotext.com/plugins/dependencies#%s", "update"));
    private static final IRI PLUGIN_PRESENT_PREDICATE = VF.createIRI(String.format("http://www.ontotext.com/plugins/dependencies#%s", "present"));
    private static final IRI PLUGIN_DATA_CHANGED_PREDICATE = VF.createIRI(String.format("http://www.ontotext.com/plugins/dependencies#%s", "dataChanged"));
    private long getDependenciesId;
    private long toPredicateId;
    private long countPredicateId;
    private long listDependencyPredicates;
    private long listPredicate;
    private long listPredicateCount;
    private long listPredicatesFrom;
    private long listPredicatesTo;
    private long typePredicate;
    private long statusPredicateId;
    private long updatePredicateId;
    private long presentPredicateId;
    private long dataChangedPredicateId;
    private Map<String, Status> statuses = new HashMap<String, Status>();
    private Map<String, String> graphsFingerprints = new HashMap<String, String>();
    private Map<String, TLongObjectHashMap<TLongLongHashMap>> dependenciesGraphs = new HashMap<String, TLongObjectHashMap<TLongLongHashMap>>();
    private Map<String, TLongObjectHashMap<TLongObjectHashMap<TLongLongHashMap>>> dependenciesPredicatesCounts = new HashMap<String, TLongObjectHashMap<TLongObjectHashMap<TLongLongHashMap>>>();

    public String getName() {
        return "dependencies-plugin";
    }

    public void initialize(InitReason initReason, PluginConnection pluginConnection) {
        this.registerPredicates(pluginConnection.getEntities());
        this.loadFromCache();
    }

    private void loadFromCache() {
        try {
            File cacheFile = new File(this.getDataDir(), DB_FILENAME);
            if (cacheFile.exists()) {
                FileInputStream fileInputStream = new FileInputStream(cacheFile);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                this.dependenciesGraphs = (Map)objectInputStream.readObject();
                this.dependenciesPredicatesCounts = (Map)objectInputStream.readObject();
                this.graphsFingerprints = (Map)objectInputStream.readObject();
                for (Map.Entry<String, TLongObjectHashMap<TLongLongHashMap>> e : this.dependenciesGraphs.entrySet()) {
                    if (e.getValue().isEmpty()) continue;
                    this.setStatus(e.getKey(), Status.READY);
                }
                LOGGER.info("Dependency graph was restored from cache");
            }
        }
        catch (IOException | ClassNotFoundException e) {
            LOGGER.error("Could not load dependencies cache", (Throwable)e);
            this.dependenciesGraphs = new HashMap<String, TLongObjectHashMap<TLongLongHashMap>>();
            this.dependenciesPredicatesCounts = new HashMap<String, TLongObjectHashMap<TLongObjectHashMap<TLongLongHashMap>>>();
            this.graphsFingerprints = new HashMap<String, String>();
        }
    }

    private void storeInCache() {
        File dbFile = this.getFile(DB_FILENAME);
        try (FileOutputStream fileOutputStream = new FileOutputStream(dbFile);
             ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);){
            objectOutputStream.writeObject(this.dependenciesGraphs);
            objectOutputStream.writeObject(this.dependenciesPredicatesCounts);
            objectOutputStream.writeObject(this.graphsFingerprints);
        }
        catch (IOException e) {
            LOGGER.error("Could not store dependencies cache", (Throwable)e);
        }
    }

    private File getFile(String dbFilename) {
        File dataDir = this.getDataDir();
        File dbFile = new File(dataDir, dbFilename);
        if (!dataDir.exists()) {
            try {
                FileUtils.forceMkdir((File)dataDir);
                dbFile.createNewFile();
            }
            catch (IOException e) {
                LOGGER.error("Could create directory " + dataDir, (Throwable)e);
            }
        }
        return dbFile;
    }

    private void registerPredicates(Entities entities) {
        this.typePredicate = entities.put((Value)RDF.TYPE, Entities.Scope.DEFAULT);
        this.getDependenciesId = entities.put((Value)GET_DEPENDENCIES_PREDICATE, Entities.Scope.SYSTEM);
        this.toPredicateId = entities.put((Value)DEPENDENCIES_TO_PREDICATE, Entities.Scope.SYSTEM);
        this.countPredicateId = entities.put((Value)DEPENDENCIES_COUNT_PREDICATE, Entities.Scope.SYSTEM);
        this.listDependencyPredicates = entities.put((Value)LIST_DEPENDENCY_PREDICATES, Entities.Scope.SYSTEM);
        this.listPredicate = entities.put((Value)LIST_PREDICATE, Entities.Scope.SYSTEM);
        this.listPredicateCount = entities.put((Value)LIST_PREDICATE_COUNT, Entities.Scope.SYSTEM);
        this.listPredicatesFrom = entities.put((Value)LIST_PREDICATES_FROM, Entities.Scope.SYSTEM);
        this.listPredicatesTo = entities.put((Value)LIST_PREDICATES_TO, Entities.Scope.SYSTEM);
        this.statusPredicateId = entities.put((Value)DEPENDENCIES_STATUS_PREDICATE, Entities.Scope.SYSTEM);
        this.updatePredicateId = entities.put((Value)DEPENDENCIES_UPDATE_PREDICATE, Entities.Scope.SYSTEM);
        this.presentPredicateId = entities.put((Value)PLUGIN_PRESENT_PREDICATE, Entities.Scope.SYSTEM);
        this.dataChangedPredicateId = entities.put((Value)PLUGIN_DATA_CHANGED_PREDICATE, Entities.Scope.SYSTEM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean buildDependenciesGraph(PluginConnection pluginConnection, long context) {
        Statements statements = pluginConnection.getStatements();
        String stringContext = this.longContextToIRI(pluginConnection.getEntities(), context);
        if (this.getStatus(stringContext) == Status.IN_PROGRESS) {
            return false;
        }
        String contextDescription = stringContext != null ? stringContext : "all graphs";
        LOGGER.info("Start building dependency graph for {}", (Object)contextDescription);
        this.setStatus(stringContext, Status.IN_PROGRESS);
        long l = System.currentTimeMillis();
        TLongObjectHashMap dependenciesGraph = new TLongObjectHashMap();
        TLongObjectHashMap dependenciesPredicatesCount = new TLongObjectHashMap();
        long realContext = this.requestContextToRealContext(pluginConnection.getEntities(), context);
        try (StatementIterator st = statements.get(0L, 0L, 0L, realContext);){
            while (st.next()) {
                long subject = st.subject;
                long object = st.object;
                this.countStatement((TLongObjectHashMap<TLongLongHashMap>)dependenciesGraph, (TLongObjectHashMap<TLongObjectHashMap<TLongLongHashMap>>)dependenciesPredicatesCount, pluginConnection, subject, st.predicate, object, realContext, true);
            }
            this.setStatus(stringContext, Status.READY);
            this.setDependenciesGraph(stringContext, (TLongObjectHashMap<TLongLongHashMap>)dependenciesGraph);
            this.setGraphFingerprint(stringContext, pluginConnection.getFingerprint());
            this.setDependenciesPredicatesCount(stringContext, (TLongObjectHashMap<TLongObjectHashMap<TLongLongHashMap>>)dependenciesPredicatesCount);
            this.storeInCache();
            LOGGER.info("Finished building dependency graph for {}: {}", (Object)contextDescription, (Object)((System.currentTimeMillis() - l) / 1000L));
            boolean subject = true;
            return subject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void countStatement(TLongObjectHashMap<TLongLongHashMap> dependenciesGraph, TLongObjectHashMap<TLongObjectHashMap<TLongLongHashMap>> dependenciesPredicatesCount, PluginConnection pluginConnection, long subject, long predicate, long object, long context, boolean increment) {
        Statements statements = pluginConnection.getStatements();
        Entities entities = pluginConnection.getEntities();
        StatementIterator subjectDirectTypes = statements.get(subject, this.typePredicate, 0L, context);
        StatementIterator objectDirectTypes = statements.get(object, this.typePredicate, 0L, context);
        try {
            while (subjectDirectTypes.next()) {
                long subjectType;
                if (!subjectDirectTypes.isExplicit() || this.shouldIgnore(entities, subjectType = subjectDirectTypes.object)) continue;
                while (objectDirectTypes.next()) {
                    long objectType;
                    if (!objectDirectTypes.isExplicit() || this.shouldIgnore(entities, objectType = objectDirectTypes.object)) continue;
                    this.incrementEdgeCount(dependenciesGraph, dependenciesPredicatesCount, subjectType, objectType, predicate, increment);
                }
            }
        }
        finally {
            subjectDirectTypes.close();
            objectDirectTypes.close();
        }
    }

    private boolean shouldIgnore(Entities entities, long classEntityId) {
        Value value = entities.get(classEntityId);
        if (!(value instanceof IRI)) {
            return true;
        }
        String classEntity = value.stringValue();
        return classEntity.startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#") || classEntity.startsWith("http://www.w3.org/2000/01/rdf-schema#") || classEntity.startsWith("http://www.w3.org/2002/07/owl#");
    }

    private void incrementEdgeCount(TLongObjectHashMap<TLongLongHashMap> dependenciesGraph, TLongObjectHashMap<TLongObjectHashMap<TLongLongHashMap>> dependenciesPredicatesCount, long subjectType, long objectType, long predicate, boolean increment) {
        if (!dependenciesGraph.containsKey(subjectType)) {
            dependenciesGraph.put(subjectType, (Object)new TLongLongHashMap());
        }
        if (!dependenciesPredicatesCount.containsKey(subjectType)) {
            dependenciesPredicatesCount.put(subjectType, (Object)new TLongObjectHashMap());
        }
        if (!((TLongObjectHashMap)dependenciesPredicatesCount.get(subjectType)).containsKey(objectType)) {
            ((TLongObjectHashMap)dependenciesPredicatesCount.get(subjectType)).put(objectType, (Object)new TLongLongHashMap());
        }
        TLongLongHashMap edgesCount = (TLongLongHashMap)dependenciesGraph.get(subjectType);
        long predicateCount = ((TLongLongHashMap)((TLongObjectHashMap)dependenciesPredicatesCount.get(subjectType)).get(objectType)).get(predicate);
        long currentCount = edgesCount.get(objectType);
        if (increment) {
            ++currentCount;
            ++predicateCount;
        } else {
            --currentCount;
            --predicateCount;
        }
        edgesCount.put(objectType, currentCount);
        ((TLongLongHashMap)((TLongObjectHashMap)dependenciesPredicatesCount.get(subjectType)).get(objectType)).put(predicate, predicateCount);
    }

    public double estimate(long subject, long predicate, long object, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        if (predicate == this.getDependenciesId) {
            return 0.1;
        }
        if (predicate == this.toPredicateId || predicate == this.countPredicateId) {
            return 0.2;
        }
        if (predicate == this.listDependencyPredicates) {
            return 0.1;
        }
        if (predicate == this.listPredicatesFrom || predicate == this.listPredicatesTo || predicate == this.listPredicateCount || predicate == this.listPredicate) {
            return 0.1;
        }
        return 0.0;
    }

    public StatementIterator interpret(long subject, long predicate, long object, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        if (predicate == this.presentPredicateId) {
            return StatementIterator.TRUE();
        }
        if (predicate == this.dataChangedPredicateId) {
            return this.isFingerprintChanged(this.longContextToIRI(pluginConnection.getEntities(), context), pluginConnection.getFingerprint()) ? StatementIterator.TRUE() : StatementIterator.FALSE();
        }
        if (predicate == this.statusPredicateId) {
            long statusRequestEntity = pluginConnection.getEntities().put((Value)VF.createLiteral(this.getStatus(this.longContextToIRI(pluginConnection.getEntities(), context)).name()), Entities.Scope.REQUEST);
            return StatementIterator.create((long)subject, (long)predicate, (long)statusRequestEntity, (long)context);
        }
        if (predicate == this.updatePredicateId) {
            if (this.buildDependenciesGraph(pluginConnection, context)) {
                return StatementIterator.TRUE();
            }
            return StatementIterator.FALSE();
        }
        DependenciesRequestContext drc = (DependenciesRequestContext)requestContext;
        if (predicate == this.getDependenciesId) {
            DependenciesMainIterator dependenciesIterator = new DependenciesMainIterator(this, pluginConnection.getEntities(), subject, predicate, object, context);
            drc.addIterator(dependenciesIterator);
            return dependenciesIterator;
        }
        if (predicate == this.toPredicateId) {
            DependenciesToIIterator dependenciesToIIterator = new DependenciesToIIterator();
            dependenciesToIIterator.setSPO(subject, predicate, object);
            DependenciesMainIterator dmi = drc.getDependencyIterator(subject);
            dependenciesToIIterator.setDependenciesMainIterator(dmi, pluginConnection.getEntities());
            return dependenciesToIIterator;
        }
        if (predicate == this.countPredicateId) {
            DependenciesWeightIterator dependenciesWeightIterator = new DependenciesWeightIterator();
            dependenciesWeightIterator.setSPO(subject, predicate, object);
            DependenciesMainIterator dmi = drc.getDependencyIterator(subject);
            dependenciesWeightIterator.setDependenciesMainIterator(dmi, pluginConnection.getEntities());
            return dependenciesWeightIterator;
        }
        if (predicate == this.listDependencyPredicates) {
            DependencyPredicatesMainIterator dependencyPredicatesMainIterator = new DependencyPredicatesMainIterator(this, pluginConnection.getEntities(), subject, predicate, object, context);
            drc.addIterator(dependencyPredicatesMainIterator);
            return dependencyPredicatesMainIterator;
        }
        if (predicate == this.listPredicatesFrom) {
            return new DependencyPredicatesFromIterator(drc.getDependencyPredicateIterator(subject), subject, predicate, object);
        }
        if (predicate == this.listPredicatesTo) {
            return new DependencyPredicatesToIterator(drc.getDependencyPredicateIterator(subject), subject, predicate, object);
        }
        if (predicate == this.listPredicate) {
            return new DependencyPredicatesPredicateIterator(drc.getDependencyPredicateIterator(subject), subject, predicate, object);
        }
        if (predicate == this.listPredicateCount) {
            return new DependencyPredicatesCountIterator(drc.getDependencyPredicateIterator(subject), subject, predicate, object);
        }
        return null;
    }

    public RequestContext preprocess(Request request) {
        return new DependenciesRequestContext(request);
    }

    public synchronized TLongObjectHashMap<TLongLongHashMap> getDependenciesGraph(String context) {
        return this.dependenciesGraphs.getOrDefault(context, (TLongObjectHashMap<TLongLongHashMap>)new TLongObjectHashMap());
    }

    public synchronized void setDependenciesGraph(String context, TLongObjectHashMap<TLongLongHashMap> dependenciesGraph) {
        this.dependenciesGraphs.put(context, dependenciesGraph);
    }

    public synchronized TLongObjectHashMap<TLongObjectHashMap<TLongLongHashMap>> getDependenciesPredicatesCount(String context) {
        return this.dependenciesPredicatesCounts.getOrDefault(context, (TLongObjectHashMap<TLongObjectHashMap<TLongLongHashMap>>)new TLongObjectHashMap());
    }

    public synchronized void setDependenciesPredicatesCount(String context, TLongObjectHashMap<TLongObjectHashMap<TLongLongHashMap>> dependenciesPredicatesCount) {
        this.dependenciesPredicatesCounts.put(context, dependenciesPredicatesCount);
    }

    public Status getStatus(String context) {
        return this.statuses.getOrDefault(context, Status.NONE);
    }

    public void setStatus(String context, Status status) {
        this.statuses.put(context, status);
    }

    public String longContextToIRI(Entities entities, long context) {
        return context == 0L ? null : entities.get(context).stringValue();
    }

    public long requestContextToRealContext(Entities entities, long context) {
        if (context != 0L && entities.get(context).equals(SESAME.NIL)) {
            return -3L;
        }
        return context;
    }

    private void setGraphFingerprint(String stringContext, String currentFingerprint) {
        this.graphsFingerprints.put(stringContext, currentFingerprint);
    }

    private boolean isFingerprintChanged(String stringContext, String latestFingerprint) {
        if (this.graphsFingerprints.containsKey(stringContext)) {
            return !this.graphsFingerprints.get(stringContext).equals(latestFingerprint);
        }
        return true;
    }

    private static enum Status {
        NONE,
        IN_PROGRESS,
        READY;

    }
}

