/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.impex;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.ontotext.forest.core.GraphDBMultipartFile;
import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.proxy.ProxyToRemoteSesame;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.forest.core.semantic.repository.SemanticRepository;
import com.ontotext.forest.core.util.ResourceUtils;
import com.ontotext.forest.impex.ExecutorProvider;
import com.ontotext.forest.impex.FileTasksExecutor;
import com.ontotext.forest.impex.ImportFileLister;
import com.ontotext.forest.impex.ImportSettings;
import com.ontotext.forest.impex.ImportStatusService;
import com.ontotext.forest.impex.ImportTasksExecutor;
import com.ontotext.forest.impex.ServerImportBody;
import com.ontotext.forest.impex.StringTasksExecutor;
import com.ontotext.forest.impex.URLTasksExecutor;
import com.ontotext.forest.impex.UserFileTasksExecutor;
import com.ontotext.forest.security.utils.SecurityUtils;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParserRegistry;
import org.eclipse.rdf4j.rio.Rio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/rest/repositories/{repositoryID}/import"})
@Controller
@Tag(name="Data Import", description="Manage data import operations")
public class ImportController {
    public static final String BASE_URL = "/rest/repositories/{repositoryID}/import";
    private static final String IMPORT_DIRECTORY_PROPERTY = "graphdb.workbench.importDirectory";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final Multimap<String, String> subTasks = ArrayListMultimap.create();
    @Autowired
    private SemanticDataManagement dataManagement;
    @Autowired
    private ResourceUtils resourceUtils;
    @Autowired
    private ExecutorProvider executorProvider;
    @Autowired
    private FileTasksExecutor fileImportExecutor;
    @Autowired
    private UserFileTasksExecutor fileUploadExecutor;
    @Autowired
    private StringTasksExecutor stringTaskExecutor;
    @Autowired
    private URLTasksExecutor urlTasksExecutor;
    @Autowired
    private ProxyToRemoteSesame proxyToRemoteSesame;

    private String getImportDirectory() {
        return (String)this.resourceUtils.getNewOrDeprecatedProperty(IMPORT_DIRECTORY_PROPERTY, "impex.dir");
    }

    @Operation(summary="Import a server file into the repository", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @RequestMapping(value={"/server"}, method={RequestMethod.POST})
    public ResponseEntity<String> importServerFile(@PathVariable(value="repositoryID") String repositoryID, @RequestBody ServerImportBody importBody, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SemanticLocation location = this.dataManagement.getLocationFromHeaderOrThrow();
        SemanticRepository repo = this.getRepository(repositoryID, location, request);
        if (importBody == null) {
            importBody = new ServerImportBody();
        }
        String[] fileNames = importBody.getFileNames();
        File[] importFiles = new File[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            importFiles[i] = new File(this.getImportDirectory(), fileNames[i]);
            if (!importFiles[i].exists()) {
                return new ResponseEntity((Object)String.format("File %s does not exist", fileNames[i]), (HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            if (importFiles[i].isDirectory()) {
                this.collectSubtasks(importFiles[i], repositoryID);
            }
            if (!subTasks.containsValue((Object)fileNames[i])) continue;
            subTasks.values().remove(fileNames[i]);
        }
        RDFFormat[] fileFormats = new RDFFormat[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            fileFormats[i] = this.getRdfFormat(fileNames[i], null);
        }
        String[] submitResults = new String[fileNames.length];
        ImportSettings imprStngs = importBody.getImportSettings();
        return (ResponseEntity)this.proxyToRemoteSesame.proxyWithBodyToRemoteIfNeeded((Object)importBody, request, response, location, () -> {
            for (int i = 0; i < fileNames.length; ++i) {
                try {
                    ResponseEntity<String> submitResult;
                    ImportSettings settings = imprStngs != null ? imprStngs.forName(fileNames[i]) : this.fileImportExecutor.getStatusService().getImportInfo(repositoryID, fileNames[i]);
                    if (settings.getBaseURI() == null) {
                        settings.setBaseURI(importFiles[i].toURI().toString());
                    }
                    if ((submitResult = this.fileImportExecutor.submitTask(repo, location.isLocal(), importFiles[i], fileNames[i], fileFormats[i], settings)).getStatusCode().equals((Object)HttpStatus.BAD_REQUEST)) {
                        this.logger.warn("Task was not submitted for import {}", submitResult.getBody());
                    }
                    submitResults[i] = (String)submitResult.getBody();
                    continue;
                }
                catch (RuntimeException ise) {
                    return new ResponseEntity((Object)ise.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
            return new ResponseEntity((Object)String.join((CharSequence)";", submitResults), (HttpStatusCode)HttpStatus.ACCEPTED);
        });
    }

    private SemanticRepository getRepository(String repository, SemanticLocation location, HttpServletRequest request) {
        if (StringUtils.isEmpty((CharSequence)request.getHeader("X-GraphDB-Proxied-From"))) {
            return SecurityUtils.getRepositoryWithSecurityCheck((String)repository, (SemanticLocation)location, (boolean)true);
        }
        return location.getRepository(repository);
    }

    private RDFFormat getRdfFormat(String fileName, String dataFormat) throws GraphDBWorkbenchException {
        Optional fileFormat = !StringUtils.isEmpty((CharSequence)dataFormat) ? RDFParserRegistry.getInstance().getFileFormatForMIMEType(dataFormat) : RDFParserRegistry.getInstance().getFileFormatForFileName(fileName);
        return fileFormat.isPresent() ? (RDFFormat)fileFormat.get() : null;
    }

    private void collectSubtasks(File dir, String repositoryID) throws IOException {
        Path importDirectory = Paths.get(this.getImportDirectory(), new String[0]);
        Set<Path> paths = ImportFileLister.listRDFFiles(dir.toPath(), true).keySet();
        for (Path path : paths) {
            String fileName = importDirectory.relativize(path).toString();
            if (subTasks.containsValue((Object)fileName)) continue;
            subTasks.put((Object)repositoryID, (Object)fileName);
        }
    }

    @Operation(summary="Cancel server file import operation", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="400", description="Bad request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content})})
    @RequestMapping(value={"/server"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> interruptServerImport(@PathVariable(value="repositoryID") String repositoryID, @RequestParam(value="name") @Parameter(description="The filename import to interrupt.") String name, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(request, response, this.dataManagement.getLocationFromHeaderOrThrow(), () -> this.fileImportExecutor.interruptTask(repositoryID, name));
    }

    @Operation(summary="Get server files available for import", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ImportSettings.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content})})
    @RequestMapping(value={"/server"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<List<ImportSettings>> listServerFiles(@PathVariable(value="repositoryID") String repositoryID, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(request, response, this.dataManagement.getLocationFromHeaderOrThrow(), () -> {
            List<ImportSettings> localPaths = this.getImportSettingsForServerFiles(repositoryID);
            return new ResponseEntity(localPaths, (HttpStatusCode)HttpStatus.OK);
        });
    }

    @Hidden
    @RequestMapping(value={"/server/status"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> deleteServerStatus(@PathVariable(value="repositoryID") String repositoryID, @RequestBody List<String> names, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyWithBodyToRemoteIfNeeded(names, request, response, this.dataManagement.getLocationFromHeaderOrThrow(), () -> this.removeOrResetStatus(this.fileImportExecutor, repositoryID, names, false));
    }

    private List<ImportSettings> getImportSettingsForServerFiles(String repositoryString) throws IOException {
        Path importDirectory = Paths.get(this.getImportDirectory(), new String[0]);
        Set<Path> rdfFiles = ImportFileLister.listRDFFiles(importDirectory, true).keySet();
        return rdfFiles.stream().map(p -> {
            ImportStatusService importStatusService = this.fileImportExecutor.getStatusService();
            String fileName = importDirectory.relativize((Path)p).toString();
            ImportSettings s = importStatusService.getImportInfo(repositoryString, fileName);
            if (subTasks.containsValue((Object)fileName)) {
                s.setAddedRemovedStatements(0L);
            }
            if (Files.isDirectory(p, new LinkOption[0])) {
                s.setType("directory");
                ImportStatusService.DirectoryImportInfo directoryImportInfo = new ImportStatusService.DirectoryImportInfo();
                try {
                    directoryImportInfo.setDirectoryImportInfo((Path)p);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                s.setFileSize(directoryImportInfo.getSize());
                s.setLastModified(directoryImportInfo.getLastModifiedTime());
            } else {
                s.setType("file");
                s.setFileSize(p.toFile());
                s.setFileLastModified(p.toFile());
            }
            return s;
        }).collect(Collectors.toList());
    }

    @Hidden
    @RequestMapping(value={"/upload/file"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    public ResponseEntity<String> importFileUpload(@PathVariable(value="repositoryID") String repositoryID, @RequestPart(value="importSettings") ImportSettings importSettings, @RequestPart(value="file", required=false) MultipartFile file, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(request, response, this.dataManagement.getLocationFromHeaderOrThrow(), () -> this.fileUpload(repositoryID, importSettings, file, true, request));
    }

    @Hidden
    @RequestMapping(value={"/upload/update/file"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    public ResponseEntity<String> modifyFileUpload(@PathVariable(value="repositoryID") String repositoryID, @RequestPart(value="importSettings") ImportSettings importSettings, @RequestPart(value="file", required=false) MultipartFile file, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(request, response, this.dataManagement.getLocationFromHeaderOrThrow(), () -> this.fileUpload(repositoryID, importSettings, file, false, request));
    }

    private ResponseEntity<String> fileUpload(String repository, ImportSettings importSettings, MultipartFile file, boolean startImport, HttpServletRequest request) throws GraphDBWorkbenchException {
        File fileToImport;
        String fileName = importSettings.getName();
        importSettings.setType("file");
        try {
            this.fileUploadExecutor.createUplodadeFilesDirectory();
            ImportSettings savedSettings = this.fileUploadExecutor.getStatusService().getImportInfo(repository, fileName);
            if (file != null) {
                if (savedSettings.getData() != null) {
                    File previousFile = this.fileUploadExecutor.getPathForFilename(savedSettings.getData()).toFile();
                    Files.deleteIfExists(previousFile.toPath());
                }
                String serverFilename = this.fileUploadExecutor.createFilename();
                importSettings.setData(serverFilename);
                fileToImport = this.fileUploadExecutor.getPathForFilename(serverFilename).toFile();
                if (file instanceof GraphDBMultipartFile) {
                    ((GraphDBMultipartFile)file).moveTo(fileToImport);
                } else {
                    file.transferTo(fileToImport);
                }
            } else {
                importSettings.setData(savedSettings.getData());
                fileToImport = this.fileUploadExecutor.getPathForFilename(savedSettings.getData()).toFile();
            }
            importSettings.setFileSize(fileToImport);
            importSettings.setFileLastModified(fileToImport);
        }
        catch (IOException e) {
            throw new GraphDBWorkbenchException("Cannot save uploaded file.", (Throwable)e);
        }
        RDFFormat fileFormat = this.getRdfFormat(fileName, null);
        if (startImport && StringUtils.isEmpty((CharSequence)importSettings.getBaseURI())) {
            importSettings.setBaseURI("file:/uploaded/generated/" + fileName);
        }
        try {
            SemanticLocation location = this.dataManagement.getLocationFromHeaderOrThrow();
            SemanticRepository repo = this.getRepository(repository, location, request);
            if (startImport) {
                return this.fileUploadExecutor.submitTask(repo, location.isLocal(), fileToImport, fileName, fileFormat, importSettings);
            }
            this.fileUploadExecutor.getStatusService().saveImportFile(repository, importSettings);
            return new ResponseEntity((Object)"Task updated.", (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return new ResponseEntity((Object)("File not loaded; " + e.getMessage()), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Hidden
    @RequestMapping(value={"/upload"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> interruptUpload(@PathVariable(value="repositoryID") String repositoryID, @RequestParam(name="type", defaultValue="file") String type, @RequestParam(value="name") String name, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(request, response, this.dataManagement.getLocationFromHeaderOrThrow(), () -> {
            switch (type) {
                case "file": 
                case "directory": {
                    return this.fileUploadExecutor.interruptTask(repositoryID, name);
                }
                case "url": {
                    return this.urlTasksExecutor.interruptTask(repositoryID, name);
                }
                case "text": {
                    return this.stringTaskExecutor.interruptTask(repositoryID, name);
                }
            }
            throw new GraphDBWorkbenchException("Unknown type: " + type);
        });
    }

    @Hidden
    @RequestMapping(value={"/upload/text"}, method={RequestMethod.POST})
    public ResponseEntity<String> importTextUpload(@PathVariable(value="repositoryID") String repositoryID, @RequestBody ImportSettings importSettings, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.textUpload(repositoryID, importSettings, true, request, response);
    }

    @Hidden
    @RequestMapping(value={"/upload/update/text"}, method={RequestMethod.POST})
    public ResponseEntity<String> modifyTextImport(@PathVariable(value="repositoryID") String repositoryID, @RequestBody ImportSettings importSettings, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.textUpload(repositoryID, importSettings, false, request, response);
    }

    private ResponseEntity<String> textUpload(String repository, ImportSettings importSettings, boolean startImport, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SemanticLocation location = this.dataManagement.getLocationFromHeaderOrThrow();
        SemanticRepository repo = this.getRepository(repository, location, request);
        return (ResponseEntity)this.proxyToRemoteSesame.proxyWithBodyToRemoteIfNeeded((Object)importSettings, request, response, location, () -> {
            RDFFormat fileFormat = (RDFFormat)Rio.getParserFormatForMIMEType((String)importSettings.getFormat()).orElseThrow(() -> new GraphDBWorkbenchException("Unsupported format: " + importSettings.getFormat()));
            if (startImport && StringUtils.isEmpty((CharSequence)importSettings.getBaseURI())) {
                importSettings.setBaseURI("file:/snippet/generated/" + String.valueOf(UUID.randomUUID()));
            }
            importSettings.setType("text");
            try {
                importSettings.setURLTEXTLastModified();
                if (startImport) {
                    return this.stringTaskExecutor.submitTask(repo, location.isLocal(), importSettings.getData(), importSettings.getName(), fileFormat, importSettings);
                }
                this.stringTaskExecutor.getStatusService().save(repository, importSettings);
                return new ResponseEntity((Object)"Task updated.", (HttpStatusCode)HttpStatus.OK);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                return new ResponseEntity((Object)("Could not update task; " + e.getMessage()), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        });
    }

    @Hidden
    @RequestMapping(value={"/upload"}, method={RequestMethod.GET})
    public ResponseEntity<List<ImportSettings>> getUploadItems(@PathVariable(value="repositoryID") String repositoryID, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(request, response, this.dataManagement.getLocationFromHeaderOrThrow(), () -> new ResponseEntity(this.fileUploadExecutor.getStatusService().getAllForRepositorySortedByAge(repositoryID), (HttpStatusCode)HttpStatus.OK));
    }

    @Hidden
    @RequestMapping(value={"/upload/status"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> deleteUploadStatus(@PathVariable(value="repositoryID") String repositoryID, @RequestBody List<String> names, @RequestParam(value="remove", required=false, defaultValue="false") boolean remove, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyWithBodyToRemoteIfNeeded(names, request, response, this.dataManagement.getLocationFromHeaderOrThrow(), () -> this.removeOrResetStatus(this.fileUploadExecutor, repositoryID, names, remove));
    }

    @Operation(summary="Import from data URL into the repository", hidden=true)
    @RequestMapping(value={"/upload/url"}, method={RequestMethod.POST})
    public ResponseEntity<String> importUrlUpload(@PathVariable(value="repositoryID") String repositoryID, @RequestBody ImportSettings importSettings, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyWithBodyToRemoteIfNeeded((Object)importSettings, request, response, this.dataManagement.getLocationFromHeaderOrThrow(), () -> this.urlUpload(repositoryID, importSettings, true, request));
    }

    @Hidden
    @RequestMapping(value={"/upload/update/url"}, method={RequestMethod.POST})
    public ResponseEntity<String> modifyUrlUpload(@PathVariable String repositoryID, @RequestBody ImportSettings importSettings, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyWithBodyToRemoteIfNeeded((Object)importSettings, request, response, this.dataManagement.getLocationFromHeaderOrThrow(), () -> this.urlUpload(repositoryID, importSettings, false, request));
    }

    private ResponseEntity<String> urlUpload(String repository, ImportSettings importSettings, boolean startImport, HttpServletRequest request) throws GraphDBWorkbenchException {
        URL validUrl;
        String url = importSettings.getData();
        try {
            validUrl = new URL(importSettings.getData());
        }
        catch (MalformedURLException e) {
            return new ResponseEntity((Object)("Not a valid url: " + url + " reason: " + e.getMessage()), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        RDFFormat fileFormat = this.getRdfFormat(url, importSettings.getFormat());
        importSettings.setType("url");
        try {
            importSettings.setURLTEXTLastModified();
            if (startImport) {
                SemanticLocation location = this.dataManagement.getLocationFromHeaderOrThrow();
                SemanticRepository repo = this.getRepository(repository, location, request);
                if (importSettings.getName() == null) {
                    importSettings.setName(importSettings.getData());
                }
                return this.urlTasksExecutor.submitTask(repo, location.isLocal(), validUrl, importSettings.getName(), fileFormat, importSettings);
            }
            this.urlTasksExecutor.getStatusService().save(repository, importSettings);
            return new ResponseEntity((Object)"Task updated.", (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return new ResponseEntity((Object)("Could not update task; " + e.getMessage()), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Hidden
    @RequestMapping(value={"/settings/default"}, method={RequestMethod.GET})
    public ResponseEntity<ImportSettings> getDefaultSettings(@PathVariable(value="repositoryID", required=false) String repositoryID) {
        return new ResponseEntity((Object)new ImportSettings(), (HttpStatusCode)HttpStatus.OK);
    }

    @Hidden
    @RequestMapping(value={"/active"}, method={RequestMethod.GET})
    public ResponseEntity<Long> getNumberOfActiveImports(@PathVariable(value="repositoryID") String repository, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(request, response, this.dataManagement.getLocationFromHeaderOrThrow(), () -> ResponseEntity.ok((Object)this.executorProvider.getNumberOfTasks(repository)));
    }

    private ResponseEntity<String> removeOrResetStatus(ImportTasksExecutor tasksExecutor, String repository, List<String> statusNames, boolean remove) throws IOException {
        for (String statusName : statusNames) {
            if (remove) {
                tasksExecutor.removeEntry(repository, statusName);
                continue;
            }
            tasksExecutor.resetStatus(repository, statusName, this.getImportDirectory());
        }
        return new ResponseEntity((Object)"Cleared status.", (HttpStatusCode)HttpStatus.OK);
    }
}

