/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.impex;

import com.ontotext.forest.impex.ImportTasksExecutor;
import common.GraphDBMDCExecutorBuilder;
import jakarta.annotation.PostConstruct;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.stereotype.Component;

@Component
public class ExecutorProvider {
    private static long TEN_MINUTES_IN_MS = 600000L;
    private final Map<String, ExecutorService> executors = new ConcurrentHashMap<String, ExecutorService>();
    private Map<String, Long> executorLastUsed = new ConcurrentHashMap<String, Long>();

    @PostConstruct
    public void initCleanupPools() {
        Thread cleanupThread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(TEN_MINUTES_IN_MS);
                        Map<String, ExecutorService> map = this.executors;
                        synchronized (map) {
                            long time = System.currentTimeMillis();
                            this.executorLastUsed.entrySet().removeIf(p -> {
                                boolean expired;
                                String repository = (String)p.getKey();
                                long lastUsed = (Long)p.getValue();
                                boolean bl = expired = time - lastUsed > TEN_MINUTES_IN_MS && this.getNumberOfTasks(repository) == 0L;
                                if (expired) {
                                    this.executors.remove(repository);
                                }
                                return expired;
                            });
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        });
        cleanupThread.setDaemon(true);
        cleanupThread.setName("Import cleanup thread");
        cleanupThread.start();
    }

    public synchronized Future<?> submit(String repository, Runnable task) {
        ExecutorService executor = this.executors.computeIfAbsent(repository, r -> GraphDBMDCExecutorBuilder.build((ExecutorService)Executors.newFixedThreadPool(1, new ImportTasksExecutor.DaemonThreadFactory((String)r))));
        this.executorLastUsed.put(repository, System.currentTimeMillis());
        return executor.submit(task);
    }

    public long getNumberOfTasks(String repository) {
        ExecutorService delegate;
        ThreadPoolExecutor threadPoolExecutor = null;
        ExecutorService executor = this.executors.get(repository);
        if (executor instanceof ThreadPoolExecutor) {
            threadPoolExecutor = (ThreadPoolExecutor)executor;
        } else if (executor instanceof GraphDBMDCExecutorBuilder.GraphDBMDCExecutorService && (delegate = ((GraphDBMDCExecutorBuilder.GraphDBMDCExecutorService)executor).getDelegate()) instanceof ThreadPoolExecutor) {
            threadPoolExecutor = (ThreadPoolExecutor)delegate;
        }
        if (threadPoolExecutor == null) {
            return 0L;
        }
        return threadPoolExecutor.getActiveCount() + threadPoolExecutor.getQueue().size();
    }
}

