/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.uri;

import com.apicatalog.jsonld.StringUtils;
import com.apicatalog.jsonld.lang.Keywords;
import com.apicatalog.jsonld.uri.PartiallyImplementedUriValidator;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class UriUtils {
    private static final Map<String, URI> COMMON_CONSTANTS = new HashMap<String, URI>();

    private UriUtils() {
    }

    public static boolean isURI(String value) {
        return StringUtils.isNotBlank(value) && !Keywords.matchForm(StringUtils.strip(value)) && UriUtils.isValid(StringUtils.strip(value));
    }

    private static boolean isValid(String uriString) {
        if (uriString == null) {
            throw new IllegalArgumentException("The uri cannot be null.");
        }
        Object uriValue = StringUtils.strip(uriString);
        if (((String)uriValue).isEmpty()) {
            return false;
        }
        if (((String)uriValue).endsWith(":")) {
            uriValue = (String)uriValue + ".";
        } else if (((String)uriValue).endsWith("[") || ((String)uriValue).endsWith("]")) {
            uriValue = ((String)uriValue).substring(0, ((String)uriValue).length() - 1);
        }
        try {
            if (PartiallyImplementedUriValidator.isDefinitivelyValidAbsoluteUri((String)uriValue)) {
                return true;
            }
            return UriUtils.getUriWithCache((String)uriValue) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static URI create(String uriString) {
        if (uriString == null) {
            throw new IllegalArgumentException("The uri cannot be null.");
        }
        Object uriValue = StringUtils.strip(uriString);
        if (((String)uriValue).isEmpty()) {
            return null;
        }
        if (((String)uriValue).endsWith(":")) {
            uriValue = (String)uriValue + ".";
        } else if (((String)uriValue).endsWith("[") || ((String)uriValue).endsWith("]")) {
            uriValue = ((String)uriValue).substring(0, ((String)uriValue).length() - 1);
        }
        try {
            return UriUtils.getUriWithCache((String)uriValue);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static boolean endsWithGenDelim(String uri) {
        return uri.endsWith(":") || uri.endsWith("/") || uri.endsWith("?") || uri.endsWith("#") || uri.endsWith("[") || uri.endsWith("]") || uri.endsWith("@");
    }

    public static boolean isNotURI(String uri) {
        return uri == null || StringUtils.isBlank(uri) || Keywords.matchForm(StringUtils.strip(uri)) || !UriUtils.isValid(StringUtils.strip(uri));
    }

    @Deprecated
    public static boolean isNotAbsoluteUri(String uri) {
        return UriUtils.isNotAbsoluteUri(uri, true);
    }

    public static boolean isNotAbsoluteUri(String uri, boolean validate) {
        return !UriUtils.isAbsoluteUri(uri, validate);
    }

    @Deprecated
    public static boolean isAbsoluteUri(String uri) {
        return UriUtils.isAbsoluteUri(uri, true);
    }

    public static boolean isAbsoluteUri(String uri, boolean validate) {
        if (!validate) {
            return UriUtils.startsWithScheme(uri);
        }
        if (uri == null || uri.length() < 3) {
            return false;
        }
        try {
            if (PartiallyImplementedUriValidator.isDefinitivelyValidAbsoluteUri(uri)) {
                return true;
            }
            return UriUtils.getUriWithCache(uri).isAbsolute();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static URI getUriWithCache(String uriString) {
        URI commonUri = COMMON_CONSTANTS.get(uriString);
        if (commonUri != null) {
            return commonUri;
        }
        return URI.create(uriString);
    }

    private static boolean startsWithScheme(String uri) {
        if (uri == null || uri.length() < 2 || !Character.isLetter(uri.codePointAt(0))) {
            return false;
        }
        for (int i = 1; i < uri.length(); ++i) {
            if (Character.isLetterOrDigit(uri.codePointAt(i)) || uri.charAt(i) == '-' || uri.charAt(i) == '+' || uri.charAt(i) == '.') continue;
            return uri.charAt(i) == ':';
        }
        return false;
    }

    protected static String recompose(String scheme, String authority, String path, String query, String fragment) {
        boolean includeFragment;
        boolean includeQuery;
        boolean includePath;
        boolean includeAuthority;
        boolean includeScheme = UriUtils.isDefined(scheme);
        String result = UriUtils.recomposeCommonCases(scheme, authority, path, query, fragment, includeScheme, includeAuthority = authority != null, includePath = UriUtils.isDefined(path), includeQuery = UriUtils.isDefined(query), includeFragment = UriUtils.isDefined(fragment));
        if (result != null) {
            return result;
        }
        return UriUtils.recomposeAllCases(scheme, authority, path, query, fragment, includeScheme, includeAuthority, includePath, includeQuery, includeFragment);
    }

    private static String recomposeAllCases(String scheme, String authority, String path, String query, String fragment, boolean includeScheme, boolean includeAuthority, boolean includePath, boolean includeQuery, boolean includeFragment) {
        StringBuilder builder = new StringBuilder();
        if (includeScheme) {
            builder.append(scheme);
            builder.append(":");
        }
        if (includeAuthority) {
            builder.append("//");
            builder.append(authority);
        }
        if (includePath) {
            builder.append(path);
        }
        if (includeQuery) {
            builder.append('?');
            builder.append(query);
        }
        if (includeFragment) {
            builder.append('#');
            builder.append(fragment);
        }
        return builder.toString();
    }

    private static String recomposeCommonCases(String scheme, String authority, String path, String query, String fragment, boolean includeScheme, boolean includeAuthority, boolean includePath, boolean includeQuery, boolean includeFragment) {
        if (!(!includeScheme || includeAuthority || includePath || includeQuery || includeFragment)) {
            return scheme + ":";
        }
        if (includeScheme && includeAuthority && !includePath && !includeQuery && !includeFragment) {
            return scheme + "://" + authority;
        }
        if (includeScheme && !includeAuthority && includePath && !includeQuery && !includeFragment) {
            return scheme + ":" + path;
        }
        if (includeScheme && includeAuthority && includePath && !includeQuery && !includeFragment) {
            return scheme + "://" + authority + path;
        }
        if (includeScheme && includeAuthority && includePath && !includeQuery && includeFragment) {
            return scheme + "://" + authority + path + "#" + fragment;
        }
        if (includeScheme && includeAuthority && includePath && includeQuery && !includeFragment) {
            return scheme + "://" + authority + path + "?" + query;
        }
        if (includeScheme && includeAuthority && includePath && includeQuery && includeFragment) {
            return scheme + "://" + authority + path + "?" + query + "#" + fragment;
        }
        return null;
    }

    protected static String recompose(String path, String query, String fragment) {
        StringBuilder builder = new StringBuilder();
        if (UriUtils.isDefined(path)) {
            builder.append(path);
        }
        if (UriUtils.isDefined(query)) {
            builder.append('?');
            builder.append(query);
        }
        if (UriUtils.isDefined(fragment)) {
            builder.append('#');
            builder.append(fragment);
        }
        return builder.toString();
    }

    protected static String recompose(String query, String fragment) {
        StringBuilder builder = new StringBuilder();
        if (UriUtils.isDefined(query)) {
            builder.append('?');
            builder.append(query);
        }
        if (UriUtils.isDefined(fragment)) {
            builder.append('#');
            builder.append(fragment);
        }
        return builder.toString();
    }

    protected static String recompose(String fragment) {
        if (UriUtils.isDefined(fragment)) {
            return "#" + fragment;
        }
        return "";
    }

    protected static boolean isDefined(String value) {
        return value != null && StringUtils.isNotBlank(value);
    }

    protected static boolean isNotDefined(String value) {
        return value == null || StringUtils.isBlank(value);
    }

    static {
        List<String> uris = List.of("http://data.europa.eu/eli/ontology#", "http://publications.europa.eu/mdr/eli/index.html", "http://purl.bioontology.org/ontology/SNOMEDCT/", "http://purl.org/dc/dcmitype/", "http://purl.org/dc/elements/1.1", "http://purl.org/dc/elements/1.1/", "http://purl.org/dc/terms/", "http://purl.org/ontology/bibo/", "http://rdfs.org/ns/void#", "http://schema.org/", "http://www.w3.org/1999/02/22-rdf-syntax-ns#", "http://www.w3.org/1999/02/22-rdf-syntax-ns#HTML", "http://www.w3.org/2000/01/rdf-schema#", "http://www.w3.org/2001/XMLSchema#", "http://www.w3.org/2002/07/owl#", "http://www.w3.org/2004/02/skos/core#", "http://www.w3.org/XML/1998/namespace", "http://www.w3.org/ns/dcat#", "http://www.w3.org/ns/rdfa#", "http://xmlns.com/foaf/0.1/");
        for (String uri : uris) {
            try {
                COMMON_CONSTANTS.put(uri, URI.create(uri));
                COMMON_CONSTANTS.put(uri.substring(0, uri.length() - 1), URI.create(uri));
            }
            catch (Exception exception) {}
        }
    }
}

