/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.lang;

import com.apicatalog.jsonld.lang.LanguageTag;
import com.apicatalog.rdf.lang.RdfAlphabet;
import java.util.ArrayList;
import java.util.function.Consumer;

final class LanguageTagParser {
    final String languageTag;
    final String[] tags;
    int tagIndex;
    boolean verifierMode;

    LanguageTagParser(String languageTag, String[] tags, boolean verifierMode) {
        this.languageTag = languageTag;
        this.tags = tags;
        this.verifierMode = verifierMode;
        this.tagIndex = 0;
    }

    LanguageTagParser(String languageTag, String tags, boolean verifierMode) {
        this.languageTag = languageTag;
        this.tags = new String[]{tags};
        this.verifierMode = verifierMode;
        this.tagIndex = 0;
    }

    public static LanguageTagParser create(String languageTag) {
        return LanguageTagParser.create(languageTag, false);
    }

    public static boolean isWellFormed(String languageTag) {
        try {
            return LanguageTagParser.create(languageTag, true).parse() != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static LanguageTagParser create(String languageTag, boolean verifierMode) {
        if (languageTag == null) {
            throw new IllegalArgumentException("The parameter 'laguageTag' must not be null");
        }
        if (languageTag.isEmpty()) {
            return new LanguageTagParser(languageTag, (String[])null, verifierMode);
        }
        String stripped = languageTag.trim();
        if (stripped.isEmpty() || LanguageTagParser.doesNotStartWithAlpha(stripped) || LanguageTagParser.doesNotEndWithAlphanum(stripped)) {
            return new LanguageTagParser(languageTag, (String[])null, verifierMode);
        }
        if (stripped.contains("-")) {
            return new LanguageTagParser(languageTag, stripped.split("-"), verifierMode);
        }
        return new LanguageTagParser(languageTag, stripped, verifierMode);
    }

    private static boolean doesNotEndWithAlphanum(String stripped) {
        int ch = stripped.codePointAt(stripped.length() - 1);
        return !(97 <= ch && ch <= 122 || 65 <= ch && ch <= 90 || 48 <= ch && ch <= 57);
    }

    private static boolean doesNotStartWithAlpha(String stripped) {
        int ch = stripped.codePointAt(0);
        return !(97 <= ch && ch <= 122 || 65 <= ch && ch <= 90);
    }

    LanguageTag parse() throws IllegalArgumentException {
        if (this.tags == null || this.tags.length == 0) {
            return null;
        }
        LanguageTag tag = new LanguageTag();
        this.tagIndex = 0;
        if (this.acceptAlpha(2, 3, tag::setLanguage)) {
            if (this.acceptAlpha(3, tag::addLanguageExtension)) {
                this.acceptAlpha(3, tag::addLanguageExtension);
                this.acceptAlpha(3, tag::addLanguageExtension);
            }
        } else if (!this.acceptAlpha(4, 8, tag::setLanguage)) {
            if (this.acceptPrivateUse(tag)) {
                if (this.tagIndex != this.tags.length) {
                    throw new IllegalArgumentException("The language tag [" + this.languageTag + "] is not well-formed.");
                }
                return tag;
            }
            throw new IllegalArgumentException("The language tag [" + this.languageTag + "] is not well-formed.");
        }
        this.acceptAlpha(4, tag::setScript);
        if (!this.acceptAlpha(2, tag::setRegion)) {
            this.acceptDigit(tag::setRegion);
        }
        while (true) {
            if (this.acceptAlphaNun(5, tag::addVariant)) {
                continue;
            }
            if (!this.digitRange() || !this.alphaNumRange()) break;
            if (!this.accept(tag::addVariant)) break;
        }
        while (this.acceptDigit() || this.alphaRange() && !this.tags[this.tagIndex].equalsIgnoreCase("x") && this.accept()) {
            LanguageTag.Extension extension = new LanguageTag.Extension(this.tags[this.tagIndex - 1].charAt(0), new ArrayList<String>());
            if (!this.acceptAlphaNun(2, extension::addTag)) {
                --this.tagIndex;
                break;
            }
            while (this.acceptAlphaNun(2, extension::addTag)) {
            }
            tag.addExtension(extension);
        }
        this.acceptPrivateUse(tag);
        if (this.tagIndex != this.tags.length) {
            throw new IllegalArgumentException("The language tag [" + this.languageTag + "] is not well-formed.");
        }
        return tag;
    }

    boolean acceptPrivateUse(LanguageTag tag) {
        if (this.alphaRange() && this.tags[this.tagIndex].equalsIgnoreCase("x") && this.accept()) {
            if (!this.acceptAlphaNun(1, tag::addPrivateUse)) {
                --this.tagIndex;
            } else {
                while (this.acceptAlphaNun(1, tag::addPrivateUse)) {
                }
                return true;
            }
        }
        return false;
    }

    boolean acceptAlpha(int length, Consumer<String> consumer) {
        if (this.tagIndex < this.tags.length && this.tags[this.tagIndex].length() >= length && this.tags[this.tagIndex].length() <= length && this.allAsciiAlpha()) {
            if (!this.verifierMode && consumer != null) {
                consumer.accept(this.tags[this.tagIndex]);
            }
            ++this.tagIndex;
            return true;
        }
        return false;
    }

    private boolean allAsciiAlpha() {
        String tag = this.tags[this.tagIndex];
        for (int i = 0; i < tag.length(); ++i) {
            int ch = tag.codePointAt(i);
            if (97 <= ch && ch <= 122 || 65 <= ch && ch <= 90) continue;
            return false;
        }
        return true;
    }

    boolean acceptAlpha(int min, int max, Consumer<String> consumer) {
        if (this.tagIndex < this.tags.length && this.tags[this.tagIndex].length() >= min && this.tags[this.tagIndex].length() <= max && this.allAsciiAlpha()) {
            if (!this.verifierMode && consumer != null) {
                consumer.accept(this.tags[this.tagIndex]);
            }
            ++this.tagIndex;
            return true;
        }
        return false;
    }

    boolean acceptDigit() {
        if (this.tagIndex < this.tags.length && this.tags[this.tagIndex].length() == 1 && this.tags[this.tagIndex].chars().allMatch(RdfAlphabet.ASCII_DIGIT)) {
            ++this.tagIndex;
            return true;
        }
        return false;
    }

    boolean acceptDigit(Consumer<String> consumer) {
        if (this.tagIndex < this.tags.length && this.tags[this.tagIndex].length() == 3 && this.tags[this.tagIndex].chars().allMatch(RdfAlphabet.ASCII_DIGIT)) {
            if (!this.verifierMode && consumer != null) {
                consumer.accept(this.tags[this.tagIndex]);
            }
            ++this.tagIndex;
            return true;
        }
        return false;
    }

    boolean acceptAlphaNun(int min, Consumer<String> consumer) {
        if (this.tagIndex < this.tags.length && this.tags[this.tagIndex].length() >= min && this.tags[this.tagIndex].length() <= 8 && this.tags[this.tagIndex].chars().allMatch(RdfAlphabet.ASCII_ALPHA_NUM)) {
            if (!this.verifierMode && consumer != null) {
                consumer.accept(this.tags[this.tagIndex]);
            }
            ++this.tagIndex;
            return true;
        }
        return false;
    }

    boolean accept() {
        if (this.tagIndex < this.tags.length && this.tags[this.tagIndex].length() == 1) {
            ++this.tagIndex;
            return true;
        }
        return false;
    }

    boolean accept(Consumer<String> consumer) {
        if (this.tagIndex < this.tags.length && this.tags[this.tagIndex].length() == 4) {
            if (!this.verifierMode && consumer != null) {
                consumer.accept(this.tags[this.tagIndex]);
            }
            ++this.tagIndex;
            return true;
        }
        return false;
    }

    boolean alphaRange() {
        return this.tagIndex < this.tags.length && !this.tags[this.tagIndex].isEmpty() && this.tags[this.tagIndex].substring(0, 1).chars().allMatch(RdfAlphabet.ASCII_ALPHA);
    }

    boolean alphaNumRange() {
        return this.tagIndex < this.tags.length && 1 < this.tags[this.tagIndex].length() && 4 <= this.tags[this.tagIndex].length() && this.tags[this.tagIndex].substring(1, 4).chars().allMatch(RdfAlphabet.ASCII_ALPHA_NUM);
    }

    boolean digitRange() {
        return this.tagIndex < this.tags.length && !this.tags[this.tagIndex].isEmpty() && this.tags[this.tagIndex].substring(0, 1).chars().allMatch(RdfAlphabet.ASCII_DIGIT);
    }
}

