/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.lang;

import com.apicatalog.rdf.lang.RdfAlphabet;

public final class BlankNode {
    private BlankNode() {
    }

    public static boolean hasPrefix(String value) {
        return value.startsWith("_:");
    }

    public static boolean isWellFormed(String blankNodeId) {
        if (blankNodeId == null) {
            throw new IllegalArgumentException();
        }
        if (blankNodeId.length() < 3) {
            return false;
        }
        if (blankNodeId.codePointAt(0) != 95 || blankNodeId.codePointAt(1) != 58 || RdfAlphabet.PN_CHARS_U.negate().test(blankNodeId.codePointAt(2)) && RdfAlphabet.ASCII_DIGIT.negate().test(blankNodeId.codePointAt(2)) || blankNodeId.endsWith(".")) {
            return false;
        }
        int codePointCount = blankNodeId.codePointCount(0, blankNodeId.length());
        if (codePointCount == 3) {
            return true;
        }
        return blankNodeId.codePoints().skip(3L).limit(codePointCount - 4).allMatch(RdfAlphabet.PN_CHARS.or(ch -> ch == 46));
    }
}

