/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.context;

import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.context.InverseContext;
import java.util.Collection;
import java.util.Map;

public final class TermSelector {
    private final ActiveContext activeContext;
    private final String variable;
    private final Collection<String> containers;
    private final String typeLanguage;

    private TermSelector(ActiveContext activeContext, String variable, Collection<String> containers, String typeLanguage) {
        this.activeContext = activeContext;
        this.variable = variable;
        this.containers = containers;
        this.typeLanguage = typeLanguage;
    }

    public static TermSelector with(ActiveContext activeContext, String variable, Collection<String> containers, String typeLanguage) {
        return new TermSelector(activeContext, variable, containers, typeLanguage);
    }

    public String match(Collection<String> preferredValues) {
        if (this.activeContext.getInverseContext() == null) {
            this.activeContext.createInverseContext();
        }
        InverseContext inverseContext = this.activeContext.getInverseContext();
        for (String container : this.containers) {
            Map<String, String> map = inverseContext.getNullable(this.variable, container, this.typeLanguage);
            if (map == null) continue;
            for (String item : preferredValues) {
                String result = map.get(item);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }
}

