/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.solr;

import com.ontotext.trree.plugin.externalsync.impl.Property;
import com.ontotext.trree.plugin.externalsync.impl.solr.SolrDriver;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.ContentStreamUpdateRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.NamedList;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.json.simple.JSONObject;

class SolrSchemaGenerator {
    private final Set<String> solrLanguages = new HashSet<String>(Arrays.asList("en", "de", "es", "ru"));
    private final Set<String> existingFields = new HashSet<String>();
    private final Map<String, String> field2type = new HashMap<String, String>();
    private final SolrDriver driver;
    protected boolean schemaInitialised;
    static final BidiMap XML_TYPE_TO_SOLR_TYPE = new BidiMap(){
        {
            this.put(XSD.BOOLEAN, "boolean");
            this.put(XSD.DOUBLE, "pdouble");
            this.put(XSD.FLOAT, "pfloat");
            this.put(XSD.LONG, "plong");
            this.put(XSD.INT, "pint");
            this.put(XSD.DATETIME, "pdate");
            this.put(XSD.DATE, "pdate");
            this.put(XSD.GYEARMONTH, "pdate");
            this.put(XSD.GYEAR, "pdate");
        }
    };
    static final BidiMap XML_TYPE_TO_SOLR_TYPE_MULTIVALUED = new BidiMap(){
        {
            this.put(XSD.BOOLEAN, "boolean");
            this.put(XSD.DOUBLE, "pdoubles");
            this.put(XSD.FLOAT, "pfloats");
            this.put(XSD.LONG, "plongs");
            this.put(XSD.INT, "pints");
            this.put(XSD.DATETIME, "pdates");
            this.put(XSD.DATE, "pdates");
            this.put(XSD.GYEARMONTH, "pdates");
            this.put(XSD.GYEAR, "pdates");
        }
    };

    public SolrSchemaGenerator(SolrDriver driver) {
        this.driver = driver;
    }

    private void initialiseSchema() {
        if (this.schemaInitialised || !this.driver.solrIndexExists()) {
            return;
        }
        QueryRequest request = new QueryRequest();
        request.setPath("/schema/fields");
        NamedList<Object> result = this.driver.executeRequest((SolrRequest)request);
        List fields = (List)result.get("fields");
        for (NamedList field : fields) {
            this.existingFields.add((String)field.get("name"));
            this.field2type.put((String)field.get("name"), (String)field.get("type"));
        }
        this.schemaInitialised = true;
    }

    public static SolrSchemaGenerator getNoopInstance(SolrDriver driver) {
        return new SolrSchemaGenerator(driver){
            {
                this.schemaInitialised = true;
            }

            @Override
            public void generateFieldAsNeeded(String fieldName, Value value, Property property) {
            }
        };
    }

    Set<String> getExistingFields() {
        this.initialiseSchema();
        return this.existingFields;
    }

    boolean fieldExists(String field) {
        return this.getExistingFields().contains(field);
    }

    @Nonnull
    SolrRequest[] getRequestsForField(String jsonBody) {
        ContentStreamUpdateRequest ur = new ContentStreamUpdateRequest("/schema");
        ContentStreamBase.StringStream contentStream = new ContentStreamBase.StringStream(jsonBody);
        contentStream.setContentType("application/json");
        ur.addContentStream((ContentStream)contentStream);
        return new SolrRequest[]{ur};
    }

    @Nullable
    String getTypeFromValue(@Nonnull Value value, Property property) {
        if (value instanceof Literal && property.isAnalyzed() && property.isIndexed()) {
            String lang2;
            Literal literalValue = (Literal)value;
            String type = property.getNativeType();
            if (type == null) {
                type = property.isMultivalued() ? (String)XML_TYPE_TO_SOLR_TYPE_MULTIVALUED.get(literalValue.getDatatype()) : (String)XML_TYPE_TO_SOLR_TYPE.get(literalValue.getDatatype());
            }
            if (type != null) {
                return type;
            }
            Optional language = literalValue.getLanguage();
            if (language.isPresent() && (lang2 = (String)language.get()).length() >= 0 && this.solrLanguages.contains(lang2 = lang2.substring(0, 2))) {
                return "text_" + lang2;
            }
            return "text_general";
        }
        return "string";
    }

    public void generateFieldAsNeeded(String fieldName, Value value, Property property) {
        if (this.getExistingFields().contains(fieldName)) {
            return;
        }
        this.getExistingFields().add(fieldName);
        this.field2type.put(fieldName, this.getTypeFromValue(value, property));
        if (this.driver.isTestingTransaction()) {
            SolrRequest[] requests;
            String type = this.getTypeFromValue(value, property);
            String jsonBody = this.generateJsonBody(fieldName, type, property.isIndexed(), property.isStored(), property.isMultivalued());
            for (SolrRequest r : requests = this.getRequestsForField(jsonBody)) {
                this.driver.executeRequest(r);
            }
        }
    }

    @Nonnull
    String generateJsonBody(String fieldName, @Nullable String type, boolean indexed, boolean stored, boolean multivalued) {
        JSONObject addField = new JSONObject();
        JSONObject object = new JSONObject();
        object.put((Object)"name", (Object)fieldName);
        object.put((Object)"type", (Object)type);
        object.put((Object)"indexed", (Object)indexed);
        object.put((Object)"stored", (Object)stored);
        object.put((Object)"multiValued", (Object)multivalued);
        if (!indexed) {
            object.put((Object)"docValues", (Object)false);
        }
        addField.put((Object)"add-field", (Object)object);
        return addField.toString();
    }

    private boolean isTextType(String type) {
        return type.startsWith("text");
    }

    public String getFieldSolrType(String fieldName) {
        return this.field2type.get(fieldName);
    }

    public IRI getFieldXMLType(String fieldName) {
        IRI type = (IRI)XML_TYPE_TO_SOLR_TYPE.get(this.field2type.get(fieldName));
        if (type == null) {
            type = (IRI)XML_TYPE_TO_SOLR_TYPE_MULTIVALUED.get(this.field2type.get(fieldName));
        }
        return type;
    }

    static class BidiMap
    extends HashMap<Object, Object> {
        BidiMap() {
        }

        @Override
        public Object put(Object key, Object value) {
            if (!this.containsKey(value)) {
                super.put(value, key);
            }
            return super.put(key, value);
        }
    }
}

