/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.solr;

import com.ontotext.trree.plugin.externalsync.api.DocumentsResult;
import com.ontotext.trree.plugin.externalsync.api.MapSnippetResults;
import com.ontotext.trree.plugin.externalsync.api.SnippetResult;
import com.ontotext.trree.plugin.externalsync.impl.solr.SolrDriver;
import gnu.trove.TDoubleArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.IntervalFacet;
import org.apache.solr.client.solrj.response.PivotField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.RangeFacet;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.NamedList;
import org.slf4j.Logger;

public class SolrResult
implements DocumentsResult {
    private final String indexName;
    private final Logger logger;
    private final int pageSize;
    private final SolrQuery query;
    private final SolrDriver solrDriver;
    private final List<FacetField> facetFields;
    private final List<RangeFacet> facetRanges;
    private final List<IntervalFacet> facetIntervals;
    private final NamedList<List<PivotField>> nestedFacetFields;
    private final long totalFound;
    private int currentOffset;
    private int userLimit;
    private int userOffset;
    private boolean hasLoopedOnce;
    private QueryResponse currentResponse;
    private SolrDocumentList currentResult;
    private Iterator<SolrDocument> currentResultItr;
    private Map<String, Collection<SnippetResult>> currentSnippetsForEntireResult;
    private String currentSubject;
    private double currentScore;
    private CachedResult cachedResult;

    SolrResult(String indexName, Logger logger, int pageSize, boolean cacheResults, SolrQuery query, SolrDriver solrDriver) {
        this.indexName = indexName;
        this.logger = logger;
        this.pageSize = pageSize;
        this.query = query;
        this.solrDriver = solrDriver;
        this.userLimit = Integer.MAX_VALUE;
        if (query.getRows() != null) {
            this.userLimit = query.getRows();
        }
        if (this.userLimit > pageSize) {
            query.setRows(Integer.valueOf(pageSize));
        }
        this.userOffset = 0;
        if (query.getStart() != null) {
            this.userOffset = query.getStart();
        } else {
            query.setStart(Integer.valueOf(this.userOffset));
        }
        this.currentOffset = this.userOffset;
        this.advancePage();
        this.facetFields = this.currentResponse.getFacetFields();
        this.facetRanges = this.currentResponse.getFacetRanges();
        this.facetIntervals = this.currentResponse.getIntervalFacets();
        this.nestedFacetFields = this.currentResponse.getFacetPivot();
        this.totalFound = this.currentResult.getNumFound();
        this.hasLoopedOnce = false;
        if (cacheResults) {
            this.cachedResult = new CachedResult();
        }
    }

    public List<FacetField> getFacetFields() {
        return this.facetFields;
    }

    public List<RangeFacet> getFacetRanges() {
        return this.facetRanges;
    }

    public List<IntervalFacet> getFacetIntervals() {
        return this.facetIntervals;
    }

    public NamedList<List<PivotField>> getNestedFacetFields() {
        return this.nestedFacetFields;
    }

    public long totalSize() {
        return this.totalFound;
    }

    public double getCurrentScore() {
        return this.currentScore;
    }

    public String getCurrentSubject() {
        return this.currentSubject;
    }

    public Collection<SnippetResult> getCurrentSnippets() {
        return this.currentSnippetsForEntireResult.get(this.currentSubject);
    }

    public boolean next() {
        boolean hasNext = this.currentResultItr.hasNext();
        if (!hasNext && (long)(this.currentOffset + this.pageSize) < this.totalFound && this.currentOffset - this.userOffset + this.pageSize < this.userLimit) {
            this.currentOffset += this.pageSize;
            this.query.setStart(Integer.valueOf(this.currentOffset));
            int remainingRequestedDocuments = this.userLimit - (this.currentOffset - this.userOffset);
            if (remainingRequestedDocuments < this.pageSize) {
                this.query.setRows(Integer.valueOf(remainingRequestedDocuments));
            }
            hasNext = this.advancePage();
        }
        if (hasNext) {
            SolrDocument currentDocument = this.currentResultItr.next();
            this.currentSubject = (String)currentDocument.getFieldValue("id");
            this.currentScore = ((Float)currentDocument.getFieldValue("score")).doubleValue();
            this.logger.debug("[{}] RESULT: {} with score {}", new Object[]{this.indexName, this.currentSubject, this.currentScore});
            if (this.cachedResult != null) {
                this.cachedResult.subjects.add(this.currentSubject);
                this.cachedResult.scores.add(this.currentScore);
            }
        } else {
            this.hasLoopedOnce = true;
        }
        return hasNext;
    }

    private boolean advancePage() {
        this.currentResponse = this.solrDriver.solrQuery(this.query);
        this.currentResult = this.currentResponse.getResults();
        this.currentResultItr = this.currentResult.iterator();
        Map highlighting = this.currentResponse.getHighlighting();
        if (highlighting == null) {
            this.currentSnippetsForEntireResult = Collections.emptyMap();
        } else {
            this.currentSnippetsForEntireResult = new HashMap<String, Collection<SnippetResult>>(highlighting.size());
            highlighting.forEach((id, idHigl) -> this.currentSnippetsForEntireResult.put((String)id, (Collection<SnippetResult>)new MapSnippetResults(idHigl)));
        }
        if (this.cachedResult != null) {
            this.cachedResult.snippetsForEntireResult.putAll(this.currentSnippetsForEntireResult);
        }
        if (this.logger.isDebugEnabled()) {
            String msg = String.format("[%s] It took %s to execute the query %s [limit %d, offset %d] and we got %s documents.", this.indexName, this.currentResponse.getElapsedTime(), this.query, this.query.getRows(), this.query.getStart(), this.currentResult.size());
            this.logger.debug(msg);
        }
        return this.currentResultItr.hasNext();
    }

    public DocumentsResult getDocumentsResult() {
        if (this.hasLoopedOnce) {
            if (this.cachedResult != null) {
                return this.cachedResult;
            }
            this.query.setRows(null);
            this.query.setStart(null);
            return new SolrResult(this.indexName, this.logger, this.pageSize, true, this.query, this.solrDriver);
        }
        return this;
    }

    private class CachedResult
    implements DocumentsResult {
        private final TDoubleArrayList scores = new TDoubleArrayList(1000);
        private final ArrayList<String> subjects = new ArrayList(1000);
        private final Map<String, Collection<SnippetResult>> snippetsForEntireResult = new HashMap<String, Collection<SnippetResult>>();
        private int index = -1;

        CachedResult() {
        }

        public long totalSize() {
            return SolrResult.this.totalFound;
        }

        public double getCurrentScore() {
            return this.scores.get(this.index);
        }

        public String getCurrentSubject() {
            return this.subjects.get(this.index);
        }

        public Collection<SnippetResult> getCurrentSnippets() {
            return this.snippetsForEntireResult.get(this.getCurrentSubject());
        }

        public boolean next() {
            boolean result;
            ++this.index;
            boolean bl = result = this.index < this.subjects.size();
            if (!result) {
                this.index = -1;
            }
            return result;
        }
    }
}

