/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.solr;

import com.ontotext.trree.plugin.externalsync.ExternalSyncPlugin;
import com.ontotext.trree.plugin.externalsync.ExternalSyncRequestContext;
import com.ontotext.trree.plugin.externalsync.api.ConnectorException;
import com.ontotext.trree.plugin.externalsync.api.ConnectorServerException;
import com.ontotext.trree.plugin.externalsync.api.ConnectorUserException;
import com.ontotext.trree.plugin.externalsync.api.ExternalRetrieve;
import com.ontotext.trree.plugin.externalsync.api.SyncDocument;
import com.ontotext.trree.plugin.externalsync.config.Options;
import com.ontotext.trree.plugin.externalsync.impl.AbstractExternalStore;
import com.ontotext.trree.plugin.externalsync.impl.Property;
import com.ontotext.trree.plugin.externalsync.impl.solr.SolrDriver;
import com.ontotext.trree.plugin.externalsync.impl.solr.SolrExternalRetrieve;
import com.ontotext.trree.plugin.externalsync.impl.solr.SolrPlugin;
import com.ontotext.trree.plugin.externalsync.impl.solr.SolrSchemaGenerator;
import com.ontotext.trree.plugin.externalsync.iterators.master.MasterResultIterator;
import com.ontotext.trree.plugin.externalsync.util.EntitiesUtil;
import com.ontotext.trree.plugin.externalsync.util.ValuesUtil;
import com.ontotext.trree.sdk.ClientErrorException;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.HealthResult;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.Statements;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.solr.common.SolrInputDocument;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.XSD;

public final class SolrExternalStore
extends AbstractExternalStore<SolrInputDocument> {
    public static final String FIELD_SUBJECT = "id";
    public static final String FIELD_SCORE = "score";
    private SolrDriver solrDriver;
    private SolrSchemaGenerator schemaGenerator;
    private boolean manageCore;
    private boolean indexedAtLeastOne;

    public static SolrExternalStore open(String name, Options options, SolrPlugin plugin, PluginConnection pluginConnection) {
        return new SolrExternalStore(name, options, false, 0L, plugin, pluginConnection, pluginConnection.getEntities());
    }

    public static SolrExternalStore create(String name, Options options, SolrPlugin plugin, PluginConnection pluginConnection, Entities entitiesForCreation) {
        SolrExternalStore handler = new SolrExternalStore(name, options, true, 0L, plugin, pluginConnection, entitiesForCreation);
        handler.createIndex(true);
        return handler;
    }

    private SolrExternalStore(String name, Options options, boolean wasJustCreated, long initialFingerprint, SolrPlugin plugin, PluginConnection pluginConnection, Entities entities) {
        super(name, options, wasJustCreated, initialFingerprint, (ExternalSyncPlugin)plugin, pluginConnection, entities);
        Boolean manageCore = (Boolean)options.getValue(SolrPlugin.MANAGE_CORE);
        assert (manageCore != null);
        this.manageCore = manageCore;
        this.indexedAtLeastOne = false;
    }

    protected void createIndex(boolean cleanupAfterFailure) {
        try {
            this.init();
            if (this.isTestingTransaction()) {
                boolean indexExists = this.solrDriver.solrIndexExists();
                if (!this.manageCore) {
                    if (!indexExists) {
                        throw new ConnectorUserException("Option manageCore is false but the core " + this.solrDriver.getCoreOrCollectionName() + " does not exist.");
                    }
                } else if (indexExists && cleanupAfterFailure) {
                    this.manageCore = false;
                    throw new ConnectorUserException("Option manageCore is true but the core " + this.solrDriver.getCoreOrCollectionName() + " already exists.");
                }
            }
            this.createIndex();
        }
        catch (Exception e) {
            if (cleanupAfterFailure) {
                try {
                    this.remove(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (e instanceof ConnectorException) {
                throw e;
            }
            throw new ConnectorServerException("Unable to create connector: " + e.getMessage(), (Throwable)e);
        }
    }

    private void createIndex() {
        if (this.manageCore) {
            this.solrDriver.createNewCoreOrCollection((String)this.options.getValue(SolrPlugin.CONFIGS_COPY_FROM));
            Boolean shouldGenerateSchema = (Boolean)this.options.getValue(SolrPlugin.MANAGE_SCHEMA);
            assert (shouldGenerateSchema != null);
            this.schemaGenerator = shouldGenerateSchema != false ? new SolrSchemaGenerator(this.solrDriver) : SolrSchemaGenerator.getNoopInstance(this.solrDriver);
        }
    }

    protected SolrInputDocument newNativeDocument() {
        return new SolrInputDocument();
    }

    protected boolean syncEntity(long subject, long predicate, long context, SyncDocument<SolrInputDocument> syncDoc, List<Property> propertiesToSync, @Nonnull Entities entities, Statements statements, boolean skip) {
        boolean anyProperty = this.syncEntityToDocument(syncDoc, subject, predicate, context, propertiesToSync, entities, statements);
        if (anyProperty) {
            ((SolrInputDocument)syncDoc.nativeDocument).addField(FIELD_SUBJECT, (Object)EntitiesUtil.valueToString((Value)entities.get(subject)));
            if (this.convertSyncDocumentToNativeDocument(syncDoc, propertiesToSync)) {
                try {
                    if (!skip) {
                        this.solrDriver.save((SolrInputDocument)syncDoc.nativeDocument);
                    }
                    this.indexedAtLeastOne = true;
                    return true;
                }
                catch (IOException e) {
                    throw new ClientErrorException("Unable to index document.", (Throwable)e);
                }
            }
        }
        return false;
    }

    protected boolean writePropertyValueToNativeDocument(SolrInputDocument doc, Property property, String fieldName, Value value) {
        Object solrValue;
        this.schemaGenerator.generateFieldAsNeeded(fieldName, value, property);
        String solrType = this.schemaGenerator.getFieldSolrType(fieldName);
        try {
            switch (solrType) {
                case "boolean": {
                    solrValue = this.asLiteral(value).booleanValue();
                    break;
                }
                case "pdouble": 
                case "pdoubles": {
                    solrValue = this.asLiteral(value).doubleValue();
                    break;
                }
                case "pfloat": 
                case "pfloats": {
                    solrValue = Float.valueOf(this.asLiteral(value).floatValue());
                    break;
                }
                case "plong": 
                case "plongs": {
                    solrValue = this.asLiteral(value).longValue();
                    break;
                }
                case "pint": 
                case "pints": {
                    solrValue = this.asLiteral(value).intValue();
                    break;
                }
                case "pdate": 
                case "pdates": {
                    IRI datatype = property.getXsdType();
                    if (datatype == null && (datatype = ((Literal)value).getDatatype()) == null) {
                        datatype = XSD.DATETIME;
                    }
                    solrValue = ValuesUtil.INSTANCE.xsdTemporalAsNormalizedISO(EntitiesUtil.valueToString((Value)value), datatype);
                    break;
                }
                default: {
                    solrValue = EntitiesUtil.valueToString((Value)value);
                    break;
                }
            }
        }
        catch (RuntimeException e) {
            if (property.isIgnoreInvalidValues()) {
                this.notifyIgnoreInvalidValue(fieldName, solrType, value);
                return false;
            }
            throw e;
        }
        if (property.isMultivalued()) {
            doc.addField(fieldName, solrValue);
        } else {
            doc.setField(fieldName, solrValue);
        }
        this.logger.debug("[{}] Indexing: '{}' = '{}'", new Object[]{this.name, fieldName, value});
        return true;
    }

    protected void deleteEntity(long subject, Value subjectValue) {
        this.solrDriver.delete(EntitiesUtil.valueToString((Value)subjectValue));
    }

    public void drop(boolean force) throws Exception {
        block8: {
            block7: {
                if (this.manageCore) {
                    try {
                        this.init();
                    }
                    catch (Exception e) {
                        if (force) break block7;
                        throw e;
                    }
                }
            }
            if (this.manageCore && this.solrDriver != null) {
                try {
                    if (this.solrDriver.solrIndexExists()) {
                        this.solrDriver.deleteCoreOrCollection();
                    }
                }
                catch (Exception e) {
                    if (force) break block8;
                    throw e;
                }
            }
        }
        super.drop(force);
    }

    public String toString() {
        return "solr-index: " + this.name;
    }

    public boolean transactionCompleted(PluginConnection pluginConnection) {
        boolean hasCommitted = false;
        if (this.initialised.get()) {
            this.solrDriver.commit();
            hasCommitted = this.indexedAtLeastOne;
            this.indexedAtLeastOne = false;
        }
        super.transactionCompleted(pluginConnection);
        return hasCommitted;
    }

    public void rollbackCurrent(PluginConnection pluginConnection) throws IOException {
        super.rollbackCurrent(pluginConnection);
        if (this.initialised.get()) {
            this.indexedAtLeastOne = false;
            this.solrDriver.rollback();
        }
    }

    public void rollbackLastCommitted(PluginConnection pluginConnection) throws IOException {
        super.rollbackLastCommitted(pluginConnection);
    }

    public ExternalRetrieve createRetrieve(MasterResultIterator mri, ExternalSyncRequestContext requestContext) {
        this.init();
        return new SolrExternalRetrieve(this.logger, this, mri, requestContext, this.solrDriver, this.schemaGenerator);
    }

    @Nonnull
    public List<String> getSyncedFields() {
        ArrayList<String> result = new ArrayList<String>();
        for (String field : this.schemaGenerator.getExistingFields()) {
            if (!this.isValidFieldName(field, true)) continue;
            result.add(field);
        }
        return result;
    }

    protected boolean isValidFieldNameImplementation(String fieldName, boolean isTopField) {
        return !FIELD_SUBJECT.equals(fieldName) && !FIELD_SCORE.equals(fieldName);
    }

    protected String getNativeTypeFromDatatype(IRI datatype, boolean multivalued) {
        if (datatype.getNamespace().equals("native:")) {
            return datatype.getLocalName();
        }
        if (multivalued) {
            return (String)SolrSchemaGenerator.XML_TYPE_TO_SOLR_TYPE_MULTIVALUED.get(datatype);
        }
        return (String)SolrSchemaGenerator.XML_TYPE_TO_SOLR_TYPE.get(datatype);
    }

    public void removeAllEntities() {
        this.init();
        this.solrDriver.deleteAll();
        super.removeAllEntities();
    }

    protected void closeNetworkResources() {
        try {
            if (this.solrDriver != null) {
                this.solrDriver.close();
            }
        }
        catch (Exception e) {
            this.logger.warn("[" + this.name + "] Error closing Solr connector driver.", (Throwable)e);
        }
    }

    protected void initImpl() {
        this.solrDriver = SolrDriver.from(this.name, this.options, this.logger);
        this.solrDriver.setPlugin(this.plugin);
        Boolean shouldGenerateSchema = (Boolean)this.options.getValue(SolrPlugin.MANAGE_SCHEMA);
        assert (shouldGenerateSchema != null);
        this.schemaGenerator = shouldGenerateSchema != false ? new SolrSchemaGenerator(this.solrDriver) : SolrSchemaGenerator.getNoopInstance(this.solrDriver);
    }

    public HealthResult runHealthCheckInternal() {
        return this.solrDriver.runHealthCheck();
    }

    protected void applyUpdatedOptions() {
        this.solrDriver.applyUpdatableOptions(this.options);
    }
}

