/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.solr;

import com.ontotext.trree.plugin.externalsync.ExternalSyncRequestContext;
import com.ontotext.trree.plugin.externalsync.api.DocumentsResult;
import com.ontotext.trree.plugin.externalsync.api.ExternalStore;
import com.ontotext.trree.plugin.externalsync.api.Facet;
import com.ontotext.trree.plugin.externalsync.api.FlexibleBucket;
import com.ontotext.trree.plugin.externalsync.api.FlexibleBucketItem;
import com.ontotext.trree.plugin.externalsync.impl.AbstractExternalRetrieve;
import com.ontotext.trree.plugin.externalsync.impl.solr.SolrDriver;
import com.ontotext.trree.plugin.externalsync.impl.solr.SolrExternalStore;
import com.ontotext.trree.plugin.externalsync.impl.solr.SolrResult;
import com.ontotext.trree.plugin.externalsync.impl.solr.SolrSchemaGenerator;
import com.ontotext.trree.plugin.externalsync.iterators.master.MasterResultIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.IntervalFacet;
import org.apache.solr.client.solrj.response.PivotField;
import org.apache.solr.client.solrj.response.RangeFacet;
import org.apache.solr.common.util.NamedList;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.slf4j.Logger;

public final class SolrExternalRetrieve
extends AbstractExternalRetrieve {
    private final SolrDriver driver;
    private boolean alreadySearched;
    private SolrResult solrResult = null;
    private DocumentsResult result = null;
    private List<Facet> resultFacets;
    private SolrSchemaGenerator schemaGenerator;

    public SolrExternalRetrieve(Logger logger, SolrExternalStore store, MasterResultIterator mri, ExternalSyncRequestContext requestContext, SolrDriver driver, SolrSchemaGenerator schemaGenerator) {
        super(logger, (ExternalStore)store, mri, requestContext);
        this.driver = driver;
        this.schemaGenerator = schemaGenerator;
    }

    public synchronized void doSearch() {
        NamedList<List<PivotField>> nestedFacetFields;
        List<IntervalFacet> facetIntervals;
        List<RangeFacet> facetRanges;
        if (this.alreadySearched) {
            this.result = this.solrResult.getDocumentsResult();
            return;
        }
        this.solrResult = this.driver.query(this.mri, this.mapFacetFields());
        this.result = this.solrResult.getDocumentsResult();
        this.resultFacets = new ArrayList<Facet>();
        List<FacetField> facetFields = this.solrResult.getFacetFields();
        if (facetFields != null) {
            for (FacetField field : facetFields) {
                for (FacetField.Count c : field.getValues()) {
                    String facetName = field.getName();
                    long facetNameId = this.createRequestEntity(facetName);
                    long facetValue = this.getFacetValueIdFromFieldValue(field.getName(), c.getName());
                    this.resultFacets.add(new Facet(facetNameId, facetValue, c.getCount()));
                    FlexibleBucket fb = this.createBucket(FlexibleBucket.FlexibleBucketType.FACET, this.createRequestBNode(), facetNameId, 0L, 0L);
                    fb.setItem(FlexibleBucketItem.KEY_OR_VALUE, facetValue);
                    fb.setItem(FlexibleBucketItem.COUNT, this.createRequestEntity(c.getCount()));
                    this.faHolder.add(fb);
                }
            }
        }
        if ((facetRanges = this.solrResult.getFacetRanges()) != null) {
            for (RangeFacet range : facetRanges) {
                String rangeName = range.getName();
                long rangeNameId = this.createRequestEntity(rangeName);
                IRI type = this.schemaGenerator.getFieldXMLType(rangeName);
                long rangeStartId = this.createRequestEntity(range.getStart());
                long rangeEndId = this.createRequestEntity(range.getEnd());
                List counts = range.getCounts();
                for (RangeFacet.Count count : counts) {
                    Number between;
                    Number after;
                    String fromValue = count.getValue();
                    long keyId = this.createRequestEntity(fromValue, type);
                    FlexibleBucket fb = this.createBucket(FlexibleBucket.FlexibleBucketType.FIXED_RANGE, this.createRequestBNode(), rangeNameId, 0L, 0L);
                    fb.setItem(FlexibleBucketItem.KEY_OR_VALUE, keyId);
                    fb.setItem(FlexibleBucketItem.FROM, rangeStartId);
                    fb.setItem(FlexibleBucketItem.TO, rangeEndId);
                    fb.setItem(FlexibleBucketItem.COUNT, this.createRequestEntity(count.getCount()));
                    Object gap = range.getGap();
                    fb.setItem(FlexibleBucketItem.RANGE_GAP, this.createRequestEntity(gap));
                    Number before = range.getBefore();
                    if (before != null) {
                        fb.setItem(FlexibleBucketItem.BEFORE_COUNT, this.createRequestEntity(before));
                    }
                    if ((after = range.getAfter()) != null) {
                        fb.setItem(FlexibleBucketItem.AFTER_COUNT, this.createRequestEntity(after));
                    }
                    if ((between = range.getBetween()) != null) {
                        fb.setItem(FlexibleBucketItem.BETWEEN_COUNT, this.createRequestEntity(between));
                    }
                    this.faHolder.add(fb);
                }
            }
        }
        if ((facetIntervals = this.solrResult.getFacetIntervals()) != null) {
            for (IntervalFacet range : facetIntervals) {
                String intervalName = range.getField();
                long intervalNameId = this.createRequestEntity(intervalName);
                List counts = range.getIntervals();
                for (IntervalFacet.Count count : counts) {
                    String bucketName = count.getKey();
                    long bucketNameId = this.createRequestEntity(bucketName);
                    FlexibleBucket fb = this.createBucket(FlexibleBucket.FlexibleBucketType.VARIABLE_RANGE, this.createRequestBNode(), intervalNameId, 0L, 0L);
                    fb.setItem(FlexibleBucketItem.KEY_OR_VALUE, bucketNameId);
                    fb.setItem(FlexibleBucketItem.COUNT, this.createRequestEntity(count.getCount()));
                    this.faHolder.add(fb);
                }
            }
        }
        if ((nestedFacetFields = this.solrResult.getNestedFacetFields()) != null) {
            for (Map.Entry nle : nestedFacetFields) {
                long nameId = this.createRequestEntity(nle.getKey());
                List pivotFields = (List)nle.getValue();
                this.processPivotFieldList(nameId, 1, 0L, pivotFields);
            }
        }
        this.alreadySearched = true;
    }

    private void processPivotFieldList(long nameId, int level, long parentId, List<PivotField> pivotFieldList) {
        for (PivotField pivotField : pivotFieldList) {
            long facetFieldId = this.createRequestEntity(pivotField.getField());
            long facetValueId = this.createRequestEntity(pivotField.getValue());
            long facetCount = pivotField.getCount();
            long id = this.createRequestBNode();
            FlexibleBucket fb = this.createBucket(FlexibleBucket.FlexibleBucketType.FACET, id, nameId, parentId, this.createRequestEntity(level));
            fb.setItem(FlexibleBucketItem.KEY_OR_VALUE, facetValueId);
            fb.setItem(FlexibleBucketItem.COUNT, this.createRequestEntity(facetCount));
            fb.setItem(FlexibleBucketItem.LEVEL_NAME, facetFieldId);
            this.faHolder.add(fb);
            List pivotFieldChildren = pivotField.getPivot();
            if (pivotFieldChildren == null) continue;
            this.processPivotFieldList(nameId, level + 1, id, pivotFieldChildren);
        }
    }

    private List<String> mapFacetFields() {
        ArrayList<String> facetFields = new ArrayList<String>();
        for (String facetField : this.mri.getSearchOptions().facets) {
            if (!this.schemaGenerator.fieldExists(facetField)) continue;
            facetFields.add(facetField);
        }
        return facetFields;
    }

    public synchronized void close() {
    }

    public List<Facet> getFacets() {
        return this.resultFacets;
    }

    public DocumentsResult getDocumentsResult() {
        return this.result;
    }

    private long getFacetValueIdFromFieldValue(String fieldName, String fieldValue) {
        IRI v;
        if (this.externalStore.isFieldURI(fieldName)) {
            v = this.valueFactory.createIRI(fieldValue);
        } else {
            IRI type = this.schemaGenerator.getFieldXMLType(fieldName);
            v = this.valueFactory.createLiteral(fieldValue, type);
        }
        return this.createRequestEntity((Value)v);
    }
}

